/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toClient;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.client.option.MenuAttachabilityCache;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.options.SpecifiedMenuAttachingConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;

public record MenuAttachabilityPayload(boolean defaultAttach, boolean inventoryAttach, Map<MenuType<?>, Boolean> perMenu) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, MenuAttachabilityPayload> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MenuAttachabilityPayload>(){

        public MenuAttachabilityPayload decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return MenuAttachabilityPayload.decode((FriendlyByteBuf)registryFriendlyByteBuf);
        }

        public void encode(RegistryFriendlyByteBuf o, MenuAttachabilityPayload menuAttachabilityPayload) {
            MenuAttachabilityPayload.encode(menuAttachabilityPayload, (FriendlyByteBuf)o);
        }
    };
    public static final CustomPacketPayload.Type<MenuAttachabilityPayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("menu_attachability"));

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    public static MenuAttachabilityPayload of(boolean defaultAttach, SpecifiedMenuAttachingConfig config) {
        return new MenuAttachabilityPayload(defaultAttach, config.isInventoryAttachable(), new HashMap(config.getConfigs()));
    }

    public static void encode(MenuAttachabilityPayload payload, FriendlyByteBuf buf) {
        buf.writeBoolean(payload.defaultAttach);
        buf.writeBoolean(payload.inventoryAttach);
        buf.m_130130_(payload.perMenu.size());
        for (Map.Entry<MenuType<?>, Boolean> e : payload.perMenu.entrySet()) {
            ResourceLocation id = BuiltInRegistries.f_256818_.m_7981_(e.getKey());
            if (id == null) continue;
            buf.m_130085_(id);
            buf.writeBoolean(Boolean.TRUE.equals(e.getValue()));
        }
    }

    public static MenuAttachabilityPayload decode(FriendlyByteBuf buf) {
        boolean def = buf.readBoolean();
        boolean inv = buf.readBoolean();
        int size = buf.m_130242_();
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            boolean val = buf.readBoolean();
            MenuType type = (MenuType)BuiltInRegistries.f_256818_.m_7745_(id);
            if (type == null) continue;
            map.put(type, val);
        }
        return new MenuAttachabilityPayload(def, inv, map);
    }

    @Override
    public String id() {
        return "menu_attachability";
    }

    @Override
    public void handle(ModPacketContext context) {
        if (context.player() == null) {
            return;
        }
        MenuAttachabilityCache.accept(this);
    }
}

