/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.AttachingMonitor;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.mojang.logging.LogUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public record OpenEndInvPayload(boolean openNew, int rows, int columns) implements ModPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenEndInvPayload> STREAM_CODEC = StreamCodec.m_320617_((buf, value) -> OpenEndInvPayload.encode(value, (FriendlyByteBuf)buf), OpenEndInvPayload::decode);
    public static final CustomPacketPayload.Type<OpenEndInvPayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("open_endinv"));

    public OpenEndInvPayload(boolean ofMenu, int rows) {
        this(ofMenu, rows, 9);
    }

    public OpenEndInvPayload() {
        this(false, 6);
    }

    public static void encode(OpenEndInvPayload payload, FriendlyByteBuf o) {
        o.writeBoolean(payload.openNew);
        o.writeInt(payload.rows);
        o.writeInt(payload.columns);
    }

    public static OpenEndInvPayload decode(FriendlyByteBuf o) {
        return new OpenEndInvPayload(o.readBoolean(), o.readInt(), o.readInt());
    }

    @Override
    public String id() {
        return "open_endinv";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext iPayloadContext) {
        ServerPlayer player = (ServerPlayer)iPayloadContext.player();
        if (player == null) {
            return;
        }
        if (player.f_36096_ == player.f_36095_ && this.openNew()) {
            player.m_5893_(EndlessInventoryMenu.provide(this.rows));
        } else if (!this.openNew()) {
            if (!this.checkAttachingStatus(player)) {
                LOGGER.warn("Player unable to open AttachingScreen sent open AS.");
                return;
            }
            ServerLevelEndInv.getEndInvForPlayer((Player)player).ifPresent(endInv -> {
                AttachingMonitor manager = new AttachingMonitor(player.f_36096_, (EndlessInventory)endInv, player);
                ServerLevelEndInv.PAGE_META_DATA_MANAGER.put(player, manager);
                manager.sendEndInvData();
            });
        }
    }

    private boolean checkAttachingStatus(ServerPlayer player) {
        SyncedConfig syncedConfig = ModRegistries.NbtAttachments.getSyncedConfig().getWith((Player)player);
        boolean nbtAttaching = syncedConfig.attaching();
        boolean menuAttachable = ModInfo.getServerConfig().specifiedMenuAttachability().get().attachable((Player)player);
        if (!nbtAttaching) {
            LOGGER.warn("Player with attaching=false nbt sent openAttaching payload.");
            ModRegistries.NbtAttachments.getSyncedConfig().setTo((Player)player, new SyncedConfig(true, syncedConfig.autoPicking()));
        }
        return menuAttachable;
    }
}

