/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public record QuickMoveToPagePayload(int slotId) implements ModPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final StreamCodec<RegistryFriendlyByteBuf, QuickMoveToPagePayload> STREAM_CODEC = StreamCodec.m_320617_((buf, value) -> QuickMoveToPagePayload.encode(value, (FriendlyByteBuf)buf), QuickMoveToPagePayload::decode);
    public static final CustomPacketPayload.Type<QuickMoveToPagePayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("quick_move_page"));

    public static void encode(QuickMoveToPagePayload payload, FriendlyByteBuf o) {
        o.writeInt(payload.slotId);
    }

    public static QuickMoveToPagePayload decode(FriendlyByteBuf o) {
        return new QuickMoveToPagePayload(o.readInt());
    }

    @Override
    public String id() {
        return "quick_move_page";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext iPayloadContext) {
        ServerPlayer player = (ServerPlayer)iPayloadContext.player();
        Optional<EndlessInventory> oendinv = ServerLevelEndInv.getEndInvForPlayer((Player)player);
        Optional<PageMetaDataManager> optional = ServerLevelEndInv.checkAndGetManagerForPlayer(player);
        LOGGER.info("Test: Optional AttachingManager Status: {}", optional);
        if (oendinv.isEmpty()) {
            LOGGER.warn("{}: Player who has not an EndInv quick-moved item to EndInv's page.", (Object)(this.id() + " payload"));
        } else {
            EndlessInventory endinv = oendinv.get();
            AbstractContainerMenu menu = player.f_36096_;
            if (this.slotId >= 0 && this.slotId < menu.f_38839_.size()) {
                Slot slot = menu.m_38853_(this.slotId);
                ItemStack itemStack = slot.m_7993_();
                ItemStack remain = endinv.addItem(itemStack);
                slot.m_269060_(remain);
                slot.m_142406_((Player)player, itemStack);
            } else {
                LOGGER.warn("{}: SlotId in payload exceeded menu's slots.", (Object)(this.id() + " payload"));
            }
        }
    }
}

