/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetStarredPagePayload;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record StarItemPayload(ItemStack stack, boolean isAdding) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, StarItemPayload> STREAM_CODEC = StreamCodec.m_320617_((buf, value) -> StarItemPayload.encode(value, buf), StarItemPayload::decode);
    public static final CustomPacketPayload.Type<StarItemPayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("star_item"));

    public static void encode(StarItemPayload payload, RegistryFriendlyByteBuf o) {
        ItemStack.f_314979_.m_318638_((Object)o, (Object)payload.stack);
        o.writeBoolean(payload.isAdding);
    }

    public static StarItemPayload decode(RegistryFriendlyByteBuf o) {
        return new StarItemPayload((ItemStack)ItemStack.f_314979_.m_318688_((Object)o), o.readBoolean());
    }

    @Override
    public String id() {
        return "star_item";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext iPayloadContext) {
        ServerPlayer player = (ServerPlayer)iPayloadContext.player();
        if (player == null) {
            return;
        }
        ServerLevelEndInv.getEndInvForPlayer((Player)player).ifPresent(endInv -> {
            if (this.isAdding()) {
                endInv.affinities.addStarredItem(this.stack);
            } else {
                endInv.affinities.removeStarredItem(this.stack);
            }
            ModInfo.getPacketDistributor().sendToPlayer(player, new SetStarredPagePayload(endInv.getStarredItems()));
            endInv.setChanged();
        });
    }
}

