/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.util;

import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SearchUtil {
    public static boolean matchesSearch(ItemStack stack, String search) {
        String[] terms;
        if (search == null || search.isEmpty()) {
            return true;
        }
        for (String term : terms = search.toLowerCase(Locale.ROOT).trim().split("\\s+")) {
            if (SearchUtil.matchesSingleTerm(stack, term)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesSingleTerm(ItemStack stack, String term) {
        if (term.startsWith("#")) {
            return SearchUtil.matchesTag(stack, term.substring(1));
        }
        if (term.startsWith("*")) {
            return SearchUtil.matchesId(stack, term.substring(1));
        }
        if (term.startsWith("^")) {
            return SearchUtil.matchesTooltip(stack, term.substring(1));
        }
        if (term.startsWith("@")) {
            return SearchUtil.matchesNamespace(stack, term.substring(1));
        }
        return SearchUtil.matchesName(stack, term);
    }

    private static boolean matchesTag(ItemStack stack, String tagId) {
        return stack.m_204131_().anyMatch(tag -> tag.f_203868_().toString().toLowerCase(Locale.ROOT).contains(tagId));
    }

    private static boolean matchesId(ItemStack stack, String idSearch) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id.toString().toLowerCase(Locale.ROOT).contains(idSearch);
    }

    private static boolean matchesTooltip(ItemStack stack, String tooltipSearch) {
        return stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(tooltipSearch);
    }

    private static boolean matchesName(ItemStack stack, String nameSearch) {
        if (stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(nameSearch)) {
            return true;
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id.m_135815_().toLowerCase(Locale.ROOT).contains(nameSearch);
    }

    private static boolean matchesNamespace(ItemStack stack, String nsSearch) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id.m_135827_().toLowerCase(Locale.ROOT).contains(nsSearch);
    }
}

