/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge;

import com.kwwsyk.endinv.common.AbstractClientModInitializer;
import com.kwwsyk.endinv.common.client.IContainerScreenHelper;
import com.kwwsyk.endinv.common.client.IInputHandler;
import com.kwwsyk.endinv.common.client.KeyMappings;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.forge.client.config.ClientConfig;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;

public class ClientModInitializer
extends AbstractClientModInitializer {
    public static Lazy<KeyMapping> OPEN_MENU_KEY = ClientModInitializer.regKey(KeyMappings.OPEN_MENU);
    public static Lazy<KeyMapping> QUICK_MOVE_KEY = ClientModInitializer.regKey(KeyMappings.QUICK_MOVE);
    public static Lazy<KeyMapping> STAR_ITEM_KEY = ClientModInitializer.regKey(KeyMappings.STAR_ITEM);

    static void init(IEventBus modEventBus) {
        modEventBus.addListener(ClientModInitializer::regKeyMapping);
    }

    private static void regKeyMapping(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)OPEN_MENU_KEY.get());
        event.register((KeyMapping)QUICK_MOVE_KEY.get());
        if (!ModList.get().isLoaded("jei")) {
            event.register((KeyMapping)STAR_ITEM_KEY.get());
        } else {
            STAR_ITEM_KEY = Lazy.of(() -> new KeyMapping(KeyMappings.STAR_ITEM.key(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, KeyMappings.STAR_ITEM.type(), 302, "key.categories.endinv"));
            event.register((KeyMapping)STAR_ITEM_KEY.get());
        }
    }

    private static Lazy<KeyMapping> regKey(KeyMappings.EndInvKey key) {
        return Lazy.of(() -> {
            String string = key.key();
            return new KeyMapping(string, (IKeyConflictContext)(switch (key.condition()) {
                default -> throw new MatchException(null, null);
                case KeyMappings.ActiveCondition.GUI -> KeyConflictContext.GUI;
                case KeyMappings.ActiveCondition.IN_GAME -> KeyConflictContext.IN_GAME;
            }), key.modifier() == KeyMappings.Modifier.CTRL ? KeyModifier.CONTROL : KeyModifier.NONE, key.type(), key.keyCode(), "key.categories.endinv");
        });
    }

    @Override
    protected IClientConfig loadClientConfig() {
        return ClientConfig.CONFIG.INSTANCE;
    }

    @Override
    protected IInputHandler getInputHandler() {
        return new IInputHandler(this){

            @Override
            public boolean isActiveAndMatches(KeyMapping keyMapping, InputConstants.Key key) {
                return keyMapping.isActiveAndMatches(key);
            }

            @Override
            public boolean isActiveAndMatches(KeyMappings.EndInvKey endInvKey, InputConstants.Key key) {
                if (endInvKey.equals(KeyMappings.OPEN_MENU)) {
                    return ((KeyMapping)OPEN_MENU_KEY.get()).isActiveAndMatches(key);
                }
                if (endInvKey.equals(KeyMappings.QUICK_MOVE)) {
                    return ((KeyMapping)QUICK_MOVE_KEY.get()).isActiveAndMatches(key);
                }
                if (endInvKey.equals(KeyMappings.STAR_ITEM)) {
                    return ((KeyMapping)STAR_ITEM_KEY.get()).isActiveAndMatches(key);
                }
                return false;
            }
        };
    }

    @Override
    protected IContainerScreenHelper getScreenHelper() {
        return new IContainerScreenHelper(this){

            @Override
            public int getGuiLeft(AbstractContainerScreen<?> screen) {
                return screen.getGuiLeft();
            }

            @Override
            public int getGuiTop(AbstractContainerScreen<?> screen) {
                return screen.getGuiTop();
            }

            @Override
            public int getGuiXSize(AbstractContainerScreen<?> screen) {
                return screen.getXSize();
            }

            @Override
            public int getGuiYSize(AbstractContainerScreen<?> screen) {
                return screen.getYSize();
            }
        };
    }
}

