/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.IPlatform;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.NbtAttachment;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.network.IPacketDistributor;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.forge.ClientModInitializer;
import com.kwwsyk.endinv.forge.ServerConfig;
import com.kwwsyk.endinv.forge.StartupConfig;
import com.kwwsyk.endinv.forge.client.config.ClientConfig;
import com.kwwsyk.endinv.forge.integrates.clothconfig.ClothConfigIntegration;
import com.kwwsyk.endinv.forge.nbtAttcachment.AttachingCapabilities;
import com.kwwsyk.endinv.forge.nbtAttcachment.IEndInvUuid;
import com.kwwsyk.endinv.forge.nbtAttcachment.ISyncedConfig;
import com.kwwsyk.endinv.forge.network.ModPayloadHandler;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="endless_inventory")
public class ModInitializer
extends AbstractModInitializer {
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"endless_inventory");
    public static final DeferredRegister<MenuType<?>> MENU = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"endless_inventory");

    public ModInitializer(FMLJavaModLoadingContext context) {
        this(context.getModEventBus(), context.getActiveContainer());
    }

    public ModInitializer(IEventBus modEventBus, ModContainer container) {
        ITEM.register(modEventBus);
        MENU.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)StartupConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CONFIG_SPEC);
        if (FMLEnvironment.dist.isClient()) {
            new ClientModInitializer();
            ClientModInitializer.init(modEventBus);
            if (ModList.get().isLoaded("cloth_config")) {
                ClothConfigIntegration.register(container);
            }
        }
    }

    @Override
    protected IPlatform loadOtherPlatformSpecific() {
        return (clcItem, crrItem, slot, action, player, access) -> false;
    }

    @Override
    protected IPacketDistributor loadPacketDistributor() {
        return new IPacketDistributor(this){

            @Override
            public void sendToServer(ModPacketPayload payload) {
                ClientPacketListener netHandler = Minecraft.m_91087_().m_91403_();
                if (netHandler != null) {
                    Packet packet = NetworkDirection.PLAY_TO_SERVER.buildPacket(ModPayloadHandler.getChannel(), (Object)payload);
                    netHandler.m_295327_(packet);
                }
            }

            @Override
            public void sendToPlayer(ServerPlayer player, ModPacketPayload payload) {
                player.f_8906_.m_141995_(NetworkDirection.PLAY_TO_CLIENT.buildPacket(ModPayloadHandler.getChannel(), (Object)payload));
            }

            @Override
            public void sendToAllPlayer(ModPacketPayload payload) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    server.m_6846_().m_11268_(NetworkDirection.PLAY_TO_CLIENT.buildPacket(ModPayloadHandler.getChannel(), (Object)payload));
                }
            }
        };
    }

    @Override
    protected IServerConfig loadServerConfig() {
        return ServerConfig.CONFIG.INSTANCE;
    }

    @Override
    protected AbstractModInitializer.RegistryCallback<Item> itemReg() {
        return new AbstractModInitializer.RegistryCallback<Item>(this){

            @Override
            public <R extends Item> Supplier<R> register(String id, Supplier<R> supplier) {
                return ITEM.register(id, supplier);
            }
        };
    }

    @Override
    protected AbstractModInitializer.RegistryCallback<MenuType<?>> menuReg() {
        return new AbstractModInitializer.RegistryCallback<MenuType<?>>(this){

            @Override
            public <R extends MenuType<?>> Supplier<R> register(String id, Supplier<R> supplier) {
                return MENU.register(id, supplier);
            }
        };
    }

    @Override
    protected Supplier<MenuType<EndlessInventoryMenu>> createEndInvMenuType() {
        return () -> new MenuType(EndlessInventoryMenu::createClient, FeatureFlags.f_244332_);
    }

    @Override
    protected NbtAttachment<UUID> createEndInvUUID(String name) {
        return new NbtAttachment<UUID>(this){

            @Override
            public UUID getWith(Player player) {
                Optional opt = player.getCapability(AttachingCapabilities.END_INV_UUID).resolve();
                return opt.map(IEndInvUuid::getUuid).orElse(ModInfo.DEFAULT_UUID);
            }

            @Override
            public void setTo(Player player, UUID uuid) {
                Optional opt = player.getCapability(AttachingCapabilities.END_INV_UUID).resolve();
                opt.ifPresent(endInvUuid -> endInvUuid.setUuid(uuid));
            }

            @Override
            public UUID computeIfAbsent(Player player) {
                return player.getCapability(AttachingCapabilities.END_INV_UUID).resolve().map(IEndInvUuid::getUuid).orElse(ModInfo.DEFAULT_UUID);
            }
        };
    }

    @Override
    protected NbtAttachment<SyncedConfig> createSyncedConfig(String name) {
        return new NbtAttachment<SyncedConfig>(this){

            @Override
            public SyncedConfig getWith(Player player) {
                return player.getCapability(AttachingCapabilities.END_INV_CONFIG).resolve().map(ISyncedConfig::getSyncedConfig).orElse(SyncedConfig.DEFAULT);
            }

            @Override
            public void setTo(Player player, SyncedConfig syncedConfig) {
                player.getCapability(AttachingCapabilities.END_INV_CONFIG).resolve().ifPresent(config -> config.setSyncedConfig(syncedConfig));
            }

            @Override
            public SyncedConfig computeIfAbsent(Player player) {
                return player.getCapability(AttachingCapabilities.END_INV_CONFIG).resolve().map(ISyncedConfig::getSyncedConfig).orElse(SyncedConfig.DEFAULT);
            }
        };
    }
}

