/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.events;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.network.payloads.toClient.MenuAttachabilityPayload;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.common.options.SpecifiedMenuAttachingConfig;
import com.kwwsyk.endinv.forge.ServerConfig;
import com.kwwsyk.endinv.forge.nbtAttcachment.AttachingCapabilities;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endless_inventory")
public class PlayerEvents {
    public static boolean tickRefresh = true;

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (tickRefresh) {
                ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, ModRegistries.NbtAttachments.getSyncedConfig().getWith((Player)serverPlayer));
                IServerConfig serverCfg = ModInfo.getServerConfig();
                SpecifiedMenuAttachingConfig menuCfg = serverCfg.specifiedMenuAttachability().get();
                boolean defaultAttach = serverCfg.enableAttaching().get();
                ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, new MenuAttachabilityPayload(defaultAttach, menuCfg.isInventoryAttachable(), menuCfg.getConfigs()));
                if (ServerConfig.CONFIG.TRANSFER_MODE.get() == ContentTransferMode.ALL) {
                    ServerLevelEndInv.getEndInvForPlayer((Player)serverPlayer).ifPresent(endInv -> {
                        ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, new EndInvContent(endInv.getItemMap()));
                        ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, EndInvMetadata.getWith(endInv));
                    });
                }
                tickRefresh = false;
            }
        }
    }

    @SubscribeEvent
    public static void onRespawnClone(PlayerEvent.Clone event) {
        tickRefresh = true;
        if (!event.isWasDeath()) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        try {
            oldPlayer.reviveCaps();
            oldPlayer.getCapability(AttachingCapabilities.END_INV_UUID).ifPresent(oldCap -> newPlayer.getCapability(AttachingCapabilities.END_INV_UUID).ifPresent(newCap -> newCap.setUuid(oldCap.getUuid())));
            oldPlayer.getCapability(AttachingCapabilities.END_INV_CONFIG).ifPresent(oldCap -> newPlayer.getCapability(AttachingCapabilities.END_INV_CONFIG).ifPresent(newCap -> {
                newCap.setSyncedConfig(oldCap.getSyncedConfig());
                ModInfo.getPacketDistributor().sendToPlayer((ServerPlayer)newPlayer, oldCap.getSyncedConfig());
            }));
        }
        finally {
            oldPlayer.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onJoinLevel(PlayerEvent.PlayerLoggedInEvent event) {
        tickRefresh = true;
    }
}

