/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.integrates.jei;

import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.forge.client.events.ScreenAttachment;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IClickableIngredientFactory;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class AttachmentGuiHandler
implements IGuiContainerHandler<AbstractContainerScreen<?>> {
    static final Logger LOGGER = LogUtils.getLogger();
    private final IJeiHelpers jeiHelper;

    public AttachmentGuiHandler(IJeiHelpers jeiHelpers) {
        this.jeiHelper = jeiHelpers;
    }

    public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
        AttachingScreen<?> attachingScreen = ScreenAttachment.ATTACHMENT_MANAGER;
        if (attachingScreen != null) {
            return attachingScreen.getArea();
        }
        return super.getGuiExtraAreas(containerScreen);
    }

    public Optional<? extends IClickableIngredient<?>> getClickableIngredientUnderMouse(IClickableIngredientFactory builder, AbstractContainerScreen<?> containerScreen, double mouseX, double mouseY) {
        int absY;
        int localY;
        ScreenFramework sf = ScreenFramework.getInstance();
        if (sf == null) {
            return Optional.empty();
        }
        DisplayPage page = sf.getDisplayingPage();
        ItemStack hovered = page.getHoveredOrClickedItem(mouseX, mouseY);
        if (hovered == null || hovered.m_41619_()) {
            return Optional.empty();
        }
        int localX = (int)Math.floor(mouseX - (double)page.getPageLeft());
        Rect2i area = page.getOneInteractableArea(localX, localY = (int)Math.floor(mouseY - (double)page.getPageTop()));
        if (area == null) {
            return Optional.empty();
        }
        int absX = (int)Math.floor(mouseX);
        if (!area.m_110087_(absX, absY = (int)Math.floor(mouseY))) {
            return Optional.empty();
        }
        return Optional.of(new ItemClickEventWrapper(hovered, area));
    }

    public class ItemClickEventWrapper
    implements IClickableIngredient<ItemStack> {
        private final ItemStack hovered;
        private final Rect2i area;

        public ItemClickEventWrapper(ItemStack hovered, Rect2i area) {
            this.hovered = hovered;
            this.area = area;
        }

        public IIngredientType<ItemStack> getIngredientType() {
            return VanillaTypes.ITEM_STACK;
        }

        public ItemStack getIngredient() {
            return this.hovered;
        }

        public Rect2i getArea() {
            return this.area;
        }

        public ITypedIngredient<ItemStack> getTypedIngredient() {
            return AttachmentGuiHandler.this.jeiHelper.getIngredientManager().createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.hovered, true).orElse(new ITypedIngredient<ItemStack>(){

                public IIngredientType<ItemStack> getType() {
                    return VanillaTypes.ITEM_STACK;
                }

                public ItemStack getIngredient() {
                    return ItemClickEventWrapper.this.hovered;
                }
            });
        }
    }
}

