/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.integrates.jei;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.forge.network.payloads.JeiTransferRecipePayload;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class EIMRecipeTranHandler
implements IRecipeTransferHandler<EndlessInventoryMenu, RecipeHolder<CraftingRecipe>> {
    private static final Class<EndlessInventoryMenu> CONTAINER_CLASS = EndlessInventoryMenu.class;
    private static final MenuType<EndlessInventoryMenu> CONTAINER_TYPE = ModRegistries.Menus.getEndInvMenuType();
    private final IJeiHelpers jeiHelper;
    private final IRecipeTransferHandlerHelper transferHelper;
    private final IRecipeTransferInfo<EndlessInventoryMenu, RecipeHolder<CraftingRecipe>> playerInvInfo;

    public EIMRecipeTranHandler(IJeiHelpers jeiHelper, IRecipeTransferHandlerHelper transferHelper) {
        this.jeiHelper = jeiHelper;
        this.transferHelper = transferHelper;
        this.playerInvInfo = this.createPlayerInvInfo();
    }

    private IRecipeTransferInfo<EndlessInventoryMenu, RecipeHolder<CraftingRecipe>> createPlayerInvInfo() {
        return this.transferHelper.createBasicRecipeTransferInfo(CONTAINER_CLASS, CONTAINER_TYPE, RecipeTypes.CRAFTING, 0, 9, 10, 36);
    }

    public Class<EndlessInventoryMenu> getContainerClass() {
        return CONTAINER_CLASS;
    }

    public Optional<MenuType<EndlessInventoryMenu>> getMenuType() {
        return Optional.of(CONTAINER_TYPE);
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        try {
            if (!new EIMRecipeTranInfo().canHandle(container, recipe)) {
                return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237113_((String)"Unsupported container or recipe"));
            }
            if (!container.isCrafterEnabled()) {
                return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237113_((String)"Crafter is disabled by server rules"));
            }
            TransferPlan plan = EIMRecipeTranHandler.createTransferPlan(container, (CraftingRecipe)recipe.f_291008_(), maxTransfer);
            boolean missing = plan.isMissing();
            if (!doTransfer) {
                return missing ? this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237113_((String)"Missing ingredient(s)")) : null;
            }
            if (player.m_9236_().f_46443_) {
                container.setCraftingVisible(true);
                ModInfo.getPacketDistributor().sendToServer(new JeiTransferRecipePayload(container.f_38840_, recipe.f_291676_(), maxTransfer));
            } else {
                EIMRecipeTranHandler.performTransfer(container, (CraftingRecipe)recipe.f_291008_(), plan, player);
            }
            return missing ? this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237113_((String)"Missing ingredient(s)")) : null;
        }
        catch (Exception e) {
            return this.transferHelper.createInternalError();
        }
    }

    public static void performServerTransfer(EndlessInventoryMenu container, CraftingRecipe recipe, Player player, boolean maxTransfer) {
        TransferPlan plan = EIMRecipeTranHandler.createTransferPlan(container, recipe, maxTransfer);
        EIMRecipeTranHandler.performTransfer(container, recipe, plan, player);
    }

    private static boolean sameType(ItemStack a, ItemStack b) {
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        return ItemStack.m_322370_((ItemStack)a, (ItemStack)b);
    }

    private static Ingredient[] buildRecipeLayout(CraftingRecipe recipe) {
        Object[] layout = new Ingredient[9];
        Arrays.fill(layout, Ingredient.f_43901_);
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int width = Math.min(3, shaped.m_44220_());
            int height = Math.min(3, shaped.m_44221_());
            NonNullList ingredients = shaped.m_7527_();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int srcIndex = y * shaped.m_44220_() + x;
                    if (srcIndex >= ingredients.size()) continue;
                    layout[y * 3 + x] = (Ingredient)ingredients.get(srcIndex);
                }
            }
        } else {
            NonNullList ingredients = recipe.m_7527_();
            for (int i = 0; i < Math.min(ingredients.size(), layout.length); ++i) {
                layout[i] = (Ingredient)ingredients.get(i);
            }
        }
        return layout;
    }

    @Nullable
    private static ItemCounts countAvailableOfType(ItemStack type, ItemAvailability availability) {
        if (type.m_41619_()) {
            return null;
        }
        return availability.lookup(ItemKey.asKey(type));
    }

    private static Selection chooseBestCandidate(Ingredient ing, ItemAvailability availability, Reservation reservation) {
        Candidate best = Candidate.NONE;
        HashSet<ItemKey> seen = new HashSet<ItemKey>();
        for (ItemStack cand : ing.m_43908_()) {
            ItemCounts counts = EIMRecipeTranHandler.countAvailableOfType(cand, availability);
            Candidate candidate = Candidate.fromCounts(counts, reservation);
            if (!candidate.isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        for (ItemCounts counts : availability.all()) {
            Candidate candidate;
            if (!ing.test(counts.representative()) || !(candidate = Candidate.fromCounts(counts, reservation)).isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        return best.selection();
    }

    private static TransferPlan createTransferPlan(EndlessInventoryMenu container, CraftingRecipe recipe, boolean maxTransfer) {
        int craftsPossible;
        Ingredient[] layout = EIMRecipeTranHandler.buildRecipeLayout(recipe);
        List<Slot> playerInvSlots = container.getPlayerInvSlots();
        List<ItemStack> pageItems = container.getSourceInventory().getItemsAsList();
        ItemAvailability availability = ItemAvailability.build(playerInvSlots, pageItems);
        Reservation reservation = new Reservation();
        Object[] chosenPerSlot = new ItemStack[layout.length];
        Arrays.fill(chosenPerSlot, ItemStack.f_41583_);
        boolean missing = false;
        int perSlotStackLimit = Integer.MAX_VALUE;
        for (int i = 0; i < layout.length; ++i) {
            Ingredient ing = layout[i];
            if (ing.m_43947_()) continue;
            Selection selection = EIMRecipeTranHandler.chooseBestCandidate(ing, availability, reservation);
            if (selection.isEmpty()) {
                missing = true;
                continue;
            }
            reservation.reserve(selection);
            chosenPerSlot[i] = selection.stack();
            perSlotStackLimit = Math.min(perSlotStackLimit, selection.stack().m_41741_());
        }
        if (missing || reservation.isEmpty()) {
            craftsPossible = 0;
        } else {
            craftsPossible = Integer.MAX_VALUE;
            for (Map.Entry entry : reservation.totalDemand().entrySet()) {
                ItemCounts counts = availability.lookup((ItemKey)entry.getKey());
                if (counts == null) {
                    craftsPossible = 0;
                    missing = true;
                    break;
                }
                int possible = counts.total() / (Integer)entry.getValue();
                craftsPossible = Math.min(craftsPossible, possible);
            }
            if (craftsPossible == Integer.MAX_VALUE) {
                craftsPossible = 0;
            }
        }
        if (perSlotStackLimit == Integer.MAX_VALUE) {
            perSlotStackLimit = 64;
        }
        int craftsWanted = maxTransfer ? Math.min(craftsPossible, perSlotStackLimit) : (craftsPossible > 0 ? 1 : 0);
        boolean bl = missing || craftsWanted <= 0;
        return new TransferPlan(layout, (ItemStack[])chosenPerSlot, craftsWanted, bl);
    }

    private static void performTransfer(EndlessInventoryMenu container, CraftingRecipe recipe, TransferPlan plan, Player player) {
        container.setCraftingVisible(true);
        List<Slot> craftingSlots = container.getCraftingSlots();
        for (Slot cSlot : craftingSlots) {
            ItemStack removed;
            int count;
            if (!cSlot.m_6657_() || (count = cSlot.m_7993_().m_41613_()) <= 0 || (removed = cSlot.m_150647_(count, count, player)).m_41619_()) continue;
            player.m_150109_().m_150079_(removed);
        }
        List<Slot> playerInvSlots = container.getPlayerInvSlots();
        Ingredient[] layout = plan.layout();
        for (int i = 0; i < Math.min(craftingSlots.size(), layout.length); ++i) {
            Ingredient ing = layout[i];
            if (ing.m_43947_()) continue;
            Slot target = craftingSlots.get(i);
            int toTake = plan.craftsWanted();
            if (toTake <= 0) continue;
            ItemStack chosen = plan.chosenPerSlot()[i];
            ItemStack placedStack = ItemStack.f_41583_;
            for (Slot invSlot : playerInvSlots) {
                ItemStack taken;
                int can;
                if (toTake <= 0) break;
                if (!invSlot.m_6657_()) continue;
                ItemStack in = invSlot.m_7993_();
                if (!(chosen.m_41619_() ? ing.test(in) : EIMRecipeTranHandler.sameType(chosen, in)) || (can = Math.min(toTake, in.m_41613_())) <= 0 || (taken = invSlot.m_150647_(can, can, player)).m_41619_()) continue;
                if (placedStack.m_41619_()) {
                    placedStack = taken;
                } else if (EIMRecipeTranHandler.sameType(placedStack, taken)) {
                    placedStack.m_41769_(taken.m_41613_());
                } else {
                    player.m_150109_().m_150079_(taken);
                    break;
                }
                toTake -= taken.m_41613_();
            }
            if (toTake > 0) {
                ItemStack extracted;
                ItemStack template;
                ItemStack itemStack = !chosen.m_41619_() ? chosen : (template = ing.m_43908_().length > 0 ? ing.m_43908_()[0] : ItemStack.f_41583_);
                if (!template.m_41619_() && !(extracted = container.tryExtractFromPage(template, toTake)).m_41619_()) {
                    if (placedStack.m_41619_()) {
                        placedStack = extracted;
                    } else if (EIMRecipeTranHandler.sameType(placedStack, extracted)) {
                        placedStack.m_41769_(extracted.m_41613_());
                    } else {
                        player.m_150109_().m_150079_(extracted);
                    }
                    toTake -= extracted.m_41613_();
                }
            }
            if (placedStack.m_41619_()) continue;
            int cap = Math.min(placedStack.m_41741_(), target.m_6641_());
            if (placedStack.m_41613_() > cap) {
                ItemStack overflow = placedStack.m_255036_(placedStack.m_41613_() - cap);
                placedStack.m_41764_(cap);
                player.m_150109_().m_150079_(overflow);
            }
            target.m_5852_(placedStack);
        }
    }

    public class EIMRecipeTranInfo
    implements IRecipeTransferInfo<EndlessInventoryMenu, RecipeHolder<CraftingRecipe>> {
        public Class<? extends EndlessInventoryMenu> getContainerClass() {
            return CONTAINER_CLASS;
        }

        public Optional<MenuType<EndlessInventoryMenu>> getMenuType() {
            return Optional.of(CONTAINER_TYPE);
        }

        public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
            return RecipeTypes.CRAFTING;
        }

        public boolean canHandle(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe) {
            return EIMRecipeTranHandler.this.playerInvInfo.canHandle((AbstractContainerMenu)container, recipe);
        }

        public List<Slot> getRecipeSlots(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe) {
            return container.getCraftingSlots();
        }

        public List<Slot> getInventorySlots(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe) {
            return container.getPlayerInvSlots();
        }
    }

    private record TransferPlan(Ingredient[] layout, ItemStack[] chosenPerSlot, int craftsWanted, boolean missing) {
        boolean isMissing() {
            return this.missing;
        }
    }

    private static final class ItemAvailability {
        private final Map<ItemKey, ItemCounts> counts = new HashMap<ItemKey, ItemCounts>();

        private ItemAvailability() {
        }

        static ItemAvailability build(List<Slot> invSlots, List<ItemStack> pageItems) {
            ItemAvailability availability = new ItemAvailability();
            for (Slot slot : invSlots) {
                if (!slot.m_6657_()) continue;
                availability.add(slot.m_7993_(), Source.INVENTORY);
            }
            for (ItemStack stack : pageItems) {
                if (stack.m_41619_()) continue;
                availability.add(stack, Source.PAGE);
            }
            return availability;
        }

        private void add(ItemStack stack, Source source) {
            ItemKey key = ItemKey.asKey(stack);
            ItemCounts counts = this.counts.computeIfAbsent(key, k -> new ItemCounts((ItemKey)k, stack.m_255036_(1)));
            counts.add(stack.m_41613_(), source);
        }

        @Nullable
        ItemCounts lookup(ItemKey key) {
            return this.counts.get(key);
        }

        Collection<ItemCounts> all() {
            return this.counts.values();
        }

        private static enum Source {
            INVENTORY,
            PAGE;

        }
    }

    private static final class ItemCounts {
        private final ItemKey key;
        private final ItemStack representative;
        private int inventoryCount;
        private int pageCount;

        ItemCounts(ItemKey key, ItemStack representative) {
            this.key = key;
            this.representative = representative;
        }

        void add(int amount, ItemAvailability.Source source) {
            if (source == ItemAvailability.Source.INVENTORY) {
                this.inventoryCount += amount;
            } else {
                this.pageCount += amount;
            }
        }

        ItemKey key() {
            return this.key;
        }

        ItemStack representative() {
            return this.representative.m_41777_();
        }

        int total() {
            return this.inventoryCount + this.pageCount;
        }

        int totalRemaining(Reservation reservation) {
            return this.total() - reservation.totalReserved(this.key);
        }

        int inventoryRemaining(Reservation reservation) {
            return this.inventoryCount - reservation.inventoryReserved(this.key);
        }

        boolean isPlain() {
            return this.key.components().m_323586_();
        }
    }

    private record Candidate(@Nullable Selection selection, int priority, int totalRemaining, int inventoryRemaining) {
        private static final Candidate NONE = new Candidate(Selection.EMPTY, -1, 0, 0);

        boolean isValid() {
            if (this.selection != null) {
                return !this.selection.isEmpty();
            }
            return false;
        }

        static Candidate fromCounts(@Nullable ItemCounts counts, Reservation reservation) {
            boolean hasPlainInventory;
            if (counts == null) {
                return NONE;
            }
            int totalRemaining = counts.totalRemaining(reservation);
            if (totalRemaining <= 0) {
                return NONE;
            }
            int inventoryRemaining = counts.inventoryRemaining(reservation);
            boolean hasInventory = inventoryRemaining > 0;
            boolean bl = hasPlainInventory = hasInventory && counts.isPlain();
            int priority = hasPlainInventory ? 3 : (hasInventory ? 2 : 1);
            Selection selection = new Selection(counts.representative(), counts.key(), hasInventory);
            return new Candidate(selection, priority, totalRemaining, inventoryRemaining);
        }

        static Candidate pickBetter(Candidate current, Candidate challenger) {
            if (!challenger.isValid()) {
                return current;
            }
            if (!current.isValid()) {
                return challenger;
            }
            if (challenger.priority != current.priority) {
                return challenger.priority > current.priority ? challenger : current;
            }
            if (challenger.totalRemaining != current.totalRemaining) {
                return challenger.totalRemaining > current.totalRemaining ? challenger : current;
            }
            if (challenger.inventoryRemaining != current.inventoryRemaining) {
                return challenger.inventoryRemaining > current.inventoryRemaining ? challenger : current;
            }
            return current;
        }
    }

    private static final class Reservation {
        private final Map<ItemKey, Integer> total = new HashMap<ItemKey, Integer>();
        private final Map<ItemKey, Integer> inventory = new HashMap<ItemKey, Integer>();

        private Reservation() {
        }

        void reserve(Selection selection) {
            this.total.merge(selection.key(), 1, Integer::sum);
            if (selection.useInventory()) {
                this.inventory.merge(selection.key(), 1, Integer::sum);
            }
        }

        int totalReserved(ItemKey key) {
            return this.total.getOrDefault(key, 0);
        }

        int inventoryReserved(ItemKey key) {
            return this.inventory.getOrDefault(key, 0);
        }

        Map<ItemKey, Integer> totalDemand() {
            return this.total;
        }

        boolean isEmpty() {
            return this.total.isEmpty();
        }
    }

    private record Selection(ItemStack stack, ItemKey key, boolean useInventory) {
        static final Selection EMPTY = new Selection(ItemStack.f_41583_, null, false);

        boolean isEmpty() {
            return this.stack.m_41619_();
        }
    }
}

