/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.integrates.jei.experimental;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.forge.client.events.ScreenAttachment;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public final class AEIRecipeTransferHandler {
    private AEIRecipeTransferHandler() {
    }

    public static <C extends AbstractContainerMenu, R> Optional<TransferContext> prepareClientContext(C container, R recipe, IRecipeSlotsView recipeSlotsView, Player player, boolean maxTransfer, IRecipeTransferInfo<C, R> transferInfo, List<Slot> recipeSlots, List<Slot> inventorySlots) {
        ResourceLocation recipeId;
        SourceInventory endInv = AEIRecipeTransferHandler.getClientAttachedInventory(container);
        if (endInv == null && ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.ALL) {
            endInv = CachedSrcInv.INSTANCE;
        }
        Ingredient[] layout = AEIRecipeTransferHandler.buildLayoutFromRecipeSlots(recipeSlotsView, recipeSlots.size());
        TransferPlan plan = null;
        if (endInv != null) {
            if (AEIRecipeTransferHandler.allEmpty(layout) && recipe instanceof Recipe) {
                Recipe mcRecipe = (Recipe)recipe;
                plan = AEIRecipeTransferHandler.createTransferPlan(mcRecipe, recipeSlots, inventorySlots, endInv, maxTransfer);
            } else {
                plan = AEIRecipeTransferHandler.createTransferPlan(layout, recipeSlots, inventorySlots, endInv, maxTransfer);
            }
            if (plan.isMissing() || plan.craftsWanted() <= 0) {
                return Optional.empty();
            }
        }
        if ((recipeId = AEIRecipeTransferHandler.tryResolveRecipeId(recipe)) == null) {
            recipeId = ResourceLocation.m_339182_((String)"endless_inventory", (String)("jei/unknown/" + container.f_38840_));
        }
        boolean requireCompleteSets = transferInfo.requireCompleteSets(container, recipe);
        List<Integer> craftingIndexes = recipeSlots.stream().map(slot -> slot.f_40219_).toList();
        List<Integer> inventoryIndexes = inventorySlots.stream().map(slot -> slot.f_40219_).toList();
        return Optional.of(new TransferContext(container.f_38840_, recipeId, maxTransfer, requireCompleteSets, craftingIndexes, inventoryIndexes));
    }

    @Nullable
    private static SourceInventory getClientAttachedInventory(AbstractContainerMenu container) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            return null;
        }
        return ClientAccess.getAttachedInventory(container);
    }

    public static void performServerTransfer(AbstractContainerMenu container, Recipe<?> recipe, List<Slot> recipeSlots, List<Slot> inventorySlots, ServerPlayer player, @Nullable PageMetaDataManager manager, boolean maxTransfer, boolean requireCompleteSets) {
        SourceInventory endInv;
        if (manager != null && manager.getMenu() == container) {
            endInv = manager.getSourceInventory();
        } else {
            Optional<EndlessInventory> opt = ServerLevelEndInv.getEndInvForPlayer((Player)player);
            if (opt.isEmpty()) {
                return;
            }
            endInv = opt.get();
        }
        TransferPlan plan = AEIRecipeTransferHandler.createTransferPlan(recipe, recipeSlots, inventorySlots, endInv, maxTransfer);
        if (plan.isMissing() || plan.craftsWanted() <= 0) {
            return;
        }
        AEIRecipeTransferHandler.performTransfer(container, plan, (Player)player, recipeSlots, inventorySlots, endInv);
        if (manager != null) {
            manager.sendEndInvData();
        } else {
            ContentTransferMode mode = ModInfo.getServerConfig().transferMode().get();
            switch (mode) {
                case ALL: {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new EndInvContent(endInv.getItemMap()));
                    break;
                }
                case PART: {
                    ModInfo.getPacketDistributor().sendToPlayer(player, EndInvMetadata.getWith((EndlessInventory)endInv));
                }
            }
        }
    }

    @Nullable
    public static PageMetaDataManager getServerManager(ServerPlayer player) {
        return ServerLevelEndInv.checkAndGetManagerForPlayer(player).orElse(null);
    }

    private static TransferPlan createTransferPlan(Recipe<?> recipe, List<Slot> recipeSlots, List<Slot> inventorySlots, SourceInventory endInv, boolean maxTransfer) {
        Ingredient[] layout = AEIRecipeTransferHandler.buildRecipeLayout(recipe, recipeSlots.size());
        return AEIRecipeTransferHandler.createTransferPlan(layout, recipeSlots, inventorySlots, endInv, maxTransfer);
    }

    private static TransferPlan createTransferPlan(Ingredient[] layout, List<Slot> recipeSlots, List<Slot> inventorySlots, SourceInventory endInv, boolean maxTransfer) {
        int craftsPossible;
        List<ItemStack> pageItems = endInv.getItemsAsList();
        ItemAvailability availability = ItemAvailability.build(Collections.emptyList(), pageItems);
        Reservation reservation = new Reservation();
        Object[] chosenPerSlot = new ItemStack[layout.length];
        Arrays.fill(chosenPerSlot, ItemStack.f_41583_);
        boolean missing = false;
        int perSlotStackLimit = Integer.MAX_VALUE;
        for (int i = 0; i < layout.length; ++i) {
            Ingredient ing = layout[i];
            if (ing.m_43947_()) continue;
            Selection selection = AEIRecipeTransferHandler.chooseBestCandidate(ing, availability, reservation);
            if (selection.isEmpty()) {
                missing = true;
                continue;
            }
            reservation.reserve(selection);
            chosenPerSlot[i] = selection.stack();
            perSlotStackLimit = Math.min(perSlotStackLimit, selection.stack().m_41741_());
        }
        if (missing || reservation.isEmpty()) {
            craftsPossible = 0;
        } else {
            craftsPossible = Integer.MAX_VALUE;
            for (Map.Entry entry : reservation.totalDemand().entrySet()) {
                ItemCounts counts = availability.lookup((ItemKey)entry.getKey());
                if (counts == null) {
                    craftsPossible = 0;
                    missing = true;
                    break;
                }
                int possible = counts.total() / (Integer)entry.getValue();
                craftsPossible = Math.min(craftsPossible, possible);
            }
            if (craftsPossible == Integer.MAX_VALUE) {
                craftsPossible = 0;
            }
        }
        if (perSlotStackLimit == Integer.MAX_VALUE) {
            perSlotStackLimit = 64;
        }
        int craftsWanted = maxTransfer ? Math.min(craftsPossible, perSlotStackLimit) : (craftsPossible > 0 ? 1 : 0);
        boolean bl = missing || craftsWanted <= 0;
        return new TransferPlan(layout, (ItemStack[])chosenPerSlot, craftsWanted, bl);
    }

    private static void performTransfer(AbstractContainerMenu container, TransferPlan plan, Player player, List<Slot> recipeSlots, List<Slot> inventorySlots, SourceInventory endInv) {
        for (Slot cSlot : recipeSlots) {
            ItemStack removed;
            int count;
            if (!cSlot.m_6657_() || (count = cSlot.m_7993_().m_41613_()) <= 0 || (removed = cSlot.m_150647_(count, count, player)).m_41619_()) continue;
            player.m_150109_().m_150079_(removed);
        }
        Ingredient[] layout = plan.layout();
        for (int i = 0; i < Math.min(recipeSlots.size(), layout.length); ++i) {
            Object extracted;
            ItemStack template;
            Ingredient ing = layout[i];
            if (ing.m_43947_()) continue;
            Slot target = recipeSlots.get(i);
            int toTake = plan.craftsWanted();
            if (toTake <= 0) continue;
            ItemStack chosen = plan.chosenPerSlot()[i];
            Object placedStack = ItemStack.f_41583_;
            ItemStack itemStack = !chosen.m_41619_() ? chosen : (template = ing.m_43908_().length > 0 ? ing.m_43908_()[0] : ItemStack.f_41583_);
            if (!template.m_41619_() && !(extracted = endInv.takeItem(template, toTake)).m_41619_()) {
                if (placedStack.m_41619_()) {
                    placedStack = extracted;
                } else if (AEIRecipeTransferHandler.sameType(placedStack, (ItemStack)extracted)) {
                    placedStack.m_41769_(extracted.m_41613_());
                } else {
                    player.m_150109_().m_150079_((ItemStack)extracted);
                }
                toTake -= extracted.m_41613_();
            }
            if (toTake > 0) {
                extracted = inventorySlots.iterator();
                while (extracted.hasNext()) {
                    ItemStack taken;
                    int can;
                    Slot invSlot = (Slot)extracted.next();
                    if (toTake <= 0) break;
                    if (!invSlot.m_6657_()) continue;
                    ItemStack in = invSlot.m_7993_();
                    if (!(chosen.m_41619_() ? ing.test(in) : AEIRecipeTransferHandler.sameType(chosen, in)) || (can = Math.min(toTake, in.m_41613_())) <= 0 || (taken = invSlot.m_150647_(can, can, player)).m_41619_()) continue;
                    if (placedStack.m_41619_()) {
                        placedStack = taken;
                    } else if (AEIRecipeTransferHandler.sameType(placedStack, taken)) {
                        placedStack.m_41769_(taken.m_41613_());
                    } else {
                        player.m_150109_().m_150079_(taken);
                        break;
                    }
                    toTake -= taken.m_41613_();
                }
            }
            if (placedStack.m_41619_()) continue;
            int cap = Math.min(placedStack.m_41741_(), target.m_6641_());
            if (placedStack.m_41613_() > cap) {
                ItemStack overflow = placedStack.m_255036_(placedStack.m_41613_() - cap);
                placedStack.m_41764_(cap);
                player.m_150109_().m_150079_(overflow);
            }
            target.m_5852_(placedStack);
        }
        container.m_38946_();
    }

    private static boolean sameType(ItemStack a, ItemStack b) {
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        return ItemStack.m_322370_((ItemStack)a, (ItemStack)b);
    }

    private static Ingredient[] buildRecipeLayout(Recipe<?> recipe, int targetSlots) {
        Object[] layout = new Ingredient[targetSlots];
        Arrays.fill(layout, Ingredient.f_43901_);
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int gridW = targetSlots == 9 ? 3 : (targetSlots == 4 ? 2 : shaped.m_44220_());
            int gridH = gridW > 0 ? targetSlots / gridW : 0;
            int width = Math.min(gridW, shaped.m_44220_());
            int height = Math.min(gridH, shaped.m_44221_());
            NonNullList ingredients = shaped.m_7527_();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int srcIndex = y * shaped.m_44220_() + x;
                    int dstIndex = y * gridW + x;
                    if (srcIndex >= ingredients.size() || dstIndex >= targetSlots) continue;
                    layout[dstIndex] = (Ingredient)ingredients.get(srcIndex);
                }
            }
        } else {
            NonNullList ingredients = recipe.m_7527_();
            for (int i = 0; i < Math.min(ingredients.size(), layout.length); ++i) {
                layout[i] = (Ingredient)ingredients.get(i);
            }
        }
        return layout;
    }

    private static Ingredient[] buildLayoutFromRecipeSlots(IRecipeSlotsView slotsView, int targetSlots) {
        Object[] layout = new Ingredient[targetSlots];
        Arrays.fill(layout, Ingredient.f_43901_);
        int i = 0;
        List lst = slotsView.getSlotViews(RecipeIngredientRole.INPUT);
        for (IRecipeSlotView slotView1 : lst) {
            if (i >= targetSlots) break;
            List<ItemStack> stacks = slotView1.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList();
            if (!stacks.isEmpty()) {
                layout[i] = Ingredient.m_43927_((ItemStack[])stacks.toArray(new ItemStack[0]));
            }
            ++i;
        }
        return layout;
    }

    private static boolean allEmpty(Ingredient[] layout) {
        for (Ingredient ing : layout) {
            if (ing.m_43947_()) continue;
            return false;
        }
        return true;
    }

    private static Selection chooseBestCandidate(Ingredient ing, ItemAvailability availability, Reservation reservation) {
        Candidate best = Candidate.NONE;
        HashSet<ItemKey> seen = new HashSet<ItemKey>();
        for (ItemStack cand : ing.m_43908_()) {
            ItemCounts counts = AEIRecipeTransferHandler.countAvailableOfType(cand, availability);
            Candidate candidate = Candidate.fromCounts(counts, reservation);
            if (!candidate.isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        for (ItemCounts counts : availability.all()) {
            Candidate candidate;
            if (!ing.test(counts.representative()) || !(candidate = Candidate.fromCounts(counts, reservation)).isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        return best.selection();
    }

    @Nullable
    private static ItemCounts countAvailableOfType(ItemStack type, ItemAvailability availability) {
        if (type.m_41619_()) {
            return null;
        }
        return availability.lookup(ItemKey.asKey(type));
    }

    @Nullable
    private static ResourceLocation tryResolveRecipeId(Object recipeObj) {
        try {
            Method m = recipeObj.getClass().getMethod("getId", new Class[0]);
            Object v = m.invoke(recipeObj, new Object[0]);
            if (v instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)v;
                return rl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private record TransferPlan(Ingredient[] layout, ItemStack[] chosenPerSlot, int craftsWanted, boolean missing) {
        boolean isMissing() {
            return this.missing;
        }
    }

    public record TransferContext(int containerId, ResourceLocation recipeId, boolean maxTransfer, boolean requireCompleteSets, List<Integer> craftingSlotIndexes, List<Integer> inventorySlotIndexes) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientAccess {
        private ClientAccess() {
        }

        @Nullable
        private static SourceInventory getAttachedInventory(AbstractContainerMenu container) {
            AttachingScreen<?> attachment = ScreenAttachment.ATTACHMENT_MANAGER;
            if (attachment == null) {
                if (ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.ALL) {
                    return CachedSrcInv.INSTANCE;
                }
                return null;
            }
            if (Minecraft.m_91087_().f_91074_ == null) {
                return null;
            }
            if (attachment.getScreen().m_6262_() != container) {
                return null;
            }
            return attachment.getFrameWork().getSourceInventory();
        }
    }

    private static final class ItemAvailability {
        private final Map<ItemKey, ItemCounts> counts = new HashMap<ItemKey, ItemCounts>();

        private ItemAvailability() {
        }

        static ItemAvailability build(List<Slot> invSlots, List<ItemStack> pageItems) {
            ItemAvailability availability = new ItemAvailability();
            for (Slot slot : invSlots) {
                if (!slot.m_6657_()) continue;
                availability.add(slot.m_7993_(), Source.INVENTORY);
            }
            for (ItemStack stack : pageItems) {
                if (stack.m_41619_()) continue;
                availability.add(stack, Source.PAGE);
            }
            return availability;
        }

        private void add(ItemStack stack, Source source) {
            ItemKey key = ItemKey.asKey(stack);
            ItemCounts counts = this.counts.computeIfAbsent(key, k -> new ItemCounts((ItemKey)k, stack.m_255036_(1)));
            counts.add(stack.m_41613_(), source);
        }

        @Nullable
        ItemCounts lookup(ItemKey key) {
            return this.counts.get(key);
        }

        Collection<ItemCounts> all() {
            return this.counts.values();
        }

        private static enum Source {
            INVENTORY,
            PAGE;

        }
    }

    private static final class Reservation {
        private final Map<ItemKey, Integer> total = new HashMap<ItemKey, Integer>();
        private final Map<ItemKey, Integer> inventory = new HashMap<ItemKey, Integer>();

        private Reservation() {
        }

        void reserve(Selection selection) {
            if (selection.key() == null) {
                return;
            }
            this.total.merge(selection.key(), 1, Integer::sum);
            if (selection.useInventory()) {
                this.inventory.merge(selection.key(), 1, Integer::sum);
            }
        }

        int totalReserved(ItemKey key) {
            return this.total.getOrDefault(key, 0);
        }

        int inventoryReserved(ItemKey key) {
            return this.inventory.getOrDefault(key, 0);
        }

        Map<ItemKey, Integer> totalDemand() {
            return this.total;
        }

        boolean isEmpty() {
            return this.total.isEmpty();
        }
    }

    private record Selection(ItemStack stack, ItemKey key, boolean useInventory) {
        static final Selection EMPTY = new Selection(ItemStack.f_41583_, null, false);

        boolean isEmpty() {
            return this.stack.m_41619_();
        }
    }

    private static final class ItemCounts {
        private final ItemKey key;
        private final ItemStack representative;
        private int inventoryCount;
        private int pageCount;

        ItemCounts(ItemKey key, ItemStack representative) {
            this.key = key;
            this.representative = representative;
        }

        void add(int amount, ItemAvailability.Source source) {
            if (source == ItemAvailability.Source.INVENTORY) {
                this.inventoryCount += amount;
            } else {
                this.pageCount += amount;
            }
        }

        ItemKey key() {
            return this.key;
        }

        ItemStack representative() {
            return this.representative.m_41777_();
        }

        int total() {
            return this.inventoryCount + this.pageCount;
        }

        int totalRemaining(Reservation reservation) {
            return this.total() - reservation.totalReserved(this.key);
        }

        int inventoryRemaining(Reservation reservation) {
            return this.inventoryCount - reservation.inventoryReserved(this.key);
        }

        boolean isPlain() {
            return this.key.components() != null && !this.key.components().m_323586_();
        }
    }

    private record Candidate(Selection selection, int priority, int totalRemaining, int inventoryRemaining) {
        private static final Candidate NONE = new Candidate(Selection.EMPTY, -1, 0, 0);

        boolean isValid() {
            return this.selection != null && !this.selection.isEmpty();
        }

        static Candidate fromCounts(@Nullable ItemCounts counts, Reservation reservation) {
            boolean hasPlainInventory;
            if (counts == null) {
                return NONE;
            }
            int totalRemaining = counts.totalRemaining(reservation);
            if (totalRemaining <= 0) {
                return NONE;
            }
            int inventoryRemaining = counts.inventoryRemaining(reservation);
            boolean hasInventory = inventoryRemaining > 0;
            boolean bl = hasPlainInventory = hasInventory && counts.isPlain();
            int priority = hasPlainInventory ? 3 : (hasInventory ? 2 : 1);
            Selection selection = new Selection(counts.representative(), counts.key(), hasInventory);
            return new Candidate(selection, priority, totalRemaining, inventoryRemaining);
        }

        static Candidate pickBetter(Candidate current, Candidate challenger) {
            if (!challenger.isValid()) {
                return current;
            }
            if (!current.isValid()) {
                return challenger;
            }
            if (challenger.priority != current.priority) {
                return challenger.priority > current.priority ? challenger : current;
            }
            if (challenger.totalRemaining != current.totalRemaining) {
                return challenger.totalRemaining > current.totalRemaining ? challenger : current;
            }
            if (challenger.inventoryRemaining != current.inventoryRemaining) {
                return challenger.inventoryRemaining > current.inventoryRemaining ? challenger : current;
            }
            return current;
        }
    }
}

