/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.integrates.jei.experimental.mixin;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.forge.integrates.jei.experimental.AEIRecipeTransferHandler;
import com.kwwsyk.endinv.forge.network.payloads.JeiAttachedTransferPayload;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PlayToServerPacket;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.library.transfer.BasicRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.TestOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BasicRecipeTransferHandler.class})
public abstract class BasicRecipeTransferHandlerMixin<C extends AbstractContainerMenu, R> {
    @Final
    @Shadow(remap=false)
    private IRecipeTransferInfo<C, R> transferInfo;
    @Unique
    private static final ThreadLocal<AEIRecipeTransferHandler.TransferContext> ENDINV$PLAN = new ThreadLocal();
    @Unique
    private static final ThreadLocal<Boolean> ENDINV$ALLOW_BUTTON = new ThreadLocal();
    @Unique
    @TestOnly
    private static boolean ENDINV$TEMP_ALWAYS_COSMETIC_WHEN_ALL = true;

    @Inject(method={"transferRecipe"}, at={@At(value="INVOKE_ASSIGN", target="Lmezz/jei/common/transfer/RecipeTransferUtil;getRecipeTransferOperations(Lmezz/jei/api/helpers/IStackHelper;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)Lmezz/jei/common/transfer/RecipeTransferOperationsResult;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void endinv$handleMissing(C container, R recipe, IRecipeSlotsView recipeSlotsView, Player player, boolean maxTransfer, boolean doTransfer, CallbackInfoReturnable<IRecipeTransferError> cir, List<Slot> craftingSlots, List<Slot> inventorySlots, List<IRecipeSlotsView> inputItemSlotViews, BasicRecipeTransferHandler.InventoryState inventoryState, int inputCount, RecipeTransferOperationsResult transferOperations) {
        Optional<AEIRecipeTransferHandler.TransferContext> context = AEIRecipeTransferHandler.prepareClientContext(container, recipe, recipeSlotsView, player, maxTransfer, this.transferInfo, craftingSlots, inventorySlots);
        if (context.isPresent()) {
            transferOperations.missingItems.clear();
            if (doTransfer) {
                ENDINV$PLAN.set(context.get());
            } else {
                ENDINV$ALLOW_BUTTON.set(Boolean.TRUE);
            }
        } else {
            ENDINV$PLAN.remove();
            ENDINV$ALLOW_BUTTON.remove();
        }
    }

    @Redirect(method={"transferRecipe"}, at=@At(value="INVOKE", target="Lmezz/jei/common/network/IConnectionToServer;sendPacketToServer(Lmezz/jei/common/network/packets/PlayToServerPacket;)V"), remap=false)
    private void endinv$redirectTransferPacket(IConnectionToServer connection, PlayToServerPacket packet) {
        AEIRecipeTransferHandler.TransferContext context = ENDINV$PLAN.get();
        if (context != null) {
            ENDINV$PLAN.remove();
            ModInfo.getPacketDistributor().sendToServer(new JeiAttachedTransferPayload(context));
        } else {
            connection.sendPacketToServer(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"transferRecipe"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void endinv$clearPlan(CallbackInfoReturnable<IRecipeTransferError> cir) {
        try {
            IRecipeTransferError err;
            Boolean allow = ENDINV$ALLOW_BUTTON.get();
            if (allow != null && allow.booleanValue() && cir.getReturnValue() != null) {
                cir.setReturnValue(null);
            }
            if (ENDINV$TEMP_ALWAYS_COSMETIC_WHEN_ALL && ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.ALL && (err = (IRecipeTransferError)cir.getReturnValue()) != null) {
                cir.setReturnValue(() -> IRecipeTransferError.Type.COSMETIC);
            }
        }
        finally {
            ENDINV$PLAN.remove();
            ENDINV$ALLOW_BUTTON.remove();
        }
    }
}

