/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.network;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.MenuAttachabilityPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetItemDisplayContentPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetStarredPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.network.payloads.toServer.OpenEndInvPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.QuickMoveToPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ToggleCraftingPayload;
import com.kwwsyk.endinv.forge.ModInitializer;
import com.kwwsyk.endinv.forge.network.payloads.JeiAttachedTransferPayload;
import com.kwwsyk.endinv.forge.network.payloads.JeiTransferRecipePayload;
import java.util.function.BiConsumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;

@Mod.EventBusSubscriber(modid="endless_inventory", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModPayloadHandler {
    private static final ResourceLocation id = ModInitializer.withModLocation("channel");
    private static Channel<CustomPacketPayload> channel;

    private static void regChannel() {
        PayloadProtocol channel0 = ChannelBuilder.named((ResourceLocation)AbstractModInitializer.withModLocation("channel")).networkProtocolVersion(1).optional().payloadChannel().play();
        PayloadFlow channelB = ((PayloadFlow)channel0.bidirectional()).add(SyncedConfig.TYPE, SyncedConfig.STREAM_CODEC, ModPayloadHandler.convertBi(SyncedConfig::handle));
        PayloadFlow channelC = ((PayloadFlow)channelB.clientbound()).add(EndInvMetadata.TYPE, EndInvMetadata.STREAM_CODEC, ModPayloadHandler.convertClient(EndInvMetadata::handle)).add(ItemPickedUpPayload.TYPE, ItemPickedUpPayload.STREAM_CODEC, ModPayloadHandler.convertClient(ItemPickedUpPayload::handle)).add(SetItemDisplayContentPayload.TYPE, SetItemDisplayContentPayload.STREAM_CODEC, ModPayloadHandler.convertClient(SetItemDisplayContentPayload::handle)).add(SetStarredPagePayload.TYPE, SetStarredPagePayload.STREAM_CODEC, ModPayloadHandler.convertClient(SetStarredPagePayload::handle)).add(EndInvContent.TYPE, EndInvContent.STREAM_CODEC, ModPayloadHandler.convertClient(EndInvContent::handle)).add(MenuAttachabilityPayload.TYPE, MenuAttachabilityPayload.STREAM_CODEC, ModPayloadHandler.convertClient(MenuAttachabilityPayload::handle));
        PayloadFlow channelS = ((PayloadFlow)channelC.serverbound()).add(ItemClickPayload.TYPE, ItemClickPayload.STREAM_CODEC, ModPayloadHandler.convert(ItemClickPayload::handle)).add(CreativeItemModPayload.TYPE, CreativeItemModPayload.STREAM_CODEC, ModPayloadHandler.convert(CreativeItemModPayload::handle)).add(ItemPageContext.TYPE, ItemPageContext.STREAM_CODEC, ModPayloadHandler.convert(ItemPageContext::handle)).add(OpenEndInvPayload.TYPE, OpenEndInvPayload.STREAM_CODEC, ModPayloadHandler.convert(OpenEndInvPayload::handle)).add(QuickMoveToPagePayload.TYPE, QuickMoveToPagePayload.STREAM_CODEC, ModPayloadHandler.convert(QuickMoveToPagePayload::handle)).add(StarItemPayload.TYPE, StarItemPayload.STREAM_CODEC, ModPayloadHandler.convert(StarItemPayload::handle)).add(ToggleCraftingPayload.TYPE, ToggleCraftingPayload.STREAM_CODEC, ModPayloadHandler.convert(ToggleCraftingPayload::handle));
        if (ModList.get().isLoaded("jei")) {
            channelS.add(JeiTransferRecipePayload.TYPE, JeiTransferRecipePayload.STREAM_CODEC, ModPayloadHandler.convert(JeiTransferRecipePayload::handle)).add(JeiAttachedTransferPayload.TYPE, JeiAttachedTransferPayload.STREAM_CODEC, ModPayloadHandler.convert(JeiAttachedTransferPayload::handle));
        }
        channel = channelS.build();
    }

    public static <MSG> BiConsumer<MSG, CustomPayloadEvent.Context> convert(BiConsumer<MSG, ModPacketContext> handler) {
        return (msg, sup) -> {
            sup.enqueueWork(() -> handler.accept(msg, () -> ((CustomPayloadEvent.Context)sup).getSender()));
            sup.setPacketHandled(true);
        };
    }

    public static <MSG> BiConsumer<MSG, CustomPayloadEvent.Context> convertClient(BiConsumer<MSG, ModPacketContext> handler) {
        return (msg, sup) -> {
            sup.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> handler.accept(msg, () -> ((CustomPayloadEvent.Context)sup).getSender())));
            sup.setPacketHandled(true);
        };
    }

    public static <MSG> BiConsumer<MSG, CustomPayloadEvent.Context> convertBi(BiConsumer<MSG, ModPacketContext> handler) {
        return (msg, cxt) -> {
            cxt.enqueueWork(() -> {
                ServerPlayer sender = cxt.getSender();
                if (sender != null) {
                    handler.accept(msg, () -> sender);
                } else {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> handler.accept(msg, () -> ((CustomPayloadEvent.Context)cxt).getSender()));
                }
            });
            cxt.setPacketHandled(true);
        };
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModPayloadHandler::regChannel);
    }

    public static Channel<CustomPacketPayload> getChannel() {
        return channel;
    }
}

