/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.network.payloads;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.forge.integrates.jei.EIMRecipeTranHandler;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraftforge.fml.ModList;

public record JeiTransferRecipePayload(int containerId, ResourceLocation recipeId, boolean maxTransfer) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, JeiTransferRecipePayload> STREAM_CODEC = StreamCodec.m_320617_((buf, value) -> JeiTransferRecipePayload.encode(value, (FriendlyByteBuf)buf), JeiTransferRecipePayload::decode);
    public static final CustomPacketPayload.Type<JeiTransferRecipePayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("jei_transfer_recipe"));

    public static void encode(JeiTransferRecipePayload payload, FriendlyByteBuf buffer) {
        buffer.m_130130_(payload.containerId);
        buffer.m_130085_(payload.recipeId);
        buffer.writeBoolean(payload.maxTransfer);
    }

    public static JeiTransferRecipePayload decode(FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        ResourceLocation recipeId = buffer.m_130281_();
        boolean maxTransfer = buffer.readBoolean();
        return new JeiTransferRecipePayload(containerId, recipeId, maxTransfer);
    }

    @Override
    public String id() {
        return "jei_transfer_recipe";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!ModList.get().isLoaded("jei")) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
        if (!(abstractContainerMenu instanceof EndlessInventoryMenu)) {
            return;
        }
        EndlessInventoryMenu menu = (EndlessInventoryMenu)abstractContainerMenu;
        if (menu.f_38840_ != this.containerId) {
            return;
        }
        Optional optional = serverPlayer.m_284548_().m_7465_().m_44043_(this.recipeId);
        optional.ifPresent(recipeObj -> {
            CraftingRecipe craftingRecipe = JeiTransferRecipePayload.resolveCraftingRecipe(recipeObj);
            if (craftingRecipe != null) {
                EIMRecipeTranHandler.performServerTransfer(menu, craftingRecipe, (Player)serverPlayer, this.maxTransfer);
            }
        });
    }

    private static CraftingRecipe resolveCraftingRecipe(Object recipeObj) {
        if (recipeObj instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipeObj;
            return craftingRecipe;
        }
        try {
            Object value = recipeObj.getClass().getMethod("value", new Class[0]).invoke(recipeObj, new Object[0]);
            if (value instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)value;
                return craftingRecipe;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

