/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.autopick;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.autopick.events.IBlockBreakEvent;
import com.kwwsyk.endinv.common.autopick.events.ILivingDropsEvent;
import com.kwwsyk.endinv.common.autopick.events.ILivingExpDropsEvent;
import com.kwwsyk.endinv.common.autopick.events.IPlayerPickupItemEvent;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class AutoPickHelper {
    public static boolean isEnabled(Player player) {
        return AutoPickHelper.isPlayerEnabledAutoPick(player) && ModInfo.getServerConfig().enableAutoPick().get() != false;
    }

    private static boolean isPlayerEnabledAutoPick(Player player) {
        return ModRegistries.NbtAttachments.getSyncedConfig().getWith(player).autoPicking();
    }

    public static void onLivingDrops(ILivingDropsEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (AutoPickHelper.isEnabled((Player)player)) {
            EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
            if (endInv == null) {
                return;
            }
            boolean flag = true;
            for (ItemEntity drop : event.getDrops()) {
                ItemStack stack = drop.m_32055_();
                ItemStack remain = endInv.addItem(stack);
                stack.m_41620_(remain.m_41613_());
                if (!stack.m_41619_()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack));
                }
                if (remain.m_41619_()) {
                    drop.m_142687_(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                drop.m_32045_(remain);
                flag = false;
            }
            if (flag) {
                event.setCanceled(true);
            }
        }
    }

    public static void onExpDrops(ILivingExpDropsEvent event) {
        Player player = event.getAttackingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!AutoPickHelper.isEnabled((Player)player2)) {
                return;
            }
            int exp = event.getDroppedExperience();
            int newValue = AutoPickHelper.repairPlayerItems((Player)player2, exp);
            player2.m_6756_(newValue);
            event.setCanceled(true);
        }
    }

    public static void onBlockBreak(IBlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!AutoPickHelper.isEnabled((Player)player2)) {
            return;
        }
        EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player2).orElse(null);
        if (endInv == null) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player2, (ItemStack)player2.m_21205_());
        if (event.getExpToDrop() > 0) {
            int exp = event.getExpToDrop();
            int repaired = AutoPickHelper.repairPlayerItems((Player)player2, exp);
            player2.m_6756_(repaired);
            event.setExpToDrop(0);
        }
        boolean allPicked = true;
        for (ItemStack drop : drops) {
            ItemStack remain = endInv.addItem(drop.m_41777_());
            drop.m_41774_(remain.m_41613_());
            if (!drop.m_41619_()) {
                ModInfo.getPacketDistributor().sendToPlayer(player2, new ItemPickedUpPayload(drop));
            }
            if (remain.m_41619_()) continue;
            allPicked = false;
            level.m_7967_((Entity)new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, remain));
        }
        if (allPicked) {
            event.setCanceled(true);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static void onPickupItem(IPlayerPickupItemEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || !AutoPickHelper.isEnabled((Player)(player = (ServerPlayer)player2))) {
            return;
        }
        ItemEntity entity = event.getItem();
        if (entity.m_32063_()) {
            return;
        }
        ItemStack stack = entity.m_32055_();
        if (AutoPickHelper.shouldMoveTo((Player)player, stack)) {
            ServerLevelEndInv.getEndInvForPlayer((Player)player).ifPresent(endInv -> {
                ItemStack remain = endInv.addItem(stack.m_41777_());
                if (!stack.m_41619_()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack.m_41777_()));
                }
                if (remain.m_41619_()) {
                    stack.m_41764_(0);
                } else {
                    stack.m_41620_(remain.m_41613_());
                }
            });
        }
    }

    private static boolean shouldMoveTo(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            return AutoPickHelper.hasSuch(player, (Item)swordItem);
        }
        if (item instanceof AxeItem) {
            AxeItem axeItem = (AxeItem)item;
            return AutoPickHelper.hasSuch(player, (Item)axeItem);
        }
        if (item instanceof PickaxeItem) {
            PickaxeItem such = (PickaxeItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ShovelItem) {
            ShovelItem such = (ShovelItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof HoeItem) {
            HoeItem such = (HoeItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof TridentItem) {
            TridentItem such = (TridentItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ShieldItem) {
            ShieldItem such = (ShieldItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ShearsItem) {
            ShearsItem such = (ShearsItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof BoatItem) {
            BoatItem such = (BoatItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ElytraItem) {
            ElytraItem such = (ElytraItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof BowItem) {
            BowItem such = (BowItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof CrossbowItem) {
            CrossbowItem such = (CrossbowItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return AutoPickHelper.hasOrSwearing(player, armorItem);
        }
        return !AutoPickHelper.canMerge(player, stack);
    }

    private static boolean canMerge(Player player, ItemStack stack) {
        return player.f_36095_.f_38839_.stream().anyMatch(slot -> ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)stack));
    }

    private static boolean hasSuch(Player player, Item item) {
        return player.f_36095_.f_38839_.stream().anyMatch(slot -> slot.m_7993_().m_41720_().getClass() == item.getClass());
    }

    private static boolean hasOrSwearing(Player player, ArmorItem armor) {
        EquipmentSlot slot = armor.m_40402_();
        ItemStack equipped = player.m_6844_(slot);
        if (equipped.m_41619_()) {
            return player.f_36095_.f_38839_.stream().anyMatch(slt -> {
                ArmorItem a1;
                Item patt9029$temp = slt.m_7993_().m_41720_();
                return patt9029$temp instanceof ArmorItem && (a1 = (ArmorItem)patt9029$temp).m_40402_() == slot;
            });
        }
        return true;
    }

    private static int repairPlayerItems(Player player, int repairAmount) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, (LivingEntity)player, ItemStack::m_41768_);
        if (entry != null) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            int i = Math.min((int)((float)repairAmount * itemstack.getXpRepairRatio()), itemstack.m_41773_());
            itemstack.m_41721_(itemstack.m_41773_() - i);
            int j = repairAmount - i / 2;
            return j > 0 ? AutoPickHelper.repairPlayerItems(player, j) : 0;
        }
        return repairAmount;
    }
}

