/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.data.EndInvCodecStrategy;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class FullCodecStrategy
implements EndInvCodecStrategy {
    @Override
    public boolean canHandle(CompoundTag tag) {
        ListTag list = tag.m_128437_("Items", 10);
        return !list.isEmpty() && list.m_128728_(0).m_128441_("modState");
    }

    @Override
    public void deserializeItems(EndlessInventory endlessInventory, CompoundTag nbt) {
        Map<ItemKey, ItemState> itemMap = endlessInventory.getItemMap();
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.m_128728_(i);
            Optional<ItemStack> stackPre = EndInvCodecStrategy.parse((Tag)itemTag).filter(it -> !it.m_41619_());
            long modState = itemTag.m_128454_("modState");
            endlessInventory.updateModState(modState);
            stackPre.ifPresent(itemStack -> itemMap.put(ItemKey.asKey(itemStack), new ItemState(itemStack.m_41613_(), modState)));
        }
    }

    @Override
    public CompoundTag serializeItems(EndlessInventory endlessInventory) {
        ListTag nbtTagList = new ListTag();
        Map<ItemKey, ItemState> itemMap = endlessInventory.getItemMap();
        for (Map.Entry<ItemKey, ItemState> entry : itemMap.entrySet()) {
            ItemStack itemStack = entry.getKey().toStack(entry.getValue().count());
            if (itemStack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128356_("modState", entry.getValue().lastModTime());
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack, itemTag));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", itemMap.size());
        return nbt;
    }
}

