/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.integrates.jei;

import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.forge.client.events.ScreenAttachment;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;

public class AttachmentGuiHandler
implements IGuiContainerHandler<AbstractContainerScreen<?>> {
    static final Logger LOGGER = LogUtils.getLogger();

    public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
        AttachingScreen<?> attachingScreen = ScreenAttachment.ATTACHMENT_MANAGER;
        if (attachingScreen != null) {
            return attachingScreen.getArea();
        }
        return super.getGuiExtraAreas(containerScreen);
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AbstractContainerScreen<?> containerScreen, double mouseX, double mouseY) {
        if (ScreenFramework.getInstance() != null) {
            DisplayPage page = ScreenFramework.getInstance().getDisplayingPage();
            if (page.getOneInteractableArea(mouseX - (double)page.getPageLeft(), mouseY - (double)page.getPageTop()) == null) {
                return Optional.empty();
            }
            return Optional.of(new ItemClickEventWrapper(page, mouseX, mouseY));
        }
        return Optional.empty();
    }

    public static class ItemClickEventWrapper
    implements IClickableIngredient<ItemStack> {
        DisplayPage page;
        ItemStack hovered;
        Rect2i hoveredSlotArea;

        public ItemClickEventWrapper(DisplayPage page, double mouseX, double mouseY) {
            this.page = page;
            this.hovered = page.getHoveredOrClickedItem(mouseX, mouseY);
            this.hoveredSlotArea = page.getOneInteractableArea(mouseX - (double)page.getPageLeft(), mouseY - (double)page.getPageTop());
            try {
                this.checkStatus(mouseX, mouseY);
            }
            catch (Exception e) {
                LOGGER.error("Check click area failed: ", (Throwable)e);
            }
        }

        @Deprecated
        public ITypedIngredient<ItemStack> getTypedIngredient() {
            return new ITypedIngredient<ItemStack>(){

                public IIngredientType<ItemStack> getType() {
                    return this.getIngredientType();
                }

                public ItemStack getIngredient() {
                    return this.getIngredient();
                }
            };
        }

        public IIngredientType<ItemStack> getIngredientType() {
            return VanillaTypes.ITEM_STACK;
        }

        public ItemStack getIngredient() {
            return this.hovered;
        }

        public Rect2i getArea() {
            return this.hoveredSlotArea;
        }

        @TestOnly
        private void checkStatus(double mouseX, double mouseY) {
            Rect2i area = this.getArea();
            if (!area.m_110087_((int)mouseX, (int)mouseY)) {
                throw new IllegalStateException("The area does not contain clicked pos");
            }
        }
    }
}

