/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.IPlatform;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.NbtAttachment;
import com.kwwsyk.endinv.common.item.ScreenDebugger;
import com.kwwsyk.endinv.common.item.TestEndInv;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.network.IPacketDistributor;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.options.IServerConfig;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;

public abstract class AbstractModInitializer {
    public static final ResourceKey<Registry<PageType>> PAGE_REG_KEY = ResourceKey.createRegistryKey((ResourceLocation)AbstractModInitializer.withModLocation("display_page"));

    public static ResourceLocation withModLocation(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"endless_inventory", (String)id);
    }

    protected AbstractModInitializer() {
    }

    protected void init() {
        this.registerItems(this.itemReg());
        this.registerMenuType(this.menuReg());
        this.registerNbtAttachment();
        ModInfo.setServerConfig(this.loadServerConfig());
        ModInfo.setPacketDistributor(this.loadPacketDistributor());
        ModInfo.platformContext = this.loadOtherPlatformSpecific();
    }

    private void registerItems(RegistryCallback<Item> method) {
        ModRegistries.Items.testEndInv = method.register("endinv_accessor", () -> new TestEndInv(new Item.Properties()));
        ModRegistries.Items.screenDebugger = method.register("screen_debugger", () -> new ScreenDebugger(new Item.Properties()));
    }

    private void registerMenuType(RegistryCallback<MenuType<?>> method) {
        ModRegistries.Menus.endinvMenuType = method.register("endinv_menu", this.createEndInvMenuType());
    }

    private void registerNbtAttachment() {
        ModRegistries.NbtAttachments.endInvUUID = this.createEndInvUUID("endinv_uuid");
        ModRegistries.NbtAttachments.syncedConfig = this.createSyncedConfig("endinv_settings");
    }

    protected abstract IPlatform loadOtherPlatformSpecific();

    protected abstract IPacketDistributor loadPacketDistributor();

    protected abstract IServerConfig loadServerConfig();

    protected abstract RegistryCallback<Item> itemReg();

    protected abstract RegistryCallback<MenuType<?>> menuReg();

    protected abstract Supplier<MenuType<EndlessInventoryMenu>> createEndInvMenuType();

    protected abstract NbtAttachment<UUID> createEndInvUUID(String var1);

    protected abstract NbtAttachment<SyncedConfig> createSyncedConfig(String var1);

    @FunctionalInterface
    public static interface RegistryCallback<T> {
        public <R extends T> Supplier<R> register(String var1, Supplier<R> var2);
    }
}

