/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;

public class ScreenDebug {
    protected static final String HidingText = "[F4]Menu screen rendering stopped!";
    public static int phase = 0;
    protected static boolean hideMenu = false;
    protected static Minecraft mc;

    public static void debugInfo(Screen screen, GuiGraphics graphics, double mouseX, double mouseY) {
        if (!ClientModInfo.getClientConfig().screenDebugging().get().booleanValue()) {
            return;
        }
        int width = screen.width;
        int height = screen.height;
        int imageWidth = 0;
        int imageHeight = 0;
        int guiLeft = 0;
        int guiTop = 0;
        mc = Optional.ofNullable(mc).orElseGet(Minecraft::getInstance);
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen ACS = (AbstractContainerScreen)screen;
            imageWidth = ClientModInfo.containerScreenHelper.getGuiXSize(ACS);
            imageHeight = ClientModInfo.containerScreenHelper.getGuiYSize(ACS);
            guiLeft = ClientModInfo.containerScreenHelper.getGuiLeft(ACS);
            guiTop = ClientModInfo.containerScreenHelper.getGuiTop(ACS);
        }
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate(0.0, 0.0, 1000.0);
        int color = -1;
        if (phase == 1) {
            for (x = 0; x < width; x += 16) {
                color = x % 512 == 0 ? -16777080 : (x % 256 == 0 ? -16733441 : (x % 64 == 0 ? -872349697 : 0x2200FFFF));
                graphics.vLine(x, 0, height, color);
            }
            for (y = 0; y < height; y += 16) {
                color = y % 512 == 0 ? -16777080 : (y % 256 == 0 ? -16733441 : (y % 64 == 0 ? -872349697 : 0x2200FFFF));
                graphics.hLine(0, width, y, color);
            }
        } else if (phase == 2) {
            for (x = 0; x < width; x += 10) {
                color = x % 200 == 0 ? -16759808 : (x % 100 == 0 ? -872380331 : (x % 50 == 0 ? -872349952 : 0x2200FF00));
                graphics.vLine(x, 0, height, color);
            }
            for (y = 0; y < height; y += 10) {
                color = y % 200 == 0 ? -16759808 : (y % 100 == 0 ? -872380331 : (y % 50 == 0 ? -872349952 : 0x2200FF00));
                graphics.hLine(0, width, y, color);
            }
        }
        if (phase > 0) {
            graphics.hLine(0, width, (int)mouseY, -7829470);
            graphics.vLine((int)mouseX, 0, height, -7829470);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)"[F3]Screen Debug enabled"), 0, 0, -22016);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Width: " + width)), width - 128, 10, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Height: " + height)), width - 128, 20, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("ImageWidth/XSize: " + imageWidth)), width - 128, 30, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("ImageHeight/YSize: " + imageHeight)), width - 128, 40, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("GUILeft: " + guiLeft)), width - 128, 50, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("GUITop: " + guiTop)), width - 128, 60, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("mouseX: " + mouseX)), width - 128, 70, -256);
            graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("mouseY: " + mouseY)), width - 128, 80, -256);
            if (ScreenDebug.mc.player != null) {
                PageData pageData = CachedConfig.currentLayout();
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)"Page data: "), 0, 10, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Page: " + pageData.pageRegKey())), 0, 20, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Rows: " + pageData.rows())), 10, 30, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Columns: " + pageData.columns())), 10, 40, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Sort type: " + String.valueOf((Object)pageData.sortType()))), 10, 50, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Sort reversed: " + pageData.reverseSort())), 10, 60, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Searching: " + pageData.search())), 10, 70, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)"Configurations: "), 0, 80, -256);
                IClientConfig config = ClientModInfo.getClientConfig();
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Auto suit in columns: " + String.valueOf(config.autoSuitColumn().get()))), 10, 90, -256);
                graphics.drawString(ScreenDebug.mc.font, (Component)Component.literal((String)("Texture mode: " + String.valueOf((Object)config.textureMode().get()))), 10, 100, -256);
            }
        }
        pose.popPose();
    }

    public static void click(int button, Screen screen) {
        EndlessInventoryScreen EIS;
        if (!ClientModInfo.getClientConfig().screenDebugging().get().booleanValue()) {
            return;
        }
        if (button == 292 && ++phase > 3) {
            phase = 0;
        }
        if (button == 293) {
            boolean bl = hideMenu = !hideMenu;
        }
        if (screen instanceof EndlessInventoryScreen && (EIS = (EndlessInventoryScreen)screen).getFrameWork() != null) {
            DisplayPage displayPage;
            int step = Screen.hasShiftDown() ? 10 : 1;
            int dx = 0;
            int dy = 0;
            if (button == 265) {
                dy = -step;
            } else if (button == 264) {
                dy = step;
            } else if (button == 263) {
                dx = -step;
            } else if (button == 262) {
                dx = step;
            }
            if (dx != 0 || dy != 0) {
                EIS.getFrameWork().move(dx, dy);
            }
            if ((displayPage = EIS.getFrameWork().getDisplayingPage()) instanceof ItemPage) {
                ItemPage itemPage = (ItemPage)displayPage;
                if (button == 82) {
                    itemPage.requestRemoteContents();
                }
                if (button == 84) {
                    itemPage.setChanged();
                }
            }
        }
    }
}

