/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.options.IConfigValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndInvSettingScreen
extends Screen {
    private static final int CONFIG_ENTRY_Y_OFFSET = 17;
    private static final int CONFIG_ENTRY_X_OFFSET = 10;
    private static final int ENTRY_HEIGHT = 20;
    private static final int MAX_ENTRY_COUNT = 7;
    private static final int WIDGET_X_OFFSET = 165;
    private static final int WIDGET_X_SIZE = 60;
    private static final int WIDGET_Y_SIZE = 18;
    private final Screen back;
    private int leftPos;
    private int topPos;
    private final int imageWidth = 248;
    private final int imageHeight = 166;
    private int pageIndex = 0;
    private int entryOffset = 0;
    private double scrollOffset = 0.0;
    public final List<EntryBuilder> entries = new ArrayList<EntryBuilder>();
    public final EntryBuilder[] renderingEntries = new EntryBuilder[7];
    @Nullable
    private EditBox typingEditBox;

    public EndInvSettingScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"title.endinv.settings"));
        this.back = lastScreen;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.switchPage();
    }

    private void switchPage() {
        this.entries.clear();
        Arrays.fill(this.renderingEntries, null);
        this.clearWidgets();
        this.addPageSwitchButton();
        if (this.pageIndex == 1) {
            this.addInfoEntry((Component)Component.translatable((String)"endinv.info.accessibility"), CachedSrcInv.INSTANCE::getAccessibility);
            this.addInfoEntry((Component)Component.translatable((String)"endinv.info.owner_uuid"), CachedSrcInv.INSTANCE::getOwnerUUID);
            this.addInfoEntry((Component)Component.translatable((String)"endinv.info.white_list_size"), () -> "Size :" + CachedSrcInv.INSTANCE.white_list.size());
        } else {
            this.addConfigEntry("endinv.setting.rows", ClientModInfo.getClientConfig().rows());
            this.addConfigEntry("endinv.setting.columns", ClientModInfo.getClientConfig().columns());
            this.addConfigEntry("endinv.setting.auto_suit", ClientModInfo.getClientConfig().autoSuitColumn());
            this.addConfigEntry("endinv.setting.attaching", ClientModInfo.getClientConfig().attaching());
            this.addConfigEntry("endinv.setting.texture", ClientModInfo.getClientConfig().textureMode());
            this.addConfigEntry("endinv.setting.max_page_bar", ClientModInfo.getClientConfig().maxPageBarCount());
            this.addConfigEntry((Component)Component.literal((String)"Screen debug"), ClientModInfo.getClientConfig().screenDebugging());
        }
        this.scrollTo();
    }

    private void scrollTo() {
        for (int i = 0; i < Math.min(7, this.entries.size()); ++i) {
            assert (this.entryOffset < this.entries.size() - i);
            this.renderingEntries[i] = this.entries.get(i + this.entryOffset);
        }
        for (EntryBuilder entry : this.renderingEntries) {
            if (entry == null) continue;
            entry.build();
            entry.syncConfig();
        }
    }

    private void pageSwitched(int index) {
        this.pageIndex = index;
        this.switchPage();
    }

    private <T> void addConfigEntry(String key, IConfigValue<T> configValue) {
        this.addConfigEntry((Component)Component.translatable((String)key), configValue);
    }

    private <T> void addConfigEntry(Component tip, IConfigValue<T> configValue) {
        this.entries.add(new ConfigEntry<T>(this.entries.size(), tip, configValue.get(), configValue));
    }

    private void addInfoEntry(Component tip, Supplier<Object> info) {
        this.entries.add(new InfoEntry(this.entries.size(), tip, info));
    }

    private void addPageSwitchButton() {
        Button left = Button.builder((Component)Component.literal((String)"<"), btn -> this.pageSwitched(Mth.clamp((int)(this.pageIndex - 1), (int)0, (int)1))).pos(this.leftPos - 20, this.topPos).size(20, 20).build();
        Button right = Button.builder((Component)Component.literal((String)">"), btn -> this.pageSwitched(Mth.clamp((int)(this.pageIndex + 1), (int)0, (int)1))).pos(this.leftPos + 248 + 1, this.topPos).size(20, 20).build();
        this.addRenderableWidget((GuiEventListener)left);
        this.addRenderableWidget((GuiEventListener)right);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        for (EntryBuilder entry : this.renderingEntries) {
            if (entry == null) continue;
            entry.render(guiGraphics, partialTick, mouseX, mouseY);
        }
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -100.0f);
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + 248, this.topPos + 166, -2004318072);
        guiGraphics.pose().popPose();
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.back);
        ClientModInfo.getClientConfig().save();
    }

    public boolean charTyped(char code, int modifiers) {
        if (super.charTyped(code, modifiers)) {
            EditBox editBox;
            GuiEventListener guiEventListener = this.getFocused();
            this.typingEditBox = guiEventListener instanceof EditBox ? (editBox = (EditBox)guiEventListener) : null;
        }
        return false;
    }

    public void tick() {
        boolean flag;
        super.tick();
        boolean bl = flag = this.getFocused() == null || !this.getFocused().isFocused() || this.getFocused() != this.typingEditBox;
        if (flag && this.typingEditBox != null) {
            for (EntryBuilder entry : this.entries) {
                entry.getEditBox().ifPresent(editBox -> {
                    if (editBox == this.typingEditBox) {
                        entry.applyChanges();
                        this.typingEditBox = null;
                    }
                });
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.getFocused() != null) {
            this.getFocused().setFocused(false);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null || button == 1) {
            this.getFocused().setFocused(false);
            this.setFocused(null);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.entries.size() > 7) {
            if (this.scrollOffset < 1.0 && scrollY < 0.0) {
                this.scrollOffset = Mth.clamp((double)(this.scrollOffset + scrollY), (double)0.0, (double)1.0);
            }
            if (this.scrollOffset > 0.0 && scrollY > 0.0) {
                this.scrollOffset = Mth.clamp((double)(this.scrollOffset - scrollY), (double)0.0, (double)1.0);
            }
            this.entryOffset = (int)Math.floor(this.scrollOffset * (double)(this.entries.size() - 7));
            this.scrollTo();
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, text, minX - (int)d3, j, color);
            guiGraphics.disableScissor();
        } else {
            guiGraphics.drawCenteredString(font, text, (minX + maxX) / 2, j, color);
        }
    }

    public static interface EntryBuilder {
        public void build();

        public void render(GuiGraphics var1, float var2, int var3, int var4);

        public void syncConfig();

        public void applyChanges();

        default public Optional<EditBox> getEditBox() {
            return Optional.empty();
        }
    }

    public class ConfigEntry<T>
    implements EntryBuilder {
        public final int index;
        private final Component tip;
        private final IConfigValue<T> configValue;
        private final T initialValue;
        private AbstractWidget configWidget;
        int widgetX;
        int widgetY;

        public ConfigEntry(int index, Component tip, T initialValue, IConfigValue<T> configValue) {
            this.index = index;
            this.tip = tip;
            this.configValue = configValue;
            this.initialValue = initialValue;
            this.widgetX = EndInvSettingScreen.this.leftPos + 165;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
            if (this.initialValue instanceof Boolean) {
                IConfigValue booleanValue = this.configValue;
                CycleButton button = CycleButton.onOffBuilder((boolean)((Boolean)this.initialValue)).displayOnlyValue().create(this.widgetX, this.widgetY, 60, 18, (Component)Component.empty(), (btn, value) -> booleanValue.set(value));
                this.configWidget = button;
                EndInvSettingScreen.this.addRenderableWidget((GuiEventListener)button);
            } else if (this.initialValue instanceof Enum) {
                IConfigValue enumValue = this.configValue;
                CycleButton button = new CycleButton.Builder(e -> Component.translatable((String)("endinv.setting.entry." + e.name()))).withValues((Object[])((Enum[])this.initialValue.getClass().getEnumConstants())).withInitialValue((Object)((Enum)this.initialValue)).displayOnlyValue().create(this.widgetX, this.widgetY, 60, 18, (Component)Component.empty(), (btn, value) -> enumValue.set(value));
                this.configWidget = button;
                EndInvSettingScreen.this.addRenderableWidget((GuiEventListener)button);
            } else if (this.initialValue instanceof Integer) {
                EditBox editBox = new EditBox(EndInvSettingScreen.this.font, this.widgetX, this.widgetY, 60, 18, this.tip);
                this.configWidget = editBox;
                EndInvSettingScreen.this.addRenderableWidget((GuiEventListener)editBox);
            } else {
                EndInvSettingScreen self = EndInvSettingScreen.this;
                self.addRenderableOnly((guiGraphics, i, i1, v) -> guiGraphics.drawString(self.font, "Error", this.widgetX, this.widgetY, -51401));
            }
        }

        @Override
        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.drawString(EndInvSettingScreen.this.font, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
        }

        @Override
        public void syncConfig() {
            AbstractWidget abstractWidget = this.configWidget;
            if (abstractWidget instanceof CycleButton) {
                CycleButton button = (CycleButton)abstractWidget;
                button.setValue(this.configValue.get());
            } else {
                abstractWidget = this.configWidget;
                if (abstractWidget instanceof EditBox) {
                    EditBox editBox = (EditBox)abstractWidget;
                    editBox.setValue(String.valueOf(this.configValue.get()));
                }
            }
        }

        @Override
        public void applyChanges() {
            AbstractWidget abstractWidget = this.configWidget;
            if (abstractWidget instanceof EditBox) {
                EditBox editBox = (EditBox)abstractWidget;
                T parsed = this.parse(editBox.getValue());
                if (parsed == null) {
                    return;
                }
                this.configValue.set(parsed);
            }
        }

        @Override
        public Optional<EditBox> getEditBox() {
            Optional<EditBox> optional;
            AbstractWidget abstractWidget = this.configWidget;
            if (abstractWidget instanceof EditBox) {
                EditBox box = (EditBox)abstractWidget;
                optional = Optional.of(box);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private T parse(String s) {
            try {
                return (T)Integer.valueOf(s);
            }
            catch (Exception e) {
                ((EditBox)this.configWidget).setValue(String.valueOf(this.configValue.get()));
                return null;
            }
        }

        public Component getTip() {
            return this.tip;
        }

        public IConfigValue<?> getConfigValue() {
            return this.configValue;
        }
    }

    public class InfoEntry
    implements EntryBuilder {
        private final Component tip;
        private final Supplier<Object> info;
        int widgetMidX;
        int widgetY;

        public InfoEntry(int index, Component tip, Supplier<Object> info) {
            this.tip = tip;
            this.info = info;
            this.widgetMidX = EndInvSettingScreen.this.leftPos + 165 + 30 - 40;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
        }

        @Override
        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            Font font = EndInvSettingScreen.this.font;
            guiGraphics.drawString(font, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
            MutableComponent v = Component.literal((String)(this.info.get() != null ? this.info.get().toString() : "null"));
            int infoLength = Math.min(font.width(v.getVisualOrderText()), 100);
            EndInvSettingScreen.renderScrollingString(guiGraphics, font, (Component)v, this.widgetMidX - infoLength / 2, this.widgetY, this.widgetMidX + infoLength / 2, this.widgetY + 7, -16711681);
        }

        @Override
        public void syncConfig() {
        }

        @Override
        public void applyChanges() {
        }
    }

    public class EnumAttributeEntry<E extends Enum<?>>
    extends AttributeEntry<Enum<?>> {
        E e;

        public EnumAttributeEntry(EndInvSettingScreen this$0, int index, Component tip, Supplier<Enum<?>> attributeGetter, Consumer<Enum<?>> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        Enum<?> parse(String s) {
            try {
                return Enum.valueOf(this.e.getClass(), s);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public class IntAttributeEntry
    extends AttributeEntry<Integer> {
        public IntAttributeEntry(EndInvSettingScreen this$0, int index, Component tip, Supplier<Integer> attributeGetter, Consumer<Integer> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        Integer parse(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public class StringAttributeEntry
    extends AttributeEntry<String> {
        public StringAttributeEntry(EndInvSettingScreen this$0, int index, Component tip, Supplier<String> attributeGetter, Consumer<String> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        String parse(String s) {
            return s;
        }
    }

    public abstract class AttributeEntry<T>
    implements EntryBuilder {
        public final int index;
        private final Component tip;
        private final Supplier<T> attributeGetter;
        private final Consumer<T> attributeSetter;
        private EditBox editBox;
        int widgetX;
        int widgetY;

        public AttributeEntry(int index, Component tip, Supplier<T> attributeGetter, Consumer<T> attributeSetter) {
            this.index = index;
            this.tip = tip;
            this.attributeGetter = attributeGetter;
            this.attributeSetter = attributeSetter;
            this.widgetX = EndInvSettingScreen.this.leftPos + 165;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
            EditBox editBox = new EditBox(EndInvSettingScreen.this.font, this.widgetX, this.widgetY, 60, 18, (Component)Component.empty());
            EndInvSettingScreen.this.addRenderableWidget((GuiEventListener)editBox);
            this.editBox = editBox;
        }

        @Override
        public void render(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.drawString(EndInvSettingScreen.this.font, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
        }

        @Override
        public void syncConfig() {
            this.editBox.setValue(this.attributeGetter.get().toString());
        }

        @Override
        public void applyChanges() {
            T t = this.parse(this.editBox.getValue());
            if (t == null) {
                this.editBox.setValue(this.attributeGetter.get().toString());
            } else {
                this.attributeSetter.accept(t);
            }
        }

        abstract T parse(String var1);

        @Override
        public Optional<EditBox> getEditBox() {
            return Optional.of(this.editBox);
        }
    }
}

