/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.ToggleCraftingPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndlessInventoryScreen
extends AbstractContainerScreen<EndlessInventoryMenu> {
    private static final ResourceLocation CRAFTING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/crafting_table.png");
    private ScreenFramework frameWork;
    private CycleButton<Boolean> craftingToggleButton;
    private boolean craftingVisible;

    public EndlessInventoryScreen(EndlessInventoryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.recalcDimensions();
    }

    private void recalcDimensions() {
        int baseRows = ((EndlessInventoryMenu)this.menu).getBaseRows();
        this.imageHeight = 114 + baseRows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void init() {
        super.init();
        this.craftingVisible = ((EndlessInventoryMenu)this.menu).isCraftingVisible();
        this.recalcDimensions();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        ScreenFramework existing = ScreenFramework.getInstance();
        if (existing != null) {
            existing.onClose();
        }
        this.frameWork = new ScreenFramework(this);
        this.frameWork.addWidgetToScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.addCraftingToggleButton();
        if (this.craftingToggleButton != null) {
            this.craftingToggleButton.setValue((Object)this.craftingVisible);
        }
        if (this.frameWork != null) {
            this.frameWork.resizePageRows(((EndlessInventoryMenu)this.menu).getVisibleRows());
        }
    }

    private void addCraftingToggleButton() {
        int width = 70;
        this.craftingToggleButton = CycleButton.onOffBuilder().withInitialValue((Object)false).create(0, 0, width, 20, (Component)Component.literal((String)"Crafter"), (it, on) -> {
            this.toggleCrafting();
            if ((Boolean)it.getValue() != this.craftingVisible) {
                it.setValue((Object)this.craftingVisible);
            }
        });
        this.updateCraftingToggleButtonPosition();
        this.addRenderableWidget((GuiEventListener)this.craftingToggleButton);
    }

    private void updateCraftingToggleButtonPosition() {
        if (this.craftingToggleButton == null) {
            return;
        }
        int width = this.craftingToggleButton.getWidth();
        int x = this.leftPos + this.imageWidth - width - 8;
        int y = this.topPos - 20;
        this.craftingToggleButton.setX(x);
        this.craftingToggleButton.setY(y);
    }

    private void toggleCrafting() {
        this.craftingVisible = !this.craftingVisible;
        ((EndlessInventoryMenu)this.menu).setCraftingVisible(this.craftingVisible);
        ModInfo.getPacketDistributor().sendToServer(new ToggleCraftingPayload(this.craftingVisible));
        int previousTop = this.topPos;
        this.recalcDimensions();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.updateCraftingToggleButtonPosition();
        if (this.frameWork != null) {
            this.frameWork.resizePageRows(((EndlessInventoryMenu)this.menu).getVisibleRows());
            this.frameWork.move(0, this.topPos - previousTop);
        }
    }

    private void drawCraftingBackground(GuiGraphics guiGraphics) {
        int craftX = this.leftPos;
        int craftY = this.topPos + 18 * ((EndlessInventoryMenu)this.menu).getVisibleRows() + 18;
        guiGraphics.blit(CRAFTING_TEXTURE, craftX, craftY, 0, 12, 176, 58);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gui, mouseX, mouseY, partialTick);
        this.frameWork.renderPre(gui, mouseX, mouseY, partialTick);
        super.render(gui, mouseX, mouseY, partialTick);
        this.frameWork.render(gui, mouseX, mouseY, partialTick);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int keyCode) {
        for (GuiEventListener guieventlistener : this.children()) {
            if (!guieventlistener.mouseClicked(mouseX, mouseY, keyCode)) continue;
            this.setFocused(guieventlistener);
            if (keyCode == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return this.frameWork.mouseClicked(mouseX, mouseY, keyCode) || super.mouseClicked(mouseX, mouseY, keyCode);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.frameWork.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int keyCode) {
        return this.frameWork.mouseReleased(mouseX, mouseY, keyCode) || super.mouseReleased(mouseX, mouseY, keyCode);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || this.frameWork.mouseScrolled(mouseX, mouseY, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.frameWork.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.frameWork.charTyped(codePoint, modifiers);
    }

    protected void slotClicked(@Nullable Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        ((EndlessInventoryMenu)this.menu).broadcastChanges();
    }

    public void onClose() {
        super.onClose();
        this.frameWork.onClose();
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.frameWork.renderBg(guiGraphics, mouseX, mouseY, partialTick);
        if (((EndlessInventoryMenu)this.menu).isCraftingVisible()) {
            this.drawCraftingBackground(guiGraphics);
        }
    }

    public PageMetaDataManager getPageManager() {
        return (PageMetaDataManager)this.menu;
    }

    public AbstractContainerScreen<?> getScreen() {
        return this;
    }

    public ScreenFramework getFrameWork() {
        return this.frameWork;
    }

    public int getGuiLeft() {
        return this.leftPos;
    }

    public int getGuiTop() {
        return this.topPos;
    }

    public int getXSize() {
        return this.imageWidth;
    }

    public int getYSize() {
        return this.imageHeight;
    }
}

