/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.bg.FromResource;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.Transparent;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.PageType;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ItemEntryDisplay
extends ItemDisplay {
    private static final int TOOLTIP_X_SEP = 5;
    protected boolean jmpTooltip1st = true;
    protected SFBgRenderer.PageBgRender renderer = null;

    public ItemEntryDisplay(PageType pageType, PageManager metaDataManager) {
        super(pageType, metaDataManager);
        this.length = this.meta.rows();
    }

    @Override
    public void scrollTo(float pos) {
        int startIndex = this.getRowIndexForScroll(pos);
        this.initializeContents(startIndex, this.length);
    }

    @Override
    public void initializeContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows());
        if (this.items == null || length != this.items.size()) {
            this.items = NonNullList.withSize((int)length, (Object)ItemStack.EMPTY);
        }
        this.release();
        this.requestRemoteContents();
    }

    public void toggleJmpItemName(boolean jmpTooltip1st) {
        this.jmpTooltip1st = jmpTooltip1st;
    }

    @Override
    protected boolean clickedInOneSlot(double XOffset, double YOffset, double lastX, double lastY) {
        return (int)YOffset / 18 == (int)lastY / 18;
    }

    @Override
    public int getSlotByMouseOffset(double XOffset, double YOffset) {
        if (XOffset < 0.0 || YOffset < 0.0 || XOffset > (double)(18 * this.meta.columns()) || YOffset > (double)(18 * this.meta.rows())) {
            return -1;
        }
        return (int)YOffset / 18;
    }

    @Override
    public Rect2i getSlotArea(int slot) {
        int slotHeight = 18;
        int slotWidth = this.meta.columns() * 18;
        return new Rect2i(this.leftPos, this.topPos + 18 * slot, slotWidth, 18);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isHiddenBySortBox(int rowIndex, int columnIndex) {
        if (rowIndex > 2) return false;
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof AbstractContainerScreen)) return false;
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        if (screen2 instanceof EndlessInventoryScreen) {
            EndlessInventoryScreen EIS = (EndlessInventoryScreen)screen2;
            if (EIS.getFrameWork().sortTypeSwitchBox.isOpen()) return true;
        }
        if (!this.framework.sortTypeSwitchBox.isOpen()) return false;
        return true;
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (ItemStack stack : this.items) {
            guiGraphics.renderItem(stack, this.leftPos, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex << 8);
            if (!stack.isEmpty()) {
                this.renderItemEntry(stack, this.leftPos + 18, this.topPos + rowIndex * 18 + 5, guiGraphics);
            }
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, this.leftPos, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack));
            }
            if (++rowIndex < this.meta.rows()) continue;
            break;
        }
        guiGraphics.pose().popPose();
    }

    private void renderItemEntry(ItemStack item, int x, int y, GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        List tooltips = AbstractContainerScreen.getTooltipFromItem((Minecraft)mc, (ItemStack)item);
        int strX = x;
        boolean jmp = this.jmpTooltip1st;
        for (Component tip : tooltips) {
            if (jmp) {
                jmp = false;
                continue;
            }
            MutableComponent tip1 = Component.literal((String)tip.getString());
            int strX1 = strX + font.width(tip.getVisualOrderText());
            if (strX1 >= x + this.meta.columns() * 18 - 18 - 3) {
                graphics.drawString(font, (Component)Component.literal((String)"..."), strX, y, -256);
                break;
            }
            graphics.drawString(font, (Component)tip1, strX, y, -256);
            strX = strX1 + 5;
        }
    }

    @Override
    public void renderHovering(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderSlotHighlight(graphics, mouseX, mouseY, partialTick);
        int hoveringSlot = this.getSlotByMouseOffset(mouseX - this.leftPos, mouseY - this.topPos);
        if (hoveringSlot >= 0 && hoveringSlot < this.items.size()) {
            ItemStack hovering = (ItemStack)this.items.get(hoveringSlot);
            if (hovering.isEmpty()) {
                return;
            }
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 550.0f);
            graphics.renderTooltip(Minecraft.getInstance().font, AbstractContainerScreen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)hovering), hovering.getTooltipImage(), mouseX, mouseY);
            graphics.pose().popPose();
        }
    }

    @Override
    protected void renderSlotHighlight(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int v = 0; v < this.meta.rows(); ++v) {
            int x1 = this.leftPos;
            int x2 = this.leftPos + this.meta.columns() * 18 - 2;
            int y1 = this.topPos + 18 * v + 1;
            int y2 = this.topPos + 18 * v + 18;
            if (mouseX <= x1 || mouseX >= x2 || mouseY <= y1 || mouseY >= y2) continue;
            if (!this.meta.getMenu().getCarried().isEmpty()) {
                return;
            }
            graphics.fillGradient(RenderType.guiOverlay(), x1, y1, x2, y2, -2130706433, -2130706433, 0);
        }
    }

    @Override
    public void renderBg(SFBgRenderer SFBgRenderer2, GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (this.renderer == null) {
            this.renderer = this.bgRender(SFBgRenderer2);
        }
        this.renderer.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
    }

    protected SFBgRenderer.PageBgRender bgRender(SFBgRenderer sfBgRenderer) {
        TextureMode mode = ClientModInfo.getClientConfig().textureMode().get();
        if (sfBgRenderer instanceof FromResource) {
            FromResource fromResource = (FromResource)sfBgRenderer;
            if (mode == TextureMode.DEDICATED_LOCATION) {
                return fromResource.dedicatePageBgRender(FromResource.ITEM_ENTRY_DISPLAY_RESOURCE);
            }
            return (guiGraphics, partialTicks, mouseX, mouseY) -> {
                sfBgRenderer.getDefaultPageBgRenderer().ifPresent(bgRenderer -> bgRenderer.renderBg(guiGraphics, partialTicks, mouseX, mouseY));
                int pageX = sfBgRenderer.getScreenFrameWork().getPageX();
                int startY = sfBgRenderer.getScreenFrameWork().getPageY();
                for (int i = 0; i < this.meta.rows(); ++i) {
                    guiGraphics.fill(pageX, startY, pageX + 18 * this.meta.columns() - 2, startY + 1, -13158601);
                    guiGraphics.fill(pageX, startY + 1, pageX + 18 * this.meta.columns() - 2, startY + 17, -7631989);
                    guiGraphics.fill(pageX, startY + 17, pageX + 18 * this.meta.columns() - 2, startY + 18, -1);
                    startY += 18;
                }
            };
        }
        return (guiGraphics, partialTicks, mouseX, mouseY) -> {
            (Transparent)this.framework.SFBgRenderer.new Transparent.GridPageRenderer().renderBg(guiGraphics, partialTicks, mouseX, mouseY);
            int pageX = sfBgRenderer.getScreenFrameWork().getPageX();
            int startY = sfBgRenderer.getScreenFrameWork().getPageY();
            for (int i = 0; i < this.meta.rows(); ++i) {
                guiGraphics.fill(pageX, startY, pageX + 18 * this.meta.columns() - 2, startY + 1, -13158601);
                guiGraphics.fill(pageX, startY + 1, pageX + 18 * this.meta.columns() - 2, startY + 17, 929062967);
                guiGraphics.fill(pageX, startY + 17, pageX + 18 * this.meta.columns() - 2, startY + 18, -1);
                startY += 18;
            }
        };
    }
}

