/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.option;

import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.util.SortType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class CachedConfig {
    private static String pageRegKey = "all_items";
    private static int rows = 6;
    private static int columns = 9;
    private static SortType sortType = SortType.DEFAULT;
    private static boolean reverseSort = false;
    private static String searching = "";
    private static boolean attaching = true;
    private static boolean autoPicking = false;
    private static SyncedConfig cachedFlags = SyncedConfig.DEFAULT;
    private static PageData cachedLayout = PageData.DEFAULT;
    private static boolean layoutInitialized;

    private CachedConfig() {
    }

    public static void readAndSyncClientConfigToServer(boolean refreshLayout) {
        if (refreshLayout || !layoutInitialized) {
            cachedLayout = CachedConfig.resolveLayout(null, true);
        }
        CachedConfig.synchronizeFlags();
    }

    public static void synchronizeFlags() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        IClientConfig config = ClientModInfo.getClientConfig();
        attaching = config.attaching().get();
        SyncedConfig serverFlags = ModRegistries.NbtAttachments.getSyncedConfig().getWith((Player)player);
        if (!serverFlags.equals(cachedFlags)) {
            cachedFlags = serverFlags;
        }
    }

    public static void acceptServerFlags(SyncedConfig flags) {
        cachedFlags = flags;
    }

    public static PageData resolveLayout(@Nullable AbstractContainerScreen<?> screen, boolean ofMenu) {
        int columns;
        IClientConfig config = ClientModInfo.getClientConfig();
        int rows = config.rows().get();
        if (rows <= 0) {
            rows = config.calculateDefaultRowCount(ofMenu);
        }
        if (rows <= 0) {
            int n = rows = cachedLayout.rows() > 0 ? cachedLayout.rows() : PageData.DEFAULT.rows();
        }
        if ((columns = config.columns().get().intValue()) <= 0) {
            columns = PageData.DEFAULT.columns();
        }
        if (screen != null && config.autoSuitColumn().get().booleanValue()) {
            int fitted = config.calculateSuitInColumnCount(screen);
            columns = Math.min(columns, fitted);
        }
        if (columns <= 0) {
            columns = cachedLayout.columns() > 0 ? cachedLayout.columns() : PageData.DEFAULT.columns();
        }
        CachedConfig.rows = rows;
        CachedConfig.columns = columns;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
        layoutInitialized = true;
        return cachedLayout;
    }

    public static PageData currentLayout() {
        if (!layoutInitialized) {
            cachedLayout = CachedConfig.resolveLayout(null, true);
        }
        return cachedLayout;
    }

    public static void updateLayoutWith(PageData newLayout) {
        pageRegKey = newLayout.pageRegKey();
        rows = newLayout.rows();
        columns = newLayout.columns();
        sortType = newLayout.sortType();
        reverseSort = newLayout.reverseSort();
        searching = newLayout.search();
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
        layoutInitialized = true;
    }

    public static SortType sortType() {
        return sortType;
    }

    public static void setSortType(SortType value) {
        sortType = value;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }

    public static boolean reverseSort() {
        return reverseSort;
    }

    public static void setReverseSort(boolean value) {
        reverseSort = value;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }

    public static String searching() {
        return searching;
    }

    public static void setSearching(String value) {
        searching = value;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }

    public static String pageKey() {
        return pageRegKey;
    }

    public static void setDisplayingPageKey(String key) {
        pageRegKey = key;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }
}

