/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.option;

import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.options.IConfigValue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public interface IClientConfig {
    public IConfigValue<Boolean> attaching();

    public IConfigValue<Integer> rows();

    public IConfigValue<Integer> columns();

    public IConfigValue<Boolean> autoSuitColumn();

    public IConfigValue<TextureMode> textureMode();

    public IConfigValue<Boolean> screenDebugging();

    public IConfigValue<Integer> maxPageBarCount();

    public Set<String> hidingPageIds();

    public void setPageHiding(String var1, boolean var2);

    default public void save() {
    }

    default public boolean isPageHidden(String id) {
        return this.hidingPageIds().contains(id);
    }

    default public int calculateDefaultRowCount(boolean ofMenu) {
        Minecraft mc = Minecraft.getInstance();
        int height = mc.getWindow().getGuiScaledHeight();
        return Math.max(Math.floorDiv(height - 60, 18) - (ofMenu ? 4 : 0), 0);
    }

    default public int calculateSuitInColumnCount(AbstractContainerScreen<?> screen) {
        int leftPos = (screen.width - 176) / 2;
        int width = leftPos - 20 - 6 - 6;
        return Math.max(0, Math.floorDiv(width, 18));
    }
}

