/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.option;

import com.kwwsyk.endinv.common.network.payloads.toClient.MenuAttachabilityPayload;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public final class MenuAttachabilityCache {
    private static boolean defaultAttach = true;
    private static boolean inventoryAttach = true;
    private static final Map<MenuType<?>, Boolean> perMenu = new HashMap();

    private MenuAttachabilityCache() {
    }

    public static void accept(MenuAttachabilityPayload payload) {
        defaultAttach = payload.defaultAttach();
        inventoryAttach = payload.inventoryAttach();
        perMenu.clear();
        perMenu.putAll(payload.perMenu());
    }

    public static boolean isAttachable(AbstractContainerScreen<?> screen) {
        MenuType type;
        AbstractContainerMenu menu = screen.getMenu();
        try {
            type = menu.getType();
        }
        catch (Exception e) {
            type = null;
        }
        if (type == null) {
            return inventoryAttach;
        }
        Boolean v = perMenu.get(type);
        return v != null ? v : defaultAttach;
    }

    public static Map<MenuType<?>, Boolean> snapshot() {
        return Collections.unmodifiableMap(perMenu);
    }
}

