/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.data.EndInvCodecStrategy;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class SortedSaveStrategy
implements EndInvCodecStrategy {
    @Override
    public boolean canHandle(CompoundTag tag) {
        return true;
    }

    @Override
    public void deserializeItems(EndlessInventory endlessInventory, CompoundTag nbt, HolderLookup.Provider provider) {
        List<ItemStack> items = endlessInventory.getItemsAsList();
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.getCompound(i);
            EndInvCodecStrategy.parse((Tag)itemTag, provider).filter(it -> !it.isEmpty()).ifPresent(items::add);
        }
        endlessInventory.syncMapFromItems();
    }

    @Override
    public CompoundTag serializeItems(EndlessInventory endlessInventory, HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        endlessInventory.syncItemsFromMap();
        List<ItemStack> items = endlessInventory.getItemsAsList();
        for (ItemStack itemStack : items) {
            if (itemStack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack, itemTag, provider));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", items.size());
        return nbt;
    }
}

