/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.MenuClickHandler;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EndlessInventoryMenu
extends AbstractContainerMenu
implements PageMetaDataManager,
PageQuickMoveHandler.PageQuickMoveOverride {
    private final SourceInventory sourceInventory;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private static final int CRAFT_GRID_WIDTH = 3;
    private static final int CRAFT_GRID_HEIGHT = 3;
    private static final int RESULT_SLOT_INDEX = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_COUNT = 9;
    private static final int CRAFT_SLOT_END = 10;
    private static final int PLAYER_INV_SLOT_COUNT = 27;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INV_START = 10;
    private static final int PLAYER_INV_END = 46;
    public final Player player;
    int quickcraftStatus;
    int quickcraftType;
    Set<Slot> quickcraftSlots = new HashSet<Slot>();
    private final DataSlot rowsData = DataSlot.standalone();
    private final DataSlot itemSize = DataSlot.standalone();
    private final DataSlot maxStackSize = DataSlot.standalone();
    private static final int CRAFTING_ROWS = 3;
    private final DataSlot infinityMode = DataSlot.standalone();
    private int displayingPageIndex;
    private String displayingPageId;
    private PageType displayingPageType;
    private int baseRows = 1;
    private int visibleRows = 1;
    private boolean craftingVisible = false;
    public SortType sortType;
    public String searching;
    private boolean reverseSort;

    public static EndlessInventoryMenu createClient(int id, Inventory playerInv) {
        PageData layout = CachedConfig.resolveLayout(null, true);
        EndlessInventoryMenu ret = new EndlessInventoryMenu(id, playerInv, null);
        ret.init(layout);
        ret.switchPageWithId(layout.pageRegKey());
        ret.buildSlotLayout(playerInv);
        return ret;
    }

    public static MenuProvider provide(final int rows) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.empty();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                return EndlessInventoryMenu.createServer(id, inventory, player, rows);
            }
        };
    }

    @Nullable
    public static AbstractContainerMenu createServer(int i, Inventory inventory, Player player, int rows) {
        EndlessInventory endlessInventory = ServerLevelEndInv.getEndInvForPlayer(player).orElse(null);
        if (endlessInventory == null) {
            return null;
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endlessInventory);
        ret.init(new PageData(rows, 9));
        ret.buildSlotLayout(inventory);
        return ret;
    }

    public static EndlessInventoryMenu createWithTemp(int i, Inventory inventory, Player player) {
        EndlessInventory endInv = ServerLevelEndInv.TEMP_ENDINV_REG.get((ServerPlayer)player);
        if (endInv == null) {
            throw new IllegalStateException("Try to create tmp menu without tmp EndInv.");
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endInv);
        ret.init(PageData.DEFAULT);
        ret.buildSlotLayout(inventory);
        return ret;
    }

    public EndlessInventoryMenu(int id, Inventory playerInv, @Nullable EndlessInventory endlessInventory) {
        super(ModRegistries.Menus.getEndInvMenuType(), id);
        this.player = playerInv.player;
        this.sourceInventory = endlessInventory != null ? endlessInventory : CachedSrcInv.INSTANCE;
        PageType initialType = PageTypeRegistry.byId("all_items");
        if (initialType == null && PageTypeRegistry.size() > 0) {
            initialType = PageTypeRegistry.byIndex(0);
        }
        if (initialType == null) {
            initialType = PageType.ALL_ITEMS;
        }
        this.displayingPageType = initialType;
        this.displayingPageId = initialType.registerName;
        this.displayingPageIndex = Math.max(0, PageTypeRegistry.getIndexOf(this.displayingPageId));
        this.itemSize.set(endlessInventory != null ? endlessInventory.getItemSize() : 0);
        this.maxStackSize.set(endlessInventory != null ? endlessInventory.getMaxItemStackSize() : Integer.MAX_VALUE);
        this.infinityMode.set(endlessInventory != null && endlessInventory.isInfinityMode() ? 1 : 0);
        this.addDataSlot(this.rowsData);
        this.addDataSlot(this.itemSize);
        this.addDataSlot(this.maxStackSize);
        this.addDataSlot(this.infinityMode);
    }

    public void applyPageData(PageData pageData) {
        this.init(pageData);
    }

    private void init(PageData pageData) {
        int rows;
        this.baseRows = rows = Math.max(1, pageData.rows());
        this.visibleRows = this.craftingVisible ? Math.max(1, rows - 3) : rows;
        this.rowsData.set(this.visibleRows);
        this.sortType = pageData.sortType();
        this.searching = pageData.search();
        this.reverseSort = pageData.reverseSort();
    }

    private void buildSlotLayout(Inventory playerInventory) {
        if (!this.slots.isEmpty()) {
            return;
        }
        int craftX = 30;
        int craftRowsForPosition = Math.max(1, this.baseRows - 3);
        int craftY = 18 * craftRowsForPosition + 18 + 5;
        int resultX = craftX + 54 + 40;
        int resultY = craftY + 18;
        this.addSlot((Slot)new CraftingResultSlot(this.player, this.craftMatrix, this.craftResult, 0, resultX, resultY));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot(new CraftingGridSlot(this.craftMatrix, col + row * 3, craftX + col * 18, craftY + row * 18));
            }
        }
        int invY = 18 * this.baseRows + 31;
        this.addStandardInventorySlots(playerInventory, 8, invY);
    }

    public List<Slot> getCraftingSlots() {
        return this.slots.subList(1, 10);
    }

    public List<Slot> getPlayerInvSlots() {
        return this.slots.subList(10, 46);
    }

    @TestOnly
    public boolean validateSlotStatus() throws IllegalStateException {
        for (Slot slot : this.getCraftingSlots()) {
            if (slot instanceof CraftingGridSlot) continue;
            throw new IllegalStateException("getCraftingSlots do not correspond menu's crafter slots.");
        }
        for (Slot slot : this.getPlayerInvSlots()) {
            if (slot.container instanceof Inventory) continue;
            throw new IllegalStateException("getPlayerInvSlots contains slots whose container is not inventory");
        }
        if (!(this.slots.get(0) instanceof CraftingGridSlot)) {
            throw new IllegalStateException("the first slot is not Crafter's result slot, check ADD SLOT process");
        }
        return true;
    }

    public boolean isCrafterEnabled() {
        return true;
    }

    public void setCraftingVisible(boolean visible) {
        if (this.craftingVisible == visible) {
            return;
        }
        this.craftingVisible = visible;
        this.visibleRows = visible ? Math.max(1, this.baseRows - 3) : this.baseRows;
        this.rowsData.set(this.visibleRows);
        if (!visible) {
            this.returnCraftingToPlayer();
        }
    }

    private void returnCraftingToPlayer() {
        if (this.player.level().isClientSide) {
            return;
        }
        Inventory inventory = this.player.getInventory();
        for (int i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
            ItemStack stack = this.craftMatrix.removeItemNoUpdate(i);
            if (stack.isEmpty()) continue;
            inventory.placeItemBackInInventory(stack);
        }
        this.craftResult.removeItemNoUpdate(0);
        this.craftMatrix.setChanged();
        this.craftResult.setChanged();
    }

    public void slotsChanged(Container container) {
        if (container == this.craftMatrix) {
            this.updateCraftingResult();
        }
        super.slotsChanged(container);
    }

    public boolean isCraftingVisible() {
        return this.craftingVisible;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getBaseRows() {
        return this.baseRows;
    }

    private void addStandardInventorySlots(Inventory playerInventory, int x, int y) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + l * 9 + 9, x + j1 * 18, y + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, x + i1 * 18, y + 58));
        }
    }

    @Override
    public void switchPageWithIndex(int index) {
        if (index < 0 || index >= PageTypeRegistry.size()) {
            return;
        }
        PageType type = PageTypeRegistry.byIndex(index);
        if (type != null) {
            this.applySelectedPage(type);
        }
    }

    private void applySelectedPage(PageType type) {
        this.displayingPageType = type;
        this.displayingPageId = type.registerName;
        this.displayingPageIndex = Math.max(0, PageTypeRegistry.getIndexOf(this.displayingPageId));
    }

    @Override
    public int getItemSize() {
        return this.itemSize.get();
    }

    public void setItemSize(int i) {
        this.itemSize.set(i);
    }

    @Override
    public boolean enableInfinity() {
        return this.infinityMode.get() > 0;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize.get();
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this;
    }

    @Override
    public SourceInventory getSourceInventory() {
        return this.sourceInventory;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int rows() {
        return this.visibleRows;
    }

    @Override
    public int columns() {
        return 9;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        try {
            if (clickType == ClickType.QUICK_CRAFT) {
                MenuClickHandler.handleQuickCraft(this, slotId, button, player);
            } else if (this.quickcraftStatus != 0) {
                this.resetQuickCraft();
            }
            switch (clickType) {
                case PICKUP: {
                    MenuClickHandler.handlePickup(this, slotId, button, player);
                    break;
                }
                case QUICK_MOVE: {
                    MenuClickHandler.handleQuickMove(this, slotId, button, player);
                    break;
                }
                case SWAP: {
                    MenuClickHandler.handleSwap(this, slotId, button, player);
                    break;
                }
                case THROW: {
                    MenuClickHandler.handleThrow(this, slotId, button, player);
                    break;
                }
                case CLONE: {
                    MenuClickHandler.handleClone(this, slotId, button, player);
                    break;
                }
                case PICKUP_ALL: {
                    this.handlePickupAll(slotId, button, player);
                    break;
                }
                default: {
                    return;
                }
            }
            SourceInventory sourceInventory = this.getSourceInventory();
            if (sourceInventory instanceof EndlessInventory) {
                EndlessInventory endinv = (EndlessInventory)sourceInventory;
                this.setItemSize(endinv.getItemSize());
            }
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)exception, (String)"Container click");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Click info");
            crashreportcategory.setDetail("Menu Type", (Object)"endless_inventory");
            crashreportcategory.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportcategory.setDetail("Slot Count", (Object)this.slots.size());
            crashreportcategory.setDetail("Slot", (Object)slotId);
            crashreportcategory.setDetail("Button", (Object)button);
            crashreportcategory.setDetail("Type", (Object)clickType);
            throw new ReportedException(crashreport);
        }
    }

    boolean tryItemClickBehaviourOverride(Player player, ClickAction action, Slot slot, ItemStack clickedItem, ItemStack carriedItem) {
        if (ModInfo.platformContext.onItemStackedOn(clickedItem, carriedItem, slot, action, player, this.createCarriedSlotAccess())) {
            return true;
        }
        FeatureFlagSet featureflagset = player.level().enabledFeatures();
        return carriedItem.isItemEnabled(featureflagset) && carriedItem.overrideStackedOnOther(slot, action, player) || clickedItem.isItemEnabled(featureflagset) && clickedItem.overrideOtherStackedOnMe(carriedItem, slot, action, player, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            public ItemStack get() {
                return EndlessInventoryMenu.this.getCarried();
            }

            public boolean set(ItemStack itemStack) {
                EndlessInventoryMenu.this.setCarried(itemStack);
                return true;
            }
        };
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        if (slotStack.getItem() == ModRegistries.Items.getTestEndInv()) {
            return ItemStack.EMPTY;
        }
        ItemStack original = slotStack.copy();
        boolean handled = index == 0 ? this.handleQuickMoveResult(slot, slotStack, original) : (this.isCrafterSlot(index) ? this.handleQuickMoveFromCrafterSlot(slot, slotStack) : (this.isPlayerInventorySlot(index) ? this.handleQuickMoveFromPlayerInventory(slotStack) : this.moveItemStackTo(slotStack, 10, 46, false)));
        if (!handled) {
            return ItemStack.EMPTY;
        }
        if (slotStack.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (slotStack.getCount() == original.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, slotStack);
        if (index == 0) {
            player.drop(slotStack, false);
        }
        return original;
    }

    private boolean isPlayerInventorySlot(int index) {
        return index >= 10 && index < 46;
    }

    private boolean isCrafterSlot(int index) {
        return index >= 1 && index < 10;
    }

    private boolean handleQuickMoveFromCrafterSlot(Slot slot, ItemStack stack) {
        boolean moved = this.moveItemStackTo(stack, 10, 46, false);
        if (moved) {
            this.craftMatrix.setChanged();
            this.updateCraftingResult();
        }
        return moved;
    }

    private boolean moveStackIntoCrafter(ItemStack stack) {
        int before = stack.getCount();
        boolean moved = this.moveItemStackTo(stack, 1, 10, false);
        if (!moved || stack.getCount() == before) {
            return false;
        }
        this.craftMatrix.setChanged();
        this.updateCraftingResult();
        return true;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot.container == this.craftResult) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    private ItemStack quickMoveIntoPage(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remain = this.sourceInventory.addItem(stack);
        this.sourceInventory.setChanged();
        return remain;
    }

    private void handlePickupAll(int slotId, int button, Player player) {
        if (slotId < 0) {
            return;
        }
        Slot clickedSlot = (Slot)this.slots.get(slotId);
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        if (!clickedSlot.hasItem() || !clickedSlot.mayPickup(player)) {
            int startIndex = button == 0 ? 0 : this.slots.size() - 1;
            int step = button == 0 ? 1 : -1;
            for (int pass = 0; pass < 2; ++pass) {
                for (int index = startIndex; index >= 0 && index < this.slots.size() && carried.getCount() < carried.getMaxStackSize(); index += step) {
                    Slot scanningSlot = (Slot)this.slots.get(index);
                    if (!AbstractContainerMenu.canItemQuickReplace((Slot)scanningSlot, (ItemStack)carried, (boolean)true) || !scanningSlot.mayPickup(player) || !this.canTakeItemForPickAll(carried, scanningSlot)) continue;
                    ItemStack scanningItem = scanningSlot.getItem();
                    if (pass == 0 && scanningItem.getCount() == scanningItem.getMaxStackSize()) continue;
                    ItemStack taken = scanningSlot.safeTake(scanningItem.getCount(), carried.getMaxStackSize() - carried.getCount(), player);
                    carried.grow(taken.getCount());
                }
                if (carried.getCount() >= carried.getMaxStackSize()) continue;
                ItemStack extracted = this.tryExtractFromPage(carried, carried.getMaxStackSize() - carried.getCount());
                carried.grow(extracted.getCount());
                carried.setCount(Math.min(carried.getCount(), carried.getMaxStackSize()));
            }
        }
    }

    public ItemStack tryExtractFromPage(ItemStack template, int count) {
        if (count <= 0 || template.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack request = template.copy();
        return this.sourceInventory.takeItem(request, count);
    }

    @Override
    public ItemStack quickMoveFromPage(ItemStack stack) {
        boolean movedToMain;
        boolean crafterAccepted;
        if (stack.isEmpty()) {
            return stack;
        }
        boolean bl = crafterAccepted = this.craftingVisible && this.moveStackIntoCrafter(stack);
        if (!stack.isEmpty() && !(movedToMain = this.moveItemStackTo(stack, 10, 37, false))) {
            this.moveItemStackTo(stack, 37, 46, false);
        }
        return crafterAccepted && stack.isEmpty() ? ItemStack.EMPTY : stack;
    }

    @Override
    public SortType sortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public boolean isSortReversed() {
        return this.reverseSort;
    }

    @Override
    public void switchSortReversed() {
        this.reverseSort = !this.reverseSort;
    }

    @Override
    public void setSortReversed(boolean reversed) {
        this.reverseSort = reversed;
    }

    @Override
    public String searching() {
        return this.searching;
    }

    @Override
    public void setSearching(String searching) {
        this.searching = searching;
    }

    @Override
    public PageData getPageData() {
        return new PageData(this.getDisplayingPageId(), this.baseRows, this.columns(), this.sortType(), this.isSortReversed(), this.searching());
    }

    @Override
    public void sendEndInvData() {
        SourceInventory sourceInventory = this.sourceInventory;
        if (sourceInventory instanceof EndlessInventory) {
            EndlessInventory endlessInventory = (EndlessInventory)sourceInventory;
            this.itemSize.set(endlessInventory.getItemSize());
            this.maxStackSize.set(endlessInventory.getMaxItemStackSize());
            this.infinityMode.set(endlessInventory.isInfinityMode() ? 1 : 0);
        }
    }

    @Override
    public String getDisplayingPageId() {
        return this.displayingPageId;
    }

    @Override
    public void switchPageWithId(String id) {
        PageType type = PageTypeRegistry.byId(id);
        if (type != null) {
            this.applySelectedPage(type);
        }
    }

    @Override
    public PageType getDisplayingPageType() {
        return this.displayingPageType;
    }

    public void removed(Player player) {
        super.removed(player);
        this.returnCraftingToPlayer();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private int insertStackIntoPage(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        ItemStack attempt = stack.copy();
        ItemStack remainder = this.quickMoveIntoPage(attempt);
        int inserted = stack.getCount() - remainder.getCount();
        if (inserted > 0) {
            stack.shrink(inserted);
        }
        return inserted;
    }

    private boolean handleQuickMoveResult(Slot slot, ItemStack stack, ItemStack original) {
        boolean moved;
        boolean bl = moved = this.moveItemStackTo(stack, 10, 46, true) || this.moveItemStackTo(stack, 10, 46, false);
        if (!moved) {
            this.insertStackIntoPage(stack);
        }
        slot.onQuickCraft(stack, original);
        this.updateCraftingResult();
        return true;
    }

    private boolean handleQuickMoveFromPlayerInventory(ItemStack stack) {
        if (this.craftingVisible) {
            return this.moveStackIntoCrafter(stack);
        }
        return this.insertStackIntoPage(stack) > 0;
    }

    private void updateCraftingResult() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = serverPlayer.level();
        ItemStack resultStack = ItemStack.EMPTY;
        int w = 3;
        int h = 3;
        NonNullList items = NonNullList.withSize((int)(w * h), (Object)ItemStack.EMPTY);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int idx = y * w + x;
                items.set(idx, (Object)this.craftMatrix.getItem(idx));
            }
        }
        CraftingInput input = CraftingInput.of((int)w, (int)h, (List)items);
        Optional optional = serverPlayer.server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
        if (optional.isPresent()) {
            ItemStack assembled;
            RecipeHolder holder = (RecipeHolder)optional.get();
            CraftingRecipe recipe = (CraftingRecipe)holder.value();
            if (this.craftResult.setRecipeUsed(level, serverPlayer, holder) && (assembled = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                resultStack = assembled;
            }
        }
        this.craftResult.setItem(0, resultStack);
        this.setRemoteSlot(0, resultStack);
        serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, resultStack));
    }

    private class CraftingResultSlot
    extends ResultSlot {
        CraftingResultSlot(Player player, CraftingContainer matrix, ResultContainer result, int slotIndex, int x, int y) {
            super(player, matrix, (Container)result, slotIndex, x, y);
        }

        public boolean isActive() {
            return EndlessInventoryMenu.this.craftingVisible;
        }
    }

    private class CraftingGridSlot
    extends Slot {
        CraftingGridSlot(CraftingContainer matrix, int slot, int x, int y) {
            super((Container)matrix, slot, x, y);
        }

        public boolean isActive() {
            return EndlessInventoryMenu.this.craftingVisible;
        }
    }

    public static interface ClientPageBinding {
        public String pageId();

        public PageType pageType();

        public void onPageSelected();

        public void scrollTo(float var1);

        public ItemStack quickMoveIntoPage(ItemStack var1);

        public void markPageChanged();

        public ItemStack extractItemFromPage(ItemStack var1, int var2);

        public void refreshAfterMenuInteraction(SourceInventory var1);
    }
}

