/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu.page;

import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.ItemEntryDisplay;
import com.kwwsyk.endinv.common.client.gui.page.SegClassifyItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.StarredItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;

public class PageType {
    public static final String DEFAULT_KEY = "all_items";
    private static final List<Predicate<ItemStack>> equipmentSubclassifications = List.of(is -> {
        ArmorItem armor;
        Item patt0$temp = is.getItem();
        return patt0$temp instanceof ArmorItem && (armor = (ArmorItem)patt0$temp).getType() == ArmorItem.Type.HELMET;
    }, is -> {
        ArmorItem armor;
        Item patt0$temp = is.getItem();
        return patt0$temp instanceof ArmorItem && (armor = (ArmorItem)patt0$temp).getType() == ArmorItem.Type.CHESTPLATE;
    }, is -> {
        ArmorItem armor;
        Item patt0$temp = is.getItem();
        return patt0$temp instanceof ArmorItem && (armor = (ArmorItem)patt0$temp).getType() == ArmorItem.Type.LEGGINGS;
    }, is -> {
        ArmorItem armor;
        Item patt0$temp = is.getItem();
        return patt0$temp instanceof ArmorItem && (armor = (ArmorItem)patt0$temp).getType() == ArmorItem.Type.BOOTS;
    });
    public static final List<TagKey<Item>> WEAPON_TAGS = new ArrayList<TagKey<Item>>();
    public static final List<TagKey<Item>> TOOL_TAGS = new ArrayList<TagKey<Item>>();
    public static final List<TagKey<Item>> EQUIPPABLE_TAGS = new ArrayList<TagKey<Item>>();
    public static final PageType ALL_ITEMS = PageType.createClassifiedPage("all_items", null, "chest");
    public static final PageType BLOCK_ITEMS = PageType.createClassifiedPage("block_items", stack -> stack.getItem() instanceof BlockItem, "stone");
    public static final PageType WEAPONS = PageType.createClassifiedPage("weapons", PageType::isWeapon, "iron_sword");
    public static final PageType TOOLS = PageType.createClassifiedPage("tools", PageType::isTool, "iron_pickaxe");
    public static final PageType EQUIPMENTS = new PageType((type, manager) -> new SegClassifyItemDisplay(type, manager, equipmentSubclassifications, false, true), "equipments", PageType::isDefenceEquipment, ResourceLocation.withDefaultNamespace((String)"iron_chestplate"));
    public static final PageType CONSUMABLE = PageType.createClassifiedPage("consumable", PageType::isFoodOrPotion, "bread");
    public static final PageType ENCHANTED_BOOKS = PageType.createItemEntry("enchanted_books", stack -> stack.getItem() instanceof EnchantedBookItem, "enchanted_book");
    public static final PageType BOOKMARK = new PageType(StarredItemPage::new, "bookmark", null, ResourceLocation.withDefaultNamespace((String)"book"));
    private final PageConstructor constructor;
    @Nullable
    public final Predicate<ItemStack> itemClassify;
    public ResourceLocation icon = null;
    public final String registerName;

    public PageType(PageConstructor constructor, String registerName) {
        this.constructor = constructor;
        this.registerName = registerName;
        this.itemClassify = null;
    }

    public PageType(PageConstructor constructor, String registerName, @Nullable Predicate<ItemStack> itemClassify) {
        this.constructor = constructor;
        this.itemClassify = itemClassify;
        this.registerName = registerName;
    }

    public PageType(PageConstructor constructor, String registerName, @Nullable Predicate<ItemStack> itemClassify, @Nullable ResourceLocation icon) {
        this.constructor = constructor;
        this.itemClassify = itemClassify;
        this.icon = icon;
        this.registerName = registerName;
    }

    public static PageType createClassifiedPage(String registerName, Predicate<ItemStack> itemClassify, String icon) {
        return new PageType(ItemDisplay::new, registerName, itemClassify, ResourceLocation.withDefaultNamespace((String)icon));
    }

    public static PageType createItemEntry(String registerName, Predicate<ItemStack> itemClassify, String icon) {
        return new PageType(ItemEntryDisplay::new, registerName, itemClassify, ResourceLocation.withDefaultNamespace((String)icon));
    }

    public DisplayPage buildPage(PageManager meta) {
        DisplayPage page = this.constructor.create(this, meta);
        if (this.icon != null) {
            page.icon = this.icon;
        }
        return page;
    }

    public String toString() {
        return this.registerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PageType)) return false;
        PageType pageType = (PageType)obj;
        if (!Objects.equals(pageType.constructor, this.constructor)) return false;
        if (!Objects.equals(pageType.itemClassify, this.itemClassify)) return false;
        if (!Objects.equals(pageType.registerName, this.registerName)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isWeapon(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof SwordItem) return true;
        if (item instanceof AxeItem) return true;
        if (item instanceof TridentItem) return true;
        if (item instanceof ProjectileWeaponItem) return true;
        if (!WEAPON_TAGS.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).is(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTool(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof PickaxeItem) return true;
        if (item instanceof AxeItem) return true;
        if (item instanceof ShearsItem) return true;
        if (item instanceof ShovelItem) return true;
        if (item instanceof FlintAndSteelItem) return true;
        if (item instanceof FishingRodItem) return true;
        if (!TOOL_TAGS.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).is(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDefenceEquipment(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) return true;
        if (item instanceof ShieldItem) return true;
        if (item instanceof ElytraItem) return true;
        if (!EQUIPPABLE_TAGS.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).is(arg_0))) return false;
        return true;
    }

    private static boolean isFoodOrPotion(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return item instanceof PotionItem || itemStack.has(DataComponents.FOOD);
    }

    static {
        WEAPON_TAGS.add((TagKey<Item>)ItemTags.SWORDS);
        WEAPON_TAGS.add((TagKey<Item>)ItemTags.AXES);
        TOOL_TAGS.add((TagKey<Item>)ItemTags.AXES);
        TOOL_TAGS.add((TagKey<Item>)ItemTags.PICKAXES);
        TOOL_TAGS.add((TagKey<Item>)ItemTags.HOES);
        TOOL_TAGS.add((TagKey<Item>)ItemTags.SHOVELS);
    }

    @FunctionalInterface
    public static interface PageConstructor {
        public DisplayPage create(PageType var1, PageManager var2);
    }
}

