/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.events;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.network.payloads.toClient.MenuAttachabilityPayload;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.common.options.SpecifiedMenuAttachingConfig;
import com.kwwsyk.endinv.neoforge.options.ServerConfig;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="endless_inventory")
public class PlayerEvents {
    public static boolean tickRefresh = true;

    @SubscribeEvent
    public static void tick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (tickRefresh) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)ModRegistries.NbtAttachments.getSyncedConfig().computeIfAbsent((Player)serverPlayer), (CustomPacketPayload[])new CustomPacketPayload[0]);
                IServerConfig serverCfg = ModInfo.getServerConfig();
                SpecifiedMenuAttachingConfig menuCfg = serverCfg.specifiedMenuAttachability().get();
                boolean defaultAttach = serverCfg.enableAttaching().get();
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuAttachabilityPayload(defaultAttach, menuCfg.isInventoryAttachable(), menuCfg.getConfigs()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (ServerConfig.CONFIG.TRANSFER_MODE.get() == ContentTransferMode.ALL) {
                    ServerLevelEndInv.getEndInvForPlayer((Player)serverPlayer).ifPresent(endInv -> {
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EndInvContent(endInv.getItemMap()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)EndInvMetadata.getWith(endInv), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    });
                }
                tickRefresh = false;
            }
        }
    }

    @SubscribeEvent
    public static void onRespawnClone(PlayerEvent.Clone event) {
        tickRefresh = true;
    }

    @SubscribeEvent
    public static void onJoinLevel(PlayerEvent.PlayerLoggedInEvent event) {
        tickRefresh = true;
    }
}

