/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.integrates.jei;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.neoforge.network.payloads.JeiTransferRecipePayload;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class EIMRecipeTranHandler
implements IRecipeTransferHandler<EndlessInventoryMenu, RecipeHolder<CraftingRecipe>> {
    private static final Class<EndlessInventoryMenu> CONTAINER_CLASS = EndlessInventoryMenu.class;
    private static final MenuType<EndlessInventoryMenu> CONTAINER_TYPE = ModRegistries.Menus.getEndInvMenuType();
    private final IJeiHelpers jeiHelper;
    private final IRecipeTransferHandlerHelper transferHelper;
    private final IRecipeTransferInfo playerInvInfo;

    public EIMRecipeTranHandler(IJeiHelpers jeiHelper, IRecipeTransferHandlerHelper transferHelper) {
        this.jeiHelper = jeiHelper;
        this.transferHelper = transferHelper;
        this.playerInvInfo = this.createPlayerInvInfo();
    }

    private IRecipeTransferInfo createPlayerInvInfo() {
        return this.transferHelper.createBasicRecipeTransferInfo(CONTAINER_CLASS, CONTAINER_TYPE, RecipeTypes.CRAFTING, 0, 9, 10, 36);
    }

    public Class<EndlessInventoryMenu> getContainerClass() {
        return CONTAINER_CLASS;
    }

    public Optional<MenuType<EndlessInventoryMenu>> getMenuType() {
        return Optional.of(CONTAINER_TYPE);
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public IRecipeTransferError transferRecipe(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        try {
            if (!new EIMRecipeTranInfo().canHandle(container, recipe)) {
                return this.transferHelper.createUserErrorWithTooltip((Component)Component.literal((String)"Unsupported container or recipe"));
            }
            if (!container.isCrafterEnabled()) {
                return this.transferHelper.createUserErrorWithTooltip((Component)Component.literal((String)"Crafter is disabled by server rules"));
            }
            TransferPlan plan = EIMRecipeTranHandler.createTransferPlan(container, recipe, maxTransfer);
            boolean missing = plan.isMissing();
            if (!doTransfer) {
                if (!missing) return null;
                IRecipeTransferError iRecipeTransferError = this.transferHelper.createUserErrorWithTooltip((Component)Component.literal((String)"Missing ingredient(s)"));
                return iRecipeTransferError;
            }
            if (player.level().isClientSide) {
                container.setCraftingVisible(true);
                ResourceLocation id = EIMRecipeTranHandler.tryResolveRecipeId(recipe);
                if (id == null) return this.transferHelper.createInternalError();
                ModInfo.getPacketDistributor().sendToServer(new JeiTransferRecipePayload(container.containerId, id, maxTransfer));
            } else {
                EIMRecipeTranHandler.performTransfer(container, recipe, plan, player);
            }
            if (!missing) return null;
            IRecipeTransferError iRecipeTransferError = this.transferHelper.createUserErrorWithTooltip((Component)Component.literal((String)"Missing ingredient(s)"));
            return iRecipeTransferError;
        }
        catch (Exception e) {
            return this.transferHelper.createInternalError();
        }
    }

    public static void performServerTransfer(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe, Player player, boolean maxTransfer) {
        TransferPlan plan = EIMRecipeTranHandler.createTransferPlan(container, recipe, maxTransfer);
        EIMRecipeTranHandler.performTransfer(container, recipe, plan, player);
    }

    private static boolean sameType(ItemStack a, ItemStack b) {
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    private static Ingredient[] buildRecipeLayout(CraftingRecipe recipe) {
        Object[] layout = new Ingredient[9];
        Arrays.fill(layout, Ingredient.EMPTY);
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int width = Math.min(3, shaped.getWidth());
            int height = Math.min(3, shaped.getHeight());
            NonNullList ingredients = shaped.getIngredients();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int srcIndex = y * shaped.getWidth() + x;
                    if (srcIndex >= ingredients.size()) continue;
                    layout[y * 3 + x] = (Ingredient)ingredients.get(srcIndex);
                }
            }
        } else {
            NonNullList ingredients = recipe.getIngredients();
            for (int i = 0; i < Math.min(ingredients.size(), layout.length); ++i) {
                layout[i] = (Ingredient)ingredients.get(i);
            }
        }
        return layout;
    }

    @Nullable
    private static ItemCounts countAvailableOfType(ItemStack type, ItemAvailability availability) {
        if (type.isEmpty()) {
            return null;
        }
        return availability.lookup(ItemKey.asKey(type));
    }

    private static Selection chooseBestCandidate(Ingredient ing, ItemAvailability availability, Reservation reservation) {
        Candidate best = Candidate.NONE;
        HashSet<ItemKey> seen = new HashSet<ItemKey>();
        for (ItemStack cand : ing.getItems()) {
            ItemCounts counts = EIMRecipeTranHandler.countAvailableOfType(cand, availability);
            Candidate candidate = Candidate.fromCounts(counts, reservation);
            if (!candidate.isValid()) continue;
            assert (candidate.selection != null);
            if (!seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        for (ItemCounts counts : availability.all()) {
            Candidate candidate;
            if (!ing.test(counts.representative()) || !(candidate = Candidate.fromCounts(counts, reservation)).isValid()) continue;
            assert (candidate.selection != null);
            if (!seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        assert (best.selection != null);
        return best.selection();
    }

    private static TransferPlan createTransferPlan(EndlessInventoryMenu container, RecipeHolder<CraftingRecipe> recipe, boolean maxTransfer) {
        int craftsPossible;
        Ingredient[] layout = EIMRecipeTranHandler.buildRecipeLayout((CraftingRecipe)recipe.value());
        NonNullList playerInvItems = container.player.getInventory().items;
        List<ItemStack> pageItems = container.getSourceInventory().getItemsAsList();
        ItemAvailability availability = ItemAvailability.buildFromItems((List<ItemStack>)playerInvItems, pageItems);
        Reservation reservation = new Reservation();
        Object[] chosenPerSlot = new ItemStack[layout.length];
        Arrays.fill(chosenPerSlot, ItemStack.EMPTY);
        boolean missing = false;
        int perSlotStackLimit = Integer.MAX_VALUE;
        for (int i = 0; i < layout.length; ++i) {
            Ingredient ing = layout[i];
            if (ing.isEmpty()) continue;
            Selection selection = EIMRecipeTranHandler.chooseBestCandidate(ing, availability, reservation);
            if (selection.isEmpty()) {
                missing = true;
                continue;
            }
            reservation.reserve(selection);
            chosenPerSlot[i] = selection.stack();
            perSlotStackLimit = Math.min(perSlotStackLimit, selection.stack().getMaxStackSize());
        }
        if (missing || reservation.isEmpty()) {
            craftsPossible = 0;
        } else {
            craftsPossible = Integer.MAX_VALUE;
            for (Map.Entry entry : reservation.totalDemand().entrySet()) {
                ItemCounts counts = availability.lookup((ItemKey)entry.getKey());
                if (counts == null) {
                    craftsPossible = 0;
                    missing = true;
                    break;
                }
                int possible = counts.total() / (Integer)entry.getValue();
                craftsPossible = Math.min(craftsPossible, possible);
            }
            if (craftsPossible == Integer.MAX_VALUE) {
                craftsPossible = 0;
            }
        }
        if (perSlotStackLimit == Integer.MAX_VALUE) {
            perSlotStackLimit = 64;
        }
        int craftsWanted = maxTransfer ? Math.min(craftsPossible, perSlotStackLimit) : (craftsPossible > 0 ? 1 : 0);
        boolean bl = missing || craftsWanted <= 0;
        return new TransferPlan(layout, (ItemStack[])chosenPerSlot, craftsWanted, bl);
    }

    private static void performTransfer(EndlessInventoryMenu container, Object recipe, TransferPlan plan, Player player) {
        container.setCraftingVisible(true);
        List<Slot> craftingSlots = container.getCraftingSlots();
        for (Slot cSlot : craftingSlots) {
            ItemStack removed;
            int count;
            if (!cSlot.hasItem() || (count = cSlot.getItem().getCount()) <= 0 || (removed = cSlot.safeTake(count, count, player)).isEmpty()) continue;
            player.getInventory().placeItemBackInInventory(removed);
        }
        List<Slot> playerInvSlots = container.getPlayerInvSlots();
        Ingredient[] layout = plan.layout();
        for (int i = 0; i < Math.min(craftingSlots.size(), layout.length); ++i) {
            Ingredient ing = layout[i];
            if (ing.isEmpty()) continue;
            Slot target = craftingSlots.get(i);
            int toTake = plan.craftsWanted();
            if (toTake <= 0) continue;
            ItemStack chosen = plan.chosenPerSlot()[i];
            ItemStack placedStack = ItemStack.EMPTY;
            for (Slot invSlot : playerInvSlots) {
                ItemStack taken;
                int can;
                if (toTake <= 0) break;
                if (!invSlot.hasItem()) continue;
                ItemStack in = invSlot.getItem();
                if (!(chosen.isEmpty() ? ing.test(in) : EIMRecipeTranHandler.sameType(chosen, in)) || (can = Math.min(toTake, in.getCount())) <= 0 || (taken = invSlot.safeTake(can, can, player)).isEmpty()) continue;
                if (placedStack.isEmpty()) {
                    placedStack = taken;
                } else if (EIMRecipeTranHandler.sameType(placedStack, taken)) {
                    placedStack.grow(taken.getCount());
                } else {
                    player.getInventory().placeItemBackInInventory(taken);
                    break;
                }
                toTake -= taken.getCount();
            }
            if (toTake > 0) {
                ItemStack extracted;
                ItemStack template;
                ItemStack itemStack = !chosen.isEmpty() ? chosen : (template = ing.getItems().length > 0 ? ing.getItems()[0] : ItemStack.EMPTY);
                if (!template.isEmpty() && !(extracted = container.tryExtractFromPage(template, toTake)).isEmpty()) {
                    if (placedStack.isEmpty()) {
                        placedStack = extracted;
                    } else if (EIMRecipeTranHandler.sameType(placedStack, extracted)) {
                        placedStack.grow(extracted.getCount());
                    } else {
                        player.getInventory().placeItemBackInInventory(extracted);
                    }
                }
            }
            if (placedStack.isEmpty()) continue;
            int cap = Math.min(placedStack.getMaxStackSize(), target.getMaxStackSize());
            if (placedStack.getCount() > cap) {
                ItemStack overflow = placedStack.copyWithCount(placedStack.getCount() - cap);
                placedStack.setCount(cap);
                player.getInventory().placeItemBackInInventory(overflow);
            }
            target.set(placedStack);
        }
    }

    @Nullable
    private static ResourceLocation tryResolveRecipeId(Object recipeObj) {
        Object v;
        Method m2;
        try {
            m2 = recipeObj.getClass().getMethod("getId", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)v;
                return rl;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = recipeObj.getClass().getMethod("id", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)v;
                return rl;
            }
        }
        catch (Throwable m3) {
            // empty catch block
        }
        try {
            m2 = recipeObj.getClass().getMethod("value", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v != null) {
                return EIMRecipeTranHandler.tryResolveRecipeId(v);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static class EIMRecipeTranInfo
    implements IRecipeTransferInfo {
        public Class getContainerClass() {
            return CONTAINER_CLASS;
        }

        public Optional getMenuType() {
            return Optional.of(CONTAINER_TYPE);
        }

        public RecipeType getRecipeType() {
            return RecipeTypes.CRAFTING;
        }

        public boolean canHandle(AbstractContainerMenu container, Object recipe) {
            return container instanceof EndlessInventoryMenu;
        }

        public List<Slot> getRecipeSlots(AbstractContainerMenu container, Object recipe) {
            return ((EndlessInventoryMenu)container).getCraftingSlots();
        }

        public List<Slot> getInventorySlots(AbstractContainerMenu container, Object recipe) {
            return ((EndlessInventoryMenu)container).getPlayerInvSlots();
        }
    }

    private record TransferPlan(Ingredient[] layout, ItemStack[] chosenPerSlot, int craftsWanted, boolean missing) {
        boolean isMissing() {
            return this.missing;
        }
    }

    private static final class ItemAvailability {
        private final Map<ItemKey, ItemCounts> counts = new HashMap<ItemKey, ItemCounts>();

        private ItemAvailability() {
        }

        static ItemAvailability build(List<Slot> invSlots, List<ItemStack> pageItems) {
            ItemAvailability availability = new ItemAvailability();
            for (Slot slot : invSlots) {
                if (!slot.hasItem()) continue;
                availability.add(slot.getItem(), Source.INVENTORY);
            }
            for (ItemStack stack : pageItems) {
                if (stack.isEmpty()) continue;
                availability.add(stack, Source.PAGE);
            }
            return availability;
        }

        static ItemAvailability buildFromItems(List<ItemStack> invItems, List<ItemStack> pageItems) {
            ItemAvailability availability = new ItemAvailability();
            for (ItemStack stack : invItems) {
                if (stack.isEmpty()) continue;
                availability.add(stack, Source.INVENTORY);
            }
            for (ItemStack stack : pageItems) {
                if (stack.isEmpty()) continue;
                availability.add(stack, Source.PAGE);
            }
            return availability;
        }

        private void add(ItemStack stack, Source source) {
            ItemKey key = ItemKey.asKey(stack);
            ItemCounts counts = this.counts.computeIfAbsent(key, k -> new ItemCounts((ItemKey)k, stack.copyWithCount(1)));
            counts.add(stack.getCount(), source);
        }

        @Nullable
        ItemCounts lookup(ItemKey key) {
            return this.counts.get(key);
        }

        Collection<ItemCounts> all() {
            return this.counts.values();
        }

        private static enum Source {
            INVENTORY,
            PAGE;

        }
    }

    private static final class ItemCounts {
        private final ItemKey key;
        private final ItemStack representative;
        private int inventoryCount;
        private int pageCount;

        ItemCounts(ItemKey key, ItemStack representative) {
            this.key = key;
            this.representative = representative;
        }

        void add(int amount, ItemAvailability.Source source) {
            if (source == ItemAvailability.Source.INVENTORY) {
                this.inventoryCount += amount;
            } else {
                this.pageCount += amount;
            }
        }

        ItemKey key() {
            return this.key;
        }

        ItemStack representative() {
            return this.representative.copy();
        }

        int total() {
            return this.inventoryCount + this.pageCount;
        }

        int totalRemaining(Reservation reservation) {
            return this.total() - reservation.totalReserved(this.key);
        }

        int inventoryRemaining(Reservation reservation) {
            return this.inventoryCount - reservation.inventoryReserved(this.key);
        }

        boolean isPlain() {
            return this.key.components() != null && !this.key.components().isEmpty();
        }
    }

    private record Candidate(@Nullable Selection selection, int priority, int totalRemaining, int inventoryRemaining) {
        private static final Candidate NONE = new Candidate(Selection.EMPTY, -1, 0, 0);

        boolean isValid() {
            return this.selection != null && !this.selection.isEmpty();
        }

        static Candidate fromCounts(@Nullable ItemCounts counts, Reservation reservation) {
            boolean hasPlainInventory;
            if (counts == null) {
                return NONE;
            }
            int totalRemaining = counts.totalRemaining(reservation);
            if (totalRemaining <= 0) {
                return NONE;
            }
            int inventoryRemaining = counts.inventoryRemaining(reservation);
            boolean hasInventory = inventoryRemaining > 0;
            boolean bl = hasPlainInventory = hasInventory && counts.isPlain();
            int priority = hasPlainInventory ? 3 : (hasInventory ? 2 : 1);
            Selection selection = new Selection(counts.representative(), counts.key(), hasInventory);
            return new Candidate(selection, priority, totalRemaining, inventoryRemaining);
        }

        static Candidate pickBetter(Candidate current, Candidate challenger) {
            if (!challenger.isValid()) {
                return current;
            }
            if (!current.isValid()) {
                return challenger;
            }
            if (challenger.priority != current.priority) {
                return challenger.priority > current.priority ? challenger : current;
            }
            if (challenger.totalRemaining != current.totalRemaining) {
                return challenger.totalRemaining > current.totalRemaining ? challenger : current;
            }
            if (challenger.inventoryRemaining != current.inventoryRemaining) {
                return challenger.inventoryRemaining > current.inventoryRemaining ? challenger : current;
            }
            return current;
        }
    }

    private static final class Reservation {
        private final Map<ItemKey, Integer> total = new HashMap<ItemKey, Integer>();
        private final Map<ItemKey, Integer> inventory = new HashMap<ItemKey, Integer>();

        private Reservation() {
        }

        void reserve(Selection selection) {
            this.total.merge(selection.key(), 1, Integer::sum);
            if (selection.useInventory()) {
                this.inventory.merge(selection.key(), 1, Integer::sum);
            }
        }

        int totalReserved(ItemKey key) {
            return this.total.getOrDefault(key, 0);
        }

        int inventoryReserved(ItemKey key) {
            return this.inventory.getOrDefault(key, 0);
        }

        Map<ItemKey, Integer> totalDemand() {
            return this.total;
        }

        boolean isEmpty() {
            return this.total.isEmpty();
        }
    }

    private record Selection(ItemStack stack, @Nullable ItemKey key, boolean useInventory) {
        static final Selection EMPTY = new Selection(ItemStack.EMPTY, null, false);

        boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }
}

