/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.network.payloads;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.neoforge.integrates.jei.experimental.AEIRecipeTransferHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;

public record JeiAttachedTransferPayload(AEIRecipeTransferHandler.TransferContext context) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, JeiAttachedTransferPayload> STREAM_CODEC = StreamCodec.of((buf, value) -> JeiAttachedTransferPayload.encode(value, (FriendlyByteBuf)buf), JeiAttachedTransferPayload::decode);
    public static final CustomPacketPayload.Type<JeiAttachedTransferPayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("jei_attached_transfer"));

    public static void encode(JeiAttachedTransferPayload payload, FriendlyByteBuf buffer) {
        buffer.writeVarInt(payload.context.containerId());
        buffer.writeResourceLocation(payload.context.recipeId());
        buffer.writeBoolean(payload.context.maxTransfer());
        buffer.writeBoolean(payload.context.requireCompleteSets());
        buffer.writeVarInt(payload.context.craftingSlotIndexes().size());
        payload.context.craftingSlotIndexes().forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeVarInt(arg_0));
        buffer.writeVarInt(payload.context.inventorySlotIndexes().size());
        payload.context.inventorySlotIndexes().forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeVarInt(arg_0));
    }

    public static JeiAttachedTransferPayload decode(FriendlyByteBuf buffer) {
        int containerId = buffer.readVarInt();
        ResourceLocation recipeId = buffer.readResourceLocation();
        boolean maxTransfer = buffer.readBoolean();
        boolean requireCompleteSets = buffer.readBoolean();
        int craftingSize = buffer.readVarInt();
        ArrayList<Integer> craftingIndexes = new ArrayList<Integer>(craftingSize);
        for (int i = 0; i < craftingSize; ++i) {
            craftingIndexes.add(buffer.readVarInt());
        }
        int inventorySize = buffer.readVarInt();
        ArrayList<Integer> inventoryIndexes = new ArrayList<Integer>(inventorySize);
        for (int i = 0; i < inventorySize; ++i) {
            inventoryIndexes.add(buffer.readVarInt());
        }
        AEIRecipeTransferHandler.TransferContext context = new AEIRecipeTransferHandler.TransferContext(containerId, recipeId, maxTransfer, requireCompleteSets, craftingIndexes, inventoryIndexes);
        return new JeiAttachedTransferPayload(context);
    }

    @Override
    public String id() {
        return "jei_attached_transfer";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext modContext) {
        Player player = modContext.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AbstractContainerMenu container = player2.containerMenu;
        if (container == null || container.containerId != this.context.containerId()) {
            return;
        }
        Optional optional = player2.serverLevel().getRecipeManager().byKey(this.context.recipeId());
        if (optional.isEmpty()) {
            return;
        }
        Recipe<?> recipe = JeiAttachedTransferPayload.resolve(optional.get());
        if (recipe == null) {
            return;
        }
        PageMetaDataManager manager = AEIRecipeTransferHandler.getServerManager(player2);
        List<Slot> craftingSlots = JeiAttachedTransferPayload.collectSlots(container, this.context.craftingSlotIndexes());
        List<Slot> inventorySlots = JeiAttachedTransferPayload.collectSlots(container, this.context.inventorySlotIndexes());
        if (craftingSlots.size() != this.context.craftingSlotIndexes().size() || inventorySlots.size() != this.context.inventorySlotIndexes().size()) {
            return;
        }
        AEIRecipeTransferHandler.performServerTransfer(container, recipe, craftingSlots, inventorySlots, player2, manager, this.context.maxTransfer(), this.context.requireCompleteSets());
    }

    private static Recipe<?> resolve(Object recipeObj) {
        if (recipeObj instanceof Recipe) {
            Recipe recipe = (Recipe)recipeObj;
            return recipe;
        }
        try {
            Object value = recipeObj.getClass().getMethod("value", new Class[0]).invoke(recipeObj, new Object[0]);
            if (value instanceof Recipe) {
                Recipe recipe = (Recipe)value;
                return recipe;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static List<Slot> collectSlots(AbstractContainerMenu container, List<Integer> indexes) {
        ArrayList<Slot> slots = new ArrayList<Slot>(indexes.size());
        for (int index : indexes) {
            if (index < 0 || index >= container.slots.size()) continue;
            slots.add(container.getSlot(index));
        }
        return slots;
    }
}

