/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.options;

import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.options.IConfigValue;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.common.options.MissingEndInvPolicy;
import com.kwwsyk.endinv.common.options.SpecifiedMenuAttachingConfig;
import com.kwwsyk.endinv.common.util.Accessibility;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ServerConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.IntValue MAX_STACK_SIZE;
    public final ModConfigSpec.BooleanValue ENABLE_INFINITE;
    public final ModConfigSpec.BooleanValue ENABLE_AUTO_PICK;
    public final ModConfigSpec.EnumValue<ContentTransferMode> TRANSFER_MODE;
    public final ModConfigSpec.EnumValue<Accessibility> DEFAULT_ACCESSIBILITY;
    public final ModConfigSpec.EnumValue<MissingEndInvPolicy> CREATION_MODE;
    public final ModConfigSpec.BooleanValue CONVERT_EMPTY_TAG;
    public final IServerConfig INSTANCE = new IServerConfig(){

        private static IConfigValue<Integer> convert(ModConfigSpec.IntValue value) {
            return IConfigValue.of(() -> ((ModConfigSpec.IntValue)value).getAsInt(), arg_0 -> ((ModConfigSpec.IntValue)value).set(arg_0), () -> ((ModConfigSpec)CONFIG_SPEC).save());
        }

        private static IConfigValue<Boolean> convert(ModConfigSpec.BooleanValue value) {
            return IConfigValue.of(() -> ((ModConfigSpec.BooleanValue)value).getAsBoolean(), arg_0 -> ((ModConfigSpec.BooleanValue)value).set(arg_0), () -> ((ModConfigSpec)CONFIG_SPEC).save());
        }

        @Override
        public IConfigValue<Integer> getMaxAllowedStackSize() {
            return 1.convert(ServerConfig.this.MAX_STACK_SIZE);
        }

        @Override
        public IConfigValue<Boolean> allowInfinityMode() {
            return 1.convert(ServerConfig.this.ENABLE_INFINITE);
        }

        @Override
        public IConfigValue<Boolean> enableAutoPick() {
            return 1.convert(ServerConfig.this.ENABLE_AUTO_PICK);
        }

        @Override
        public void onAttachingOrAutopickConfigChanged() {
            CONFIG_SPEC.save();
        }

        @Override
        public void onSpecifiedMenuAttachabilityChanged() {
            CONFIG_SPEC.save();
        }

        @Override
        public IConfigValue<Boolean> enableAttaching() {
            return IConfigValue.of(() -> true, v -> {});
        }

        @Override
        public IConfigValue<ContentTransferMode> transferMode() {
            return IConfigValue.of(ServerConfig.this.TRANSFER_MODE, arg_0 -> ServerConfig.this.TRANSFER_MODE.set(arg_0));
        }

        @Override
        public IConfigValue<Accessibility> defaultAccessibility() {
            return IConfigValue.of(ServerConfig.this.DEFAULT_ACCESSIBILITY, arg_0 -> ServerConfig.this.DEFAULT_ACCESSIBILITY.set(arg_0));
        }

        @Override
        public IConfigValue<MissingEndInvPolicy> policyHandlingMissing() {
            return IConfigValue.of(ServerConfig.this.CREATION_MODE, arg_0 -> ServerConfig.this.CREATION_MODE.set(arg_0));
        }

        @Override
        public IConfigValue<Boolean> doConvertEmptyTag() {
            return 1.convert(ServerConfig.CONFIG.CONVERT_EMPTY_TAG);
        }

        @Override
        public IConfigValue<SpecifiedMenuAttachingConfig> specifiedMenuAttachability() {
            return IConfigValue.of(() -> SpecifiedMenuAttachingConfig.DEFAULT, v -> {});
        }
    };

    private ServerConfig(ModConfigSpec.Builder builder) {
        this.MAX_STACK_SIZE = builder.translation("config.endinv.comment.max_stack_size").defineInRange("ItemCapacity.maxStackSize", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        this.ENABLE_INFINITE = builder.translation("config.endinv.comment.enable_infinite1").define("ItemCapacity.enableInfinite", false);
        this.ENABLE_AUTO_PICK = builder.comment("Will enable player to auto pick item and exp").define("autoPickUtility", false);
        this.TRANSFER_MODE = builder.defineEnum("TransferMode", (Enum)ContentTransferMode.ALL);
        this.DEFAULT_ACCESSIBILITY = builder.defineEnum("defaultAccessibility", (Enum)Accessibility.PUBLIC);
        this.CREATION_MODE = builder.defineEnum("creationMode", (Enum)MissingEndInvPolicy.CREATE_PER_PLAYER);
        this.CONVERT_EMPTY_TAG = builder.comment("Convert itemstack with empty tag {} to null tag, for the bugs that item cannot be taken/stacked.").define("convert_empty_tag", true);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG = (ServerConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

