/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.data.EndlessInventoryData;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.AttachingMonitor;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.slf4j.Logger;

public final class ServerLevelEndInv {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<class_3222, PageMetaDataManager> PAGE_META_DATA_MANAGER = new HashMap<class_3222, PageMetaDataManager>();
    public static final Map<class_3222, EndlessInventory> TEMP_ENDINV_REG = new HashMap<class_3222, EndlessInventory>();
    public static EndlessInventoryData levelEndInvData;

    private ServerLevelEndInv() {
    }

    public static Optional<PageMetaDataManager> checkAndGetManagerForPlayer(class_3222 player) {
        Object object = player.field_7512;
        if (object instanceof EndlessInventoryMenu) {
            EndlessInventoryMenu menu = (EndlessInventoryMenu)object;
            return Optional.of(menu);
        }
        object = PAGE_META_DATA_MANAGER.get(player);
        if (object instanceof AttachingMonitor) {
            AttachingMonitor manager = (AttachingMonitor)object;
            if (manager.getMenu() != player.field_7512) {
                return Optional.empty();
            }
            return Optional.of(manager);
        }
        return Optional.empty();
    }

    public static Optional<EndlessInventory> getEndInvForPlayer(class_1657 player) {
        EndlessInventory endlessInventory = null;
        if (ServerLevelEndInv.hasEndInvUuid(player)) {
            endlessInventory = ServerLevelEndInv.getPlayerDefaultEndInv(player);
        }
        if (endlessInventory == null) {
            switch (ModInfo.getServerConfig().policyHandlingMissing().get()) {
                case CREATE_PER_PLAYER: {
                    endlessInventory = ServerLevelEndInv.levelEndInvData.levelEndInvs.stream().filter(endinv -> endinv.owner != null && endinv.owner.equals(player.method_5667())).findFirst().orElseGet(() -> ServerLevelEndInv.createForPlayer(player));
                    ModRegistries.NbtAttachments.getEndInvUUID().setTo(player, endlessInventory.getUuid());
                    break;
                }
                case USE_GLOBAL_SHARED: {
                    endlessInventory = ServerLevelEndInv.getFirstPublicEndInv();
                    ModRegistries.NbtAttachments.getEndInvUUID().setTo(player, endlessInventory.getUuid());
                }
            }
        }
        if (endlessInventory != null) {
            endlessInventory.viewers.add((class_3222)player);
        }
        return Optional.ofNullable(endlessInventory);
    }

    public static EndlessInventory createPublicEndInv() {
        EndlessInventory endlessInventory = new EndlessInventory();
        levelEndInvData.addEndInvToLevel(endlessInventory);
        endlessInventory.setAccessibility(Accessibility.PUBLIC);
        return endlessInventory;
    }

    public static EndlessInventory getFirstPublicEndInv() {
        Optional<EndlessInventory> optional = ServerLevelEndInv.levelEndInvData.levelEndInvs.stream().filter(endInv -> endInv.getOwnerUUID() == null && endInv.getAccessibility() == Accessibility.PUBLIC).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = ServerLevelEndInv.levelEndInvData.levelEndInvs.stream().filter(endInv -> endInv.getAccessibility() == Accessibility.PUBLIC).findFirst();
        return optional.orElseGet(ServerLevelEndInv::createPublicEndInv);
    }

    private static EndlessInventory createForPlayer(class_1657 player) {
        EndlessInventory endlessInventory = new EndlessInventory();
        levelEndInvData.addEndInvToLevel(endlessInventory);
        endlessInventory.setAccessibility(ModInfo.getServerConfig().defaultAccessibility().get());
        endlessInventory.setOwner(player.method_5667());
        ModRegistries.NbtAttachments.getEndInvUUID().setTo(player, endlessInventory.getUuid());
        return endlessInventory;
    }

    public static boolean hasEndInvUuid(class_1657 player) {
        UUID optional = ModRegistries.NbtAttachments.getEndInvUUID().getWith(player);
        if (optional == ModInfo.DEFAULT_UUID) {
            LOGGER.warn("Player {} has default endless inventory UUID.", (Object)player.method_5477().getString());
            return false;
        }
        return true;
    }

    private static EndlessInventory getPlayerDefaultEndInv(class_1657 player) {
        return levelEndInvData.fromUUID(ModRegistries.NbtAttachments.getEndInvUUID().getWith(player));
    }
}

