/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.IScreenEvent;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.network.payloads.toServer.OpenEndInvPayload;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AttachingScreen<T extends class_1703> {
    public static AttachingScreen<?> INSTANCE;
    private static final Logger LOGGER;
    public final class_465<T> screen;
    public final T menu;
    private ScreenFramework frameWork;

    public AttachingScreen(class_465<T> screen) {
        this.screen = screen;
        this.menu = screen.method_17577();
        INSTANCE = this;
    }

    public void init(IScreenEvent event) {
        this.frameWork = ScreenFramework.getInstance() == null ? new ScreenFramework(this) : ScreenFramework.getInstance();
        this.frameWork.addWidgetToScreen(event::addListener);
        CachedConfig.readAndSyncClientConfigToServer(false);
        ModInfo.getPacketDistributor().sendToServer(new OpenEndInvPayload(false, CachedConfig.currentLayout().rows()));
    }

    public void renderPre(IScreenEvent event) {
    }

    public void render(IScreenEvent event) {
        int mouseX = (int)event.getMouseX();
        int mouseY = (int)event.getMouseY();
        class_332 guiGraphics = event.getGuiGraphics();
        float partialTick = event.getPartialTick();
        this.frameWork.renderBg(guiGraphics, mouseX, mouseY, partialTick);
        this.frameWork.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void mouseClicked(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int keyCode = event.getButton();
        boolean isActionOverride = this.frameWork.mouseClicked(mouseX, mouseY, keyCode);
        event.setCanceled(isActionOverride);
    }

    public void mouseReleased(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int keyCode = event.getButton();
        event.setCanceled(this.frameWork.mouseReleased(mouseX, mouseY, keyCode));
    }

    public void mouseDragged(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int button = event.getMouseButton();
        double dragX = event.getDragX();
        double dragY = event.getDragY();
        event.setCanceled(this.frameWork.mouseDragged(mouseX, mouseY, button, dragX, dragY));
    }

    public void mouseScrolled(IScreenEvent event) {
        double scrollY = event.getScrollDeltaY();
        this.frameWork.mouseScrolled(event.getMouseX(), event.getMouseY(), scrollY);
    }

    public void keyPressed(IScreenEvent event) {
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        int modifiers = event.getModifiers();
        event.setCanceled(this.frameWork.keyPressed(keyCode, scanCode, modifiers));
    }

    public void charTyped(IScreenEvent event) {
        char codePoint = event.getCodePoint();
        int modifiers = event.getModifiers();
        event.setCanceled(this.frameWork.charTyped(codePoint, modifiers));
    }

    public void closed(IScreenEvent event) {
        this.frameWork.onClose();
        this.close("On attached screen closing");
    }

    public void close(@Nullable String reason) {
        INSTANCE = null;
        LOGGER.info("Attached Screen {} closed with reason: {}", (Object)this, (Object)reason);
    }

    public class_465<?> getScreen() {
        return this.screen;
    }

    public ScreenFramework getFrameWork() {
        return this.frameWork;
    }

    public List<class_768> getArea() {
        return List.of(new class_768(this.frameWork.leftPos, this.frameWork.topPos, this.frameWork.imageWidth, this.frameWork.imageHeight));
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

