/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page.manager;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.List;
import java.util.Objects;

public interface PageManager
extends PageMetaDataManager {
    public List<DisplayPage> getPages();

    public DisplayPage getDisplayingPage();

    default public void scrollTo(float pos) {
        this.getDisplayingPage().scrollTo(pos);
    }

    default public int getDisplayingPageIndex() {
        for (int i = 0; i < this.getPages().size(); ++i) {
            if (this.getPages().get(i) != this.getDisplayingPage()) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public void switchPageWithId(String id) {
        for (int i = 0; i < this.getPages().size(); ++i) {
            if (!Objects.equals(this.getPages().get((int)i).id, id)) continue;
            this.switchPageWithIndex(i);
        }
    }

    default public List<DisplayPage> buildPages() {
        return PageTypeRegistry.getDisplayPages().stream().map(type -> type.buildPage(this)).toList();
    }

    default public ItemPageContext getInPageContext() {
        int n;
        DisplayPage page = this.getDisplayingPage();
        if (page instanceof ItemPage) {
            ItemPage itemPage = (ItemPage)page;
            n = itemPage.getStartIndex();
        } else {
            n = 0;
        }
        return new ItemPageContext(n, this.rows() * this.columns(), this.getPageData());
    }

    @Override
    default public String getDisplayingPageId() {
        return this.getDisplayingPage().id;
    }

    @Override
    default public PageType getDisplayingPageType() {
        return this.getDisplayingPage().getPageType();
    }

    @Override
    default public int getItemSize() {
        return CachedSrcInv.INSTANCE.getItemSize();
    }

    @Override
    default public int getMaxStackSize() {
        return CachedSrcInv.INSTANCE.getMaxItemStackSize();
    }

    @Override
    default public boolean enableInfinity() {
        return CachedSrcInv.INSTANCE.isInfinityMode();
    }

    @Override
    default public SortType sortType() {
        return CachedConfig.sortType();
    }

    @Override
    default public void setSortType(SortType sortType) {
        CachedConfig.setSortType(sortType);
    }

    @Override
    default public boolean isSortReversed() {
        return CachedConfig.reverseSort();
    }

    @Override
    default public void setSortReversed(boolean reversed) {
        CachedConfig.setReverseSort(reversed);
    }

    @Override
    default public String searching() {
        return CachedConfig.searching();
    }

    @Override
    default public void setSearching(String searching) {
        CachedConfig.setSearching(searching);
    }

    @Override
    default public void sendEndInvData() {
    }
}

