/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndInvAffinities;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface EndInvCodecStrategy {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String END_INV_LIST_KEY = "endless_inventories";
    public static final String ITEM_LIST_KEY = "Items";
    public static final String SIZE_INT_KEY = "Size";
    public static final String LAST_MOD_TIME_LONG_KEY = "modState";
    public static final String UUID_KEY = "uuid";
    public static final String MAX_STACK_SIZE_INT_KEY = "maxItemStackSize";
    public static final String INFINITY_BOOL_KEY = "Infinity";
    public static final String AFFINITY_KEY = "Affinities";
    public static final String BOOKMARK_LIST_KEY = "starred_items";
    public static final String OWNER_UUID_KEY = "Owner";
    public static final String WHITE_LIST_KEY = "white_list";
    public static final String ACCESSIBILITY_KEY = "Accessibility";

    default public EndlessInventory deserializeEndInv(class_2487 invTag) {
        EndlessInventory endlessInventory = new EndlessInventory(invTag.method_25926(UUID_KEY));
        this.deserializeItems(endlessInventory, invTag);
        this.decodeAffinities(endlessInventory, (class_2487)invTag.method_10580(AFFINITY_KEY));
        if (invTag.method_10545(OWNER_UUID_KEY)) {
            endlessInventory.setOwner(invTag.method_25926(OWNER_UUID_KEY));
        }
        if (invTag.method_10545(WHITE_LIST_KEY)) {
            endlessInventory.white_list.addAll(invTag.method_10554(WHITE_LIST_KEY, 11).stream().map(class_2512::method_25930).toList());
        }
        if (invTag.method_10545(ACCESSIBILITY_KEY)) {
            endlessInventory.setAccessibility(Accessibility.valueOf(invTag.method_10558(ACCESSIBILITY_KEY)));
        }
        if (invTag.method_10545(MAX_STACK_SIZE_INT_KEY)) {
            endlessInventory.setMaxItemStackSize(invTag.method_10550(MAX_STACK_SIZE_INT_KEY));
        }
        if (invTag.method_10545(INFINITY_BOOL_KEY)) {
            endlessInventory.setInfinityMode(invTag.method_10577(INFINITY_BOOL_KEY));
        }
        return endlessInventory;
    }

    default public class_2487 serializeEndInv(EndlessInventory endInv) {
        class_2487 nbt = new class_2487();
        class_2487 itemData = this.serializeItems(endInv);
        nbt.method_10543(itemData);
        class_2487 affTag = this.encodeAffinities(endInv.affinities);
        nbt.method_10566(AFFINITY_KEY, (class_2520)affTag);
        nbt.method_25927(UUID_KEY, endInv.getUuid());
        if (endInv.getOwnerUUID() != null) {
            nbt.method_25927(OWNER_UUID_KEY, endInv.getOwnerUUID());
        }
        class_2499 whiteList = new class_2499();
        for (UUID uuid : endInv.white_list) {
            whiteList.add((Object)class_2512.method_25929((UUID)uuid));
        }
        nbt.method_10566(WHITE_LIST_KEY, (class_2520)whiteList);
        nbt.method_10582(ACCESSIBILITY_KEY, endInv.getAccessibility().name());
        nbt.method_10569(MAX_STACK_SIZE_INT_KEY, endInv.getMaxItemStackSize());
        nbt.method_10556(INFINITY_BOOL_KEY, endInv.isInfinityMode());
        return nbt;
    }

    public void deserializeItems(EndlessInventory var1, class_2487 var2);

    public class_2487 serializeItems(EndlessInventory var1);

    public boolean canHandle(class_2487 var1);

    default public class_2487 encodeAffinities(EndInvAffinities affinities) {
        class_2487 ret = new class_2487();
        if (affinities == null) {
            return ret;
        }
        class_2499 nbtTagList = new class_2499();
        List<class_1799> items = affinities.starredItems;
        for (class_1799 itemStack : items) {
            if (itemStack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack.method_46651(1), itemTag));
        }
        ret.method_10566(BOOKMARK_LIST_KEY, (class_2520)nbtTagList);
        return ret;
    }

    default public void decodeAffinities(EndlessInventory endlessInventory, @Nullable class_2487 nbt) {
        EndInvAffinities aff = endlessInventory.affinities;
        if (nbt == null) {
            return;
        }
        class_2499 tagList = nbt.method_10554(BOOKMARK_LIST_KEY, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTag = tagList.method_10602(i);
            EndInvCodecStrategy.parse((class_2520)itemTag).filter(it -> !it.method_7960()).ifPresent(aff::addStarredItem);
        }
    }

    public static Optional<class_1799> parse(class_2520 tag) {
        if (!(tag instanceof class_2487)) {
            return Optional.empty();
        }
        class_2487 compound = (class_2487)tag;
        try {
            return Optional.of(EndInvCodecStrategy.load(compound));
        }
        catch (Exception e) {
            LOGGER.error("Tried to load invalid item: '{}'", (Object)compound, (Object)e);
            return Optional.empty();
        }
    }

    public static class_2520 saveItem(class_1799 itemStack, class_2487 outputTag) {
        if (itemStack.method_7960()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return EndInvCodecStrategy.save(itemStack, outputTag);
    }

    public static class_2487 save(class_1799 stack, class_2487 compoundTag) {
        class_2960 resourcelocation = class_7923.field_41178.method_10221((Object)stack.method_7909());
        compoundTag.method_10582("id", resourcelocation.toString());
        compoundTag.method_10569("Count", stack.method_7947());
        if (stack.method_7969() != null) {
            compoundTag.method_10566("tag", (class_2520)stack.method_7969().method_10553());
        }
        return compoundTag;
    }

    public static class_1799 load(class_2487 compoundTag) {
        try {
            class_1799 ret = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(compoundTag.method_10558("id"))), compoundTag.method_10550("Count"));
            if (compoundTag.method_10573("tag", 10)) {
                class_2487 tag = compoundTag.method_10562("tag");
                ret.method_7980(tag);
            }
            return ret;
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.debug("Tried to load invalid item: {}", (Object)compoundTag, (Object)runtimeexception);
            return class_1799.field_8037;
        }
    }
}

