/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.integrates.jei;

import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.fabric.client.events.ScreenAttachment;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;

public class AttachmentGuiHandler
implements IGuiContainerHandler<class_465<?>> {
    static final Logger LOGGER = LogUtils.getLogger();

    public List<class_768> getGuiExtraAreas(class_465<?> containerScreen) {
        AttachingScreen<?> attachingScreen = ScreenAttachment.attachment;
        if (attachingScreen != null) {
            return attachingScreen.getArea();
        }
        return super.getGuiExtraAreas(containerScreen);
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(class_465<?> containerScreen, double mouseX, double mouseY) {
        if (ScreenFramework.getInstance() != null) {
            try {
                return Optional.of(new ItemClickEventWrapper(ScreenFramework.getInstance().getDisplayingPage(), mouseX, mouseY));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static class ItemClickEventWrapper
    implements IClickableIngredient<class_1799> {
        DisplayPage page;
        class_1799 hovered;
        class_768 hoveredSlotArea;

        public ItemClickEventWrapper(DisplayPage page, double mouseX, double mouseY) {
            this.page = page;
            this.hovered = page.getHoveredOrClickedItem(mouseX, mouseY);
            this.hoveredSlotArea = Objects.requireNonNull(page.getOneInteractableArea(mouseX - (double)page.getPageLeft(), mouseY - (double)page.getPageTop()));
            try {
                this.checkStatus(mouseX, mouseY);
            }
            catch (Exception e) {
                LOGGER.error("Check click area failed: ", (Throwable)e);
            }
        }

        @Deprecated
        public ITypedIngredient<class_1799> getTypedIngredient() {
            return new ITypedIngredient<class_1799>(){

                public IIngredientType<class_1799> getType() {
                    return this.getIngredientType();
                }

                public class_1799 getIngredient() {
                    return this.getIngredient();
                }
            };
        }

        public IIngredientType<class_1799> getIngredientType() {
            return VanillaTypes.ITEM_STACK;
        }

        public class_1799 getIngredient() {
            return this.hovered;
        }

        public class_768 getArea() {
            return this.hoveredSlotArea;
        }

        @TestOnly
        private void checkStatus(double mouseX, double mouseY) {
            class_768 area = this.getArea();
            if (!area.method_3318((int)mouseX, (int)mouseY)) {
                throw new IllegalStateException(String.format("The area does not contain clicked pos: clicked: [%.2f,%.2f], area: [from[%d,%d],to[%d,%d]]", mouseX, mouseY, area.method_3321(), area.method_3322(), area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320()));
            }
        }
    }
}

