/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.network;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.MenuAttachabilityPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetItemDisplayContentPayload;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetStarredPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.network.payloads.toServer.OpenEndInvPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.QuickMoveToPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ToggleCraftingPayload;
import com.kwwsyk.endinv.fabric.network.payloads.JeiTransferRecipePayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class FabricNetworking {
    private static final Map<Class<? extends ModPacketPayload>, PayloadRegistration<? extends ModPacketPayload>> CLIENTBOUND = new HashMap<Class<? extends ModPacketPayload>, PayloadRegistration<? extends ModPacketPayload>>();
    private static final Map<Class<? extends ModPacketPayload>, PayloadRegistration<? extends ModPacketPayload>> SERVERBOUND = new HashMap<Class<? extends ModPacketPayload>, PayloadRegistration<? extends ModPacketPayload>>();
    private static final List<PayloadRegistration<? extends ModPacketPayload>> CLIENTBOUND_REGISTRATIONS = new ArrayList<PayloadRegistration<? extends ModPacketPayload>>();

    private FabricNetworking() {
    }

    public static void init() {
        FabricNetworking.registerClientbound(EndInvContent.class, EndInvContent::encode, EndInvContent::decode, "endinv_content");
        FabricNetworking.registerClientbound(EndInvMetadata.class, EndInvMetadata::encode, EndInvMetadata::decode, "endinv_meta");
        FabricNetworking.registerClientbound(ItemPickedUpPayload.class, ItemPickedUpPayload::encode, ItemPickedUpPayload::decode, "auto_picked");
        FabricNetworking.registerClientbound(SetItemDisplayContentPayload.class, SetItemDisplayContentPayload::encode, SetItemDisplayContentPayload::decode, "itemdisplay_content");
        FabricNetworking.registerClientbound(SetStarredPagePayload.class, SetStarredPagePayload::encode, SetStarredPagePayload::decode, "starred_item");
        FabricNetworking.registerClientbound(MenuAttachabilityPayload.class, MenuAttachabilityPayload::encode, MenuAttachabilityPayload::decode, "menu_attachability");
        FabricNetworking.registerClientbound(SyncedConfig.class, SyncedConfig::encode, SyncedConfig::decode, SyncedConfig.DEFAULT.id());
        FabricNetworking.registerServerbound(ItemClickPayload.class, ItemClickPayload::encode, ItemClickPayload::decode, "item_click");
        FabricNetworking.registerServerbound(CreativeItemModPayload.class, CreativeItemModPayload::encode, CreativeItemModPayload::decode, "item_modify");
        FabricNetworking.registerServerbound(ItemPageContext.class, ItemPageContext::encode, ItemPageContext::decode, "page_context");
        FabricNetworking.registerServerbound(OpenEndInvPayload.class, OpenEndInvPayload::encode, OpenEndInvPayload::decode, "open_endinv");
        FabricNetworking.registerServerbound(QuickMoveToPagePayload.class, QuickMoveToPagePayload::encode, QuickMoveToPagePayload::decode, "quick_move_page");
        FabricNetworking.registerServerbound(StarItemPayload.class, StarItemPayload::encode, StarItemPayload::decode, "star_item");
        FabricNetworking.registerServerbound(ToggleCraftingPayload.class, ToggleCraftingPayload::encode, ToggleCraftingPayload::decode, "toggle_crafting");
        FabricNetworking.registerServerbound(SyncedConfig.class, SyncedConfig::encode, SyncedConfig::decode, SyncedConfig.DEFAULT.id());
        if (FabricLoader.getInstance().isModLoaded("jei")) {
            FabricNetworking.registerServerbound(JeiTransferRecipePayload.class, JeiTransferRecipePayload::encode, JeiTransferRecipePayload::decode, "jei_transfer_recipe");
        }
    }

    public static void initServerEncodersOnly() {
        FabricNetworking.registerClientbound(EndInvContent.class, EndInvContent::encode, EndInvContent::decode, "endinv_content");
        FabricNetworking.registerClientbound(EndInvMetadata.class, EndInvMetadata::encode, EndInvMetadata::decode, "endinv_meta");
        FabricNetworking.registerClientbound(ItemPickedUpPayload.class, ItemPickedUpPayload::encode, ItemPickedUpPayload::decode, "auto_picked");
        FabricNetworking.registerClientbound(SetItemDisplayContentPayload.class, SetItemDisplayContentPayload::encode, SetItemDisplayContentPayload::decode, "itemdisplay_content");
        FabricNetworking.registerClientbound(SetStarredPagePayload.class, SetStarredPagePayload::encode, SetStarredPagePayload::decode, "starred_item");
        FabricNetworking.registerClientbound(MenuAttachabilityPayload.class, MenuAttachabilityPayload::encode, MenuAttachabilityPayload::decode, "menu_attachability");
        FabricNetworking.registerClientbound(SyncedConfig.class, SyncedConfig::encode, SyncedConfig::decode, SyncedConfig.DEFAULT.id());
    }

    public static void initClient() {
        for (PayloadRegistration<? extends ModPacketPayload> registration : CLIENTBOUND_REGISTRATIONS) {
            FabricNetworking.registerClientReceiver(registration);
        }
    }

    public static void initClientEncodersOnly() {
        SERVERBOUND.put(ItemClickPayload.class, new PayloadRegistration<ItemClickPayload>(AbstractModInitializer.withModLocation("item_click"), ItemClickPayload::encode, ItemClickPayload::decode));
        SERVERBOUND.put(CreativeItemModPayload.class, new PayloadRegistration<CreativeItemModPayload>(AbstractModInitializer.withModLocation("item_modify"), CreativeItemModPayload::encode, CreativeItemModPayload::decode));
        SERVERBOUND.put(ItemPageContext.class, new PayloadRegistration<ItemPageContext>(AbstractModInitializer.withModLocation("page_context"), ItemPageContext::encode, ItemPageContext::decode));
        SERVERBOUND.put(OpenEndInvPayload.class, new PayloadRegistration<OpenEndInvPayload>(AbstractModInitializer.withModLocation("open_endinv"), OpenEndInvPayload::encode, OpenEndInvPayload::decode));
        SERVERBOUND.put(QuickMoveToPagePayload.class, new PayloadRegistration<QuickMoveToPagePayload>(AbstractModInitializer.withModLocation("quick_move_page"), QuickMoveToPagePayload::encode, QuickMoveToPagePayload::decode));
        SERVERBOUND.put(StarItemPayload.class, new PayloadRegistration<StarItemPayload>(AbstractModInitializer.withModLocation("star_item"), StarItemPayload::encode, StarItemPayload::decode));
        SERVERBOUND.put(ToggleCraftingPayload.class, new PayloadRegistration<ToggleCraftingPayload>(AbstractModInitializer.withModLocation("toggle_crafting"), ToggleCraftingPayload::encode, ToggleCraftingPayload::decode));
        SERVERBOUND.put(SyncedConfig.class, new PayloadRegistration<SyncedConfig>(AbstractModInitializer.withModLocation(SyncedConfig.DEFAULT.id()), SyncedConfig::encode, SyncedConfig::decode));
        if (FabricLoader.getInstance().isModLoaded("jei")) {
            SERVERBOUND.put(JeiTransferRecipePayload.class, new PayloadRegistration<JeiTransferRecipePayload>(AbstractModInitializer.withModLocation("jei_transfer_recipe"), JeiTransferRecipePayload::encode, JeiTransferRecipePayload::decode));
        }
    }

    public static void sendToServer(ModPacketPayload payload) {
        PayloadRegistration<ModPacketPayload> registration = FabricNetworking.getRegistration(SERVERBOUND, payload.getClass());
        class_2540 buf = PacketByteBufs.create();
        registration.encode(payload, buf);
        ClientPlayNetworking.send((class_2960)registration.id(), (class_2540)buf);
    }

    public static void sendToPlayer(class_3222 player, ModPacketPayload payload) {
        PayloadRegistration<ModPacketPayload> registration = FabricNetworking.getRegistration(CLIENTBOUND, payload.getClass());
        class_2540 buf = PacketByteBufs.create();
        registration.encode(payload, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)registration.id(), (class_2540)buf);
    }

    private static <T extends ModPacketPayload> void registerClientbound(Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, String id) {
        PayloadRegistration<T> registration = new PayloadRegistration<T>(AbstractModInitializer.withModLocation(id), encoder, decoder);
        CLIENTBOUND.put(type, registration);
        CLIENTBOUND_REGISTRATIONS.add(registration);
    }

    private static <T extends ModPacketPayload> void registerServerbound(Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, String id) {
        PayloadRegistration registration = new PayloadRegistration(AbstractModInitializer.withModLocation(id), encoder, decoder);
        SERVERBOUND.put(type, registration);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)registration.id(), (server, player, handler, buf, responseSender) -> {
            Object payload = registration.decode(buf);
            server.execute(() -> payload.handle(FabricNetworking.context(player)));
        });
    }

    private static void registerClientReceiver(PayloadRegistration<? extends ModPacketPayload> registration) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)registration.id(), (client, handler, buf, responseSender) -> {
            Object payload = registration.decode(buf);
            client.execute(() -> payload.handle(FabricNetworking.context((class_1657)client.field_1724)));
        });
    }

    private static ModPacketContext context(class_3222 player) {
        return () -> player;
    }

    private static ModPacketContext context(class_1657 player) {
        return () -> player;
    }

    private static PayloadRegistration<ModPacketPayload> getRegistration(Map<Class<? extends ModPacketPayload>, PayloadRegistration<? extends ModPacketPayload>> map, Class<?> type) {
        PayloadRegistration<ModPacketPayload> registration = map.get(type);
        if (registration == null) {
            throw new IllegalStateException("Unregistered payload type: " + type);
        }
        return registration;
    }

    private record PayloadRegistration<T extends ModPacketPayload>(class_2960 id, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder) {
        void encode(ModPacketPayload payload, class_2540 buf) {
            this.encoder.accept(payload, buf);
        }

        T decode(class_2540 buf) {
            return (T)((ModPacketPayload)this.decoder.apply(buf));
        }
    }
}

