/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import com.kwwsyk.endinv.common.util.SearchUtil;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.slf4j.Logger;

public abstract class SourceInventory {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Map<ItemKey, ItemState> itemMap;
    protected List<class_1799> items;
    protected UUID uuid;
    protected volatile long lastModTime = class_156.method_658();
    protected int maxStackSize;
    protected boolean infinityMode;
    @Nullable
    protected UUID owner;
    public List<UUID> white_list = new ArrayList<UUID>();
    protected Accessibility accessibility;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private volatile boolean itemsDirty = true;

    public SourceInventory(UUID uuid) {
        this.items = new ArrayList<class_1799>();
        this.itemMap = new Object2ObjectLinkedOpenHashMap();
        this.uuid = uuid;
        this.maxStackSize = ModInfo.getServerConfig().getMaxAllowedStackSize().get();
        this.infinityMode = ModInfo.getServerConfig().allowInfinityMode().get();
        this.accessibility = ModInfo.getServerConfig().defaultAccessibility().get();
    }

    public abstract boolean isRemote();

    public void setChanged() {
        this.markCacheDirty();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public UUID giveNewUuid() {
        this.uuid = UUID.randomUUID();
        return this.uuid;
    }

    public Map<ItemKey, ItemState> getItemMap() {
        return this.itemMap;
    }

    public List<class_1799> getItemsAsList() {
        return this.snapshotItems();
    }

    public int getItemSize() {
        this.readLock.lock();
        try {
            if (!this.itemsDirty) {
                int n = this.items.size();
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.itemsDirty) {
                this.refreshItemsFromMap();
            }
            int n = this.items.size();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getMaxItemStackSize() {
        return this.maxStackSize;
    }

    public void setMaxItemStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public boolean isInfinityMode() {
        return this.infinityMode;
    }

    public void setInfinityMode(boolean infinityMode) {
        this.infinityMode = infinityMode;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(Accessibility accessibility) {
        this.accessibility = accessibility;
    }

    public boolean accessible(class_1657 player) {
        return this.accessibility == Accessibility.PUBLIC || this.owner != null && this.owner.equals(player.method_5667()) || this.white_list.contains(player.method_5667()) && this.accessibility == Accessibility.RESTRICTED;
    }

    public boolean isOwner(class_1657 player) {
        return Objects.equals(player.method_5667(), this.owner);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    public class_1799 takeItem(class_1799 itemStack) {
        return this.takeItem(itemStack, itemStack.method_7914());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public class_1799 takeItem(class_1799 stack, int count) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        this.writeLock.lock();
        try {
            ItemKey key = ItemKey.asKey(stack);
            LOGGER.debug("EI:takeItem:stack->itemKay, stack={},itemKay = {}", (Object)stack, (Object)key);
            ItemState state = this.itemMap.get(key);
            if (state == null) {
                LOGGER.warn("EI:takeItem: no state for {}", (Object)key);
                LOGGER.debug("EI:Current Source Inventory: Class:{},UUID:{},Items:{}", new Object[]{this.getClass(), this.uuid, this.buildSnapshotLocked()});
                if (ModInfo.getServerConfig().doConvertEmptyTag().get().booleanValue() && stack.method_7969() != null) {
                    state = this.itemMap.get(key = new ItemKey(key.item(), null));
                    if (state == null) {
                        class_1799 class_17992 = class_1799.field_8037;
                        return class_17992;
                    }
                    LOGGER.info("EI:takeItem: converted ItemKey with empty tag {} to null tag", (Object)ItemKey.asKey(stack));
                } else {
                    class_1799 class_17993 = class_1799.field_8037;
                    return class_17993;
                }
            }
            LOGGER.info("EI:takeItem: key={} availableCount={} requestedCount={}", new Object[]{key, state.count(), count});
            if (state.count() >= this.maxStackSize && this.infinityMode) {
                LOGGER.info("EI:takeItem: infinity mode for {} returning {}", (Object)key, (Object)count);
                this.setChanged();
                class_1799 class_17994 = stack.method_46651(count);
                return class_17994;
            }
            int taken = Math.min(count, state.count());
            class_1799 result = stack.method_46651(taken);
            if (taken == state.count()) {
                this.itemMap.remove(key);
                this.updateLastModTime();
                LOGGER.info("EI:takeItem: removed all of {} (taken={})", (Object)key, (Object)taken);
            } else {
                this.itemMap.put(key, new ItemState(state.count() - taken, this.updateLastModTime()));
                LOGGER.info("EI:takeItem: taken={} remaining={} for {}", new Object[]{taken, state.count() - taken, key});
            }
            this.setChanged();
            class_1799 class_17995 = result;
            return class_17995;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_1799 addItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.writeLock.lock();
        try {
            class_1799 remain;
            ItemKey key = ItemKey.asKey(itemStack);
            if (ModInfo.getServerConfig().doConvertEmptyTag().get().booleanValue() && itemStack.method_7969() != null && Objects.equals(itemStack.method_7969(), new class_2487())) {
                key = new ItemKey(itemStack.method_7909(), null);
            }
            ItemState state = this.itemMap.get(key);
            int count = itemStack.method_7947();
            int original = 0;
            if (state != null) {
                original = state.count();
            }
            if (original < this.maxStackSize) {
                int increased = original + count;
                if (increased <= this.maxStackSize) {
                    this.itemMap.put(key, new ItemState(increased, this.updateLastModTime()));
                    remain = class_1799.field_8037;
                } else {
                    this.itemMap.put(key, new ItemState(this.maxStackSize, this.updateLastModTime()));
                    remain = itemStack.method_46651(increased - this.maxStackSize);
                }
            } else if (this.infinityMode) {
                this.itemMap.put(key, new ItemState(original, this.updateLastModTime()));
                remain = class_1799.field_8037;
            } else {
                class_1799 class_17992 = itemStack.method_7972();
                return class_17992;
            }
            this.setChanged();
            class_1799 class_17993 = remain;
            return class_17993;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearContent() {
        this.writeLock.lock();
        try {
            this.itemMap.clear();
            this.updateLastModTime();
            this.setChanged();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected List<class_1799> getSortedView(SortType type, boolean reverse) {
        List<class_1799> ret = this.snapshotItems();
        ret.sort(ModInfo.sortHelper.getComparator(type, this));
        if (reverse) {
            Collections.reverse(ret);
        }
        return ret;
    }

    public List<class_1799> getSortedAndFilteredItemView(int startIndex, int length, SortType sortType, boolean reverse, @Nullable Predicate<class_1799> classify, String search) {
        Stream base = this.getSortedView(sortType, reverse).stream();
        return base.filter(classify != null ? classify : is -> true).filter(stack -> SearchUtil.matchesSearch(stack, search)).skip(startIndex).limit(Math.max(length, 0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void syncItemsFromMap() {
        this.writeLock.lock();
        try {
            this.refreshItemsFromMap();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMapFromItems() {
        this.writeLock.lock();
        try {
            this.itemMap.clear();
            for (class_1799 stack : this.items) {
                if (stack.method_7960()) continue;
                long now = this.updateLastModTime();
                ItemKey key = ItemKey.asKey(stack);
                this.itemMap.put(key, new ItemState(stack.method_7947(), now));
            }
            this.markCacheDirty();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long updateLastModTime() {
        this.lastModTime = class_156.method_658();
        return this.lastModTime;
    }

    protected List<class_1799> snapshotItems() {
        this.readLock.lock();
        try {
            if (!this.itemsDirty) {
                ArrayList<class_1799> arrayList = new ArrayList<class_1799>(this.items);
                return arrayList;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.itemsDirty) {
                this.refreshItemsFromMap();
            }
            ArrayList<class_1799> arrayList = new ArrayList<class_1799>(this.items);
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void refreshItemsFromMap() {
        this.items = this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).collect(Collectors.toList());
        this.itemsDirty = false;
    }

    private List<class_1799> buildSnapshotLocked() {
        return this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).collect(Collectors.toList());
    }

    private void markCacheDirty() {
        this.itemsDirty = true;
    }

    protected void overwriteItems(Map<ItemKey, ItemState> newItems) {
        this.writeLock.lock();
        try {
            this.itemMap.clear();
            this.itemMap.putAll(newItems);
            this.markCacheDirty();
            this.updateLastModTime();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

