/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.IScreenEvent;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.SortTypeSwitcher;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toServer.OpenEndInvPayload;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AttachingScreen<T extends class_1703>
implements SortTypeSwitcher {
    public static AttachingScreen<?> INSTANCE;
    private static final Logger LOGGER;
    public final class_465<T> screen;
    private ScreenFramework frameWork;
    private final PageManager pageMetadata = new PageManager(){

        @Override
        public class_1703 getMenu() {
            return AttachingScreen.this.screen.method_17577();
        }

        @Override
        public SourceInventory getSourceInventory() {
            return CachedSrcInv.INSTANCE;
        }

        @Override
        public List<DisplayPage> getPages() {
            return AttachingScreen.this.pages;
        }

        @Override
        public DisplayPage getDisplayingPage() {
            return AttachingScreen.this.displayingPage;
        }

        @Override
        public void switchPageWithIndex(int index) {
            AttachingScreen.this.displayingPage = AttachingScreen.this.pages.get(index);
            CachedConfig.updateLayout(this.getPageData());
            AttachingScreen.this.displayingPage.initializeContents();
        }

        @Override
        public int rows() {
            return AttachingScreen.this.rows;
        }

        @Override
        public int columns() {
            return AttachingScreen.this.columns;
        }

        @Override
        public class_1657 getPlayer() {
            return AttachingScreen.this.player;
        }

        @Override
        public int getItemSize() {
            return CachedSrcInv.INSTANCE.getItemSize();
        }

        @Override
        public int getMaxStackSize() {
            return CachedSrcInv.INSTANCE.getMaxItemStackSize();
        }

        @Override
        public boolean enableInfinity() {
            return CachedSrcInv.INSTANCE.isInfinityMode();
        }

        @Override
        public class_1799 quickMoveFromPage(class_1799 stack) {
            return AttachingScreen.this.quickMoveHandler.quickMoveFromPage(stack);
        }

        @Override
        public SortType sortType() {
            return AttachingScreen.this.sortType;
        }

        @Override
        public void setSortType(SortType sortType) {
            AttachingScreen.this.sortType = sortType;
        }

        @Override
        public boolean isSortReversed() {
            return AttachingScreen.this.reverseSort;
        }

        @Override
        public void switchSortReversed() {
            AttachingScreen.this.reverseSort = !AttachingScreen.this.reverseSort;
        }

        @Override
        public void setSortReversed(boolean reversed) {
            AttachingScreen.this.reverseSort = reversed;
        }

        @Override
        public String searching() {
            return AttachingScreen.this.searching;
        }

        @Override
        public void setSearching(String searching) {
            AttachingScreen.this.searching = searching;
        }

        @Override
        public void sendEndInvData() {
        }
    };
    private final PageQuickMoveHandler quickMoveHandler;
    private boolean isHoveringOnSortBox;
    private DisplayPage displayingPage;
    public final List<DisplayPage> pages;
    private final int rows;
    private final int columns;
    public SortType sortType;
    public String searching;
    private final class_1657 player;
    private boolean reverseSort;

    public AttachingScreen(class_465<T> screen) {
        this.screen = screen;
        this.pages = this.pageMetadata.buildPages();
        assert (class_310.method_1551().field_1724 != null);
        this.player = class_310.method_1551().field_1724;
        PageData data = CachedConfig.resolveLayout(screen, false);
        this.rows = data.rows();
        this.columns = data.columns();
        this.sortType = data.sortType();
        this.searching = data.search();
        this.reverseSort = data.reverseSort();
        this.pageMetadata.switchPageWithId(data.pageRegKey());
        CachedConfig.updateLayout(data);
        this.quickMoveHandler = new PageQuickMoveHandler(this.pageMetadata);
        INSTANCE = this;
    }

    public void init(IScreenEvent event) {
        this.frameWork = ScreenFramework.getInstance() == null ? new ScreenFramework(this) : ScreenFramework.getInstance();
        this.frameWork.addWidgetToScreen(event::addListener);
        CachedConfig.readAndSyncClientConfigToServer(false);
        ModInfo.getPacketDistributor().sendToServer(new OpenEndInvPayload(false, this.rows));
    }

    public void renderPre(IScreenEvent event) {
        this.isHoveringOnSortBox = false;
    }

    public void render(IScreenEvent event) {
        int mouseX = (int)event.getMouseX();
        int mouseY = (int)event.getMouseY();
        class_332 guiGraphics = event.getGuiGraphics();
        float partialTick = event.getPartialTick();
        this.frameWork.renderBg(guiGraphics, mouseX, mouseY, partialTick);
        this.frameWork.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void mouseClicked(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int keyCode = event.getButton();
        boolean isActionOverride = this.frameWork.mouseClicked(mouseX, mouseY, keyCode);
        event.setCanceled(isActionOverride);
    }

    public void mouseReleased(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int keyCode = event.getButton();
        event.setCanceled(this.frameWork.mouseReleased(mouseX, mouseY, keyCode));
    }

    public void mouseDragged(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int button = event.getMouseButton();
        double dragX = event.getDragX();
        double dragY = event.getDragY();
        event.setCanceled(this.frameWork.mouseDragged(mouseX, mouseY, button, dragX, dragY));
    }

    public void mouseScrolled(IScreenEvent event) {
        double scrollY = event.getScrollDeltaY();
        this.frameWork.mouseScrolled(event.getMouseX(), event.getMouseY(), scrollY);
    }

    public void keyPressed(IScreenEvent event) {
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        int modifiers = event.getModifiers();
        event.setCanceled(this.frameWork.keyPressed(keyCode, scanCode, modifiers));
    }

    public void charTyped(IScreenEvent event) {
        char codePoint = event.getCodePoint();
        int modifiers = event.getModifiers();
        event.setCanceled(this.frameWork.charTyped(codePoint, modifiers));
    }

    public void closed(IScreenEvent event) {
        this.frameWork.onClose();
        this.close("On attached screen closing");
    }

    public void close(@Nullable String reason) {
        INSTANCE = null;
        LOGGER.info("Attached Screen {} closed with reason: {}", (Object)this, (Object)reason);
    }

    @Override
    public void switchSortTypeTo(SortType type) {
        this.sortType = type;
        CachedConfig.setSortType(type);
        CachedConfig.updateLayout(this.pageMetadata.getPageData());
        this.pageMetadata.getDisplayingPage().initializeContents();
        this.pageMetadata.getDisplayingPage().release();
        this.pageMetadata.getDisplayingPage().sendChangesToServer();
    }

    @Override
    public void setHoveringOnSortBox(boolean isHovering) {
        this.isHoveringOnSortBox = isHovering;
    }

    @Override
    public boolean isHoveringOnSortBox() {
        return this.isHoveringOnSortBox;
    }

    @Override
    public PageMetaDataManager getPageManager() {
        return this.pageMetadata;
    }

    @Override
    public class_465<?> getScreen() {
        return this.screen;
    }

    public ScreenFramework getFrameWork() {
        return this.frameWork;
    }

    public List<class_768> getArea() {
        return List.of(new class_768(this.frameWork.leftPos, this.frameWork.topPos, this.frameWork.imageWidth, this.frameWork.imageHeight));
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

