/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.SortTypeSwitcher;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.ToggleCraftingPayload;
import com.kwwsyk.endinv.common.util.SortType;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndlessInventoryScreen
extends class_465<EndlessInventoryMenu>
implements SortTypeSwitcher {
    private static final class_2960 CRAFTING_TEXTURE = new class_2960("minecraft", "textures/gui/container/crafting_table.png");
    private ScreenFramework frameWork;
    private class_5676<Boolean> craftingToggleButton;
    private boolean craftingVisible;
    public boolean isHoveringOnSortBox;

    public EndlessInventoryScreen(EndlessInventoryMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.recalcDimensions();
    }

    private void recalcDimensions() {
        int baseRows = ((EndlessInventoryMenu)this.field_2797).getBaseRows();
        this.field_2779 = 114 + baseRows * 18;
        this.field_25270 = this.field_2779 - 94;
    }

    public void method_25426() {
        super.method_25426();
        this.craftingVisible = ((EndlessInventoryMenu)this.field_2797).isCraftingVisible();
        this.recalcDimensions();
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
        ScreenFramework existing = ScreenFramework.getInstance();
        if (existing != null) {
            existing.onClose();
        }
        this.frameWork = new ScreenFramework(this);
        this.frameWork.addWidgetToScreen(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.addCraftingToggleButton();
    }

    private void addCraftingToggleButton() {
        int width = 70;
        this.craftingToggleButton = class_5676.method_32614().method_32619((Object)false).method_32617(0, 0, width, 20, (class_2561)class_2561.method_43470((String)"Crafter"), (it, on) -> {
            this.toggleCrafting();
            if ((Boolean)it.method_32603() != this.craftingVisible) {
                it.method_32605((Object)this.craftingVisible);
            }
        });
        this.updateCraftingToggleButtonPosition();
        this.method_37063((class_364)this.craftingToggleButton);
    }

    private void updateCraftingToggleButtonPosition() {
        if (this.craftingToggleButton == null) {
            return;
        }
        int width = this.craftingToggleButton.method_25368();
        int x = this.field_2776 + this.field_2792 - width - 8;
        int y = this.field_2800 - 20;
        this.craftingToggleButton.method_46421(x);
        this.craftingToggleButton.method_46419(y);
    }

    private void toggleCrafting() {
        this.craftingVisible = !this.craftingVisible;
        ((EndlessInventoryMenu)this.field_2797).setCraftingVisible(this.craftingVisible);
        ModInfo.getPacketDistributor().sendToServer(new ToggleCraftingPayload(this.craftingVisible));
        int previousTop = this.field_2800;
        this.recalcDimensions();
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
        this.updateCraftingToggleButtonPosition();
        if (this.frameWork != null) {
            this.frameWork.resizePageRows(((EndlessInventoryMenu)this.field_2797).getVisibleRows());
            this.frameWork.move(0, this.field_2800 - previousTop);
        }
    }

    private void drawCraftingBackground(class_332 guiGraphics) {
        int craftX = this.field_2776;
        int craftY = this.field_2800 + 18 * ((EndlessInventoryMenu)this.field_2797).getVisibleRows() + 18;
        guiGraphics.method_25302(CRAFTING_TEXTURE, craftX, craftY, 0, 12, 176, 58);
    }

    public void method_25394(@NotNull class_332 gui, int mouseX, int mouseY, float partialTick) {
        this.method_25420(gui);
        this.frameWork.renderPre(gui, mouseX, mouseY, partialTick);
        super.method_25394(gui, mouseX, mouseY, partialTick);
        this.frameWork.render(gui, mouseX, mouseY, partialTick);
        this.method_2380(gui, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int keyCode) {
        for (class_364 guieventlistener : this.method_25396()) {
            if (!guieventlistener.method_25402(mouseX, mouseY, keyCode)) continue;
            this.method_25395(guieventlistener);
            if (keyCode == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return this.frameWork.mouseClicked(mouseX, mouseY, keyCode) || super.method_25402(mouseX, mouseY, keyCode);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.frameWork.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int keyCode) {
        return this.frameWork.mouseReleased(mouseX, mouseY, keyCode) || super.method_25406(mouseX, mouseY, keyCode);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        return super.method_25401(mouseX, mouseY, scrollY) || this.frameWork.mouseScrolled(mouseX, mouseY, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.frameWork.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        return this.frameWork.charTyped(codePoint, modifiers);
    }

    protected void method_2383(@Nullable class_1735 slot, int slotId, int mouseButton, @NotNull class_1713 type) {
        super.method_2383(slot, slotId, mouseButton, type);
        ((EndlessInventoryMenu)this.field_2797).method_7623();
    }

    public void method_25419() {
        super.method_25419();
        this.frameWork.onClose();
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.frameWork.renderBg(guiGraphics, mouseX, mouseY, partialTick);
        if (((EndlessInventoryMenu)this.field_2797).isCraftingVisible()) {
            this.drawCraftingBackground(guiGraphics);
        }
    }

    @Override
    public void switchSortTypeTo(SortType type) {
        ((EndlessInventoryMenu)this.field_2797).sortType = type;
        CachedConfig.setSortType(type);
        CachedConfig.updateLayout(((EndlessInventoryMenu)this.field_2797).getPageData());
        if (this.frameWork != null && this.frameWork.meta != null) {
            DisplayPage page = this.frameWork.meta.getDisplayingPage();
            page.initializeContents();
            page.release();
            page.sendChangesToServer();
        }
    }

    @Override
    public void setHoveringOnSortBox(boolean isHovering) {
        this.isHoveringOnSortBox = isHovering;
    }

    @Override
    public boolean isHoveringOnSortBox() {
        return this.isHoveringOnSortBox;
    }

    @Override
    public PageMetaDataManager getPageManager() {
        return (PageMetaDataManager)this.field_2797;
    }

    @Override
    public class_465<?> getScreen() {
        return this;
    }

    public ScreenFramework getFrameWork() {
        return this.frameWork;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    public int getXSize() {
        return this.field_2792;
    }

    public int getYSize() {
        return this.field_2779;
    }
}

