/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.KeyMappings;
import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.SortTypeSwitcher;
import com.kwwsyk.endinv.common.client.gui.bg.FromResource;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import com.kwwsyk.endinv.common.client.gui.bg.Transparent;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.ClientPageManager;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.gui.widget.SortTypeSwitchBox;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.client.option.MenuAttachabilityCache;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.QuickMoveToPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_481;
import org.jetbrains.annotations.NotNull;

public class ScreenFramework {
    private static ScreenFramework INSTANCE;
    private final class_310 mc;
    public final PageManager meta;
    public final class_465<?> screen;
    public final class_1703 menu;
    private final SortTypeSwitcher sortTypeSwitcher;
    private ScreenRectangleWidgetParam searchBoxParam;
    private ScreenRectangleWidgetParam sortBoxParam;
    private ScreenRectangleWidgetParam configButtonParam;
    private ScreenRectangleWidgetParam pageBarScrollUpButtonParam;
    private ScreenRectangleWidgetParam pageBarScrollDownButtonParam;
    public SFBgRenderer SFBgRenderer;
    public final int pageBarCount;
    public int firstPageIndex = 0;
    public int leftPos;
    public int topPos;
    public int imageWidth;
    public int imageHeight;
    private int pageX;
    private int pageY;
    private int rows;
    private final int columns;
    private final int pageXSize;
    private int pageYSize;
    private int pageOffsetX;
    private int pageOffsetY;
    private int roughMouseX;
    private int roughMouseY;
    private class_342 searchBox;
    public SortTypeSwitchBox sortTypeSwitchBox;
    private class_4185 reverseSortButton;
    private class_4185 configButton;
    private final List<class_339> widgets = new ArrayList<class_339>();
    private boolean isHoveringOnPage;
    private class_1799 creativeQuickInsertedItem = class_1799.field_8037;
    private boolean ignoreTextInput;

    public ScreenFramework(EndlessInventoryScreen screen) {
        PageManager pageManager;
        this.screen = screen;
        this.mc = class_310.method_1551();
        PageMetaDataManager delegate = screen.getPageManager();
        if (delegate instanceof PageManager) {
            PageManager pm = (PageManager)delegate;
            pageManager = pm;
        } else {
            pageManager = new ClientPageManager(delegate);
        }
        this.meta = pageManager;
        this.menu = screen.method_17577();
        this.leftPos = screen.getGuiLeft();
        this.topPos = screen.getGuiTop();
        this.imageWidth = screen.getXSize();
        this.imageHeight = screen.getYSize();
        PageData layout = CachedConfig.resolveLayout(screen, true);
        this.columns = Math.max(1, layout.columns());
        this.rows = Math.max(1, this.meta.rows());
        this.sortTypeSwitcher = screen;
        SortType sort = layout.sortType();
        this.meta.setSortType(sort);
        this.meta.setSortReversed(layout.reverseSort());
        this.meta.setSearching(layout.search());
        this.meta.switchPageWithId(layout.pageRegKey());
        CachedConfig.updateLayout(this.meta.getPageData());
        this.pageBarCount = Math.min(ClientModInfo.getClientConfig().maxPageBarCount().get(), this.meta.getPages().size());
        this.pageBarScrollUpButtonParam = new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos - 16, 30, 14);
        this.pageBarScrollDownButtonParam = new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 2 + 28 * this.pageBarCount, 30, 14);
        this.configButtonParam = new ScreenRectangleWidgetParam(this.leftPos + this.imageWidth, Math.min(this.topPos + this.imageHeight, screen.field_22790 - 20), 18, 18);
        this.searchBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 89, this.topPos + 5, 80, 12);
        this.sortBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 8, this.topPos + 5, 60, 12);
        this.SFBgRenderer = new FromResource.MenuMode(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 1, 32, 28));
        this.pageX = this.leftPos + 8;
        this.pageY = this.topPos + 17;
        this.pageXSize = this.columns * 18;
        this.pageYSize = this.rows * 18;
        this.addWidgets();
        this.meta.getDisplayingPage().initializeContents();
        INSTANCE = this;
    }

    public int getPageX() {
        return this.pageX + this.pageOffsetX;
    }

    public int getPageY() {
        return this.pageY + this.pageOffsetY;
    }

    public void move(int deltaX, int deltaY) {
        this.pageOffsetX += deltaX;
        this.pageOffsetY += deltaY;
        DisplayPage current = this.meta.getDisplayingPage();
        if (current != null) {
            current.move(deltaX, deltaY);
        }
    }

    public void resizePageRows(int rows) {
        this.rows = Math.max(1, rows);
        this.pageYSize = this.rows * 18;
        DisplayPage current = this.meta.getDisplayingPage();
        if (current != null) {
            current.resize(this.rows);
        }
    }

    public ScreenFramework(AttachingScreen<?> attachingScreen) {
        PageManager pageManager;
        this.screen = attachingScreen.screen;
        this.mc = class_310.method_1551();
        PageMetaDataManager delegate = attachingScreen.getPageManager();
        if (delegate instanceof PageManager) {
            PageManager pm = (PageManager)delegate;
            pageManager = pm;
        } else {
            pageManager = new ClientPageManager(delegate);
        }
        this.meta = pageManager;
        this.menu = this.meta.getMenu();
        this.leftPos = 20;
        this.rows = this.meta.rows();
        this.topPos = Math.max((this.screen.field_22790 - this.rows * 18 - 17 - 10) / 2, 20);
        this.columns = this.meta.columns();
        this.sortTypeSwitcher = attachingScreen;
        this.pageBarCount = Math.min(ClientModInfo.getClientConfig().maxPageBarCount().get(), this.meta.getPages().size());
        this.imageWidth = 13 + 18 * this.columns;
        this.imageHeight = this.screen.field_22790;
        int searchBoxY = this.topPos + 17 + 18 * this.rows + 12;
        this.searchBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 1, searchBoxY, Math.min(200, this.imageWidth), Math.min(20, this.screen.field_22790 - searchBoxY));
        this.configButtonParam = new ScreenRectangleWidgetParam(0, Math.min(searchBoxY, this.screen.field_22790 - 20), 20, 20);
        this.pageBarScrollUpButtonParam = new ScreenRectangleWidgetParam(0, this.topPos, 20, 14);
        this.pageBarScrollDownButtonParam = new ScreenRectangleWidgetParam(0, this.topPos + 22 + 28 * this.pageBarCount, 20, 14);
        this.sortBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 6, this.topPos + 5, 77, 12);
        this.SFBgRenderer = ClientModInfo.getClientConfig().textureMode().get() != TextureMode.TRANSPARENT ? new FromResource.LeftLayout(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 20, 32, 28)) : new Transparent(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 20, 32, 28));
        this.pageX = this.leftPos + 8;
        this.pageY = this.topPos + 17;
        this.pageXSize = this.columns * 18;
        this.pageYSize = this.rows * 18;
        this.addWidgets();
        this.meta.getDisplayingPage().initializeContents();
        INSTANCE = this;
    }

    private void addWidgets() {
        this.configButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), btn -> this.mc.method_1507(ClientModInfo.createConfigScreen(this.screen))).method_46433(this.configButtonParam.XPos(), this.configButtonParam.YPos()).method_46437(this.configButtonParam.XSize(), this.configButtonParam.YSize()).method_46431();
        this.reverseSortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21c5"), btn -> {
            this.meta.switchSortReversed();
            CachedConfig.setReverseSort(this.meta.isSortReversed());
            CachedConfig.updateLayout(this.meta.getPageData());
            this.meta.getDisplayingPage().initializeContents();
            this.meta.getDisplayingPage().sendChangesToServer();
        }).method_46433(this.sortBoxParam.XPos() + this.sortBoxParam.XSize() + 2, this.sortBoxParam.YPos()).method_46437(this.sortBoxParam.YSize(), this.sortBoxParam.YSize()).method_46431();
        this.searchBox = new class_342(this.mc.field_1772, this.searchBoxParam.XPos(), this.searchBoxParam.YPos(), this.searchBoxParam.XSize(), this.searchBoxParam.YSize(), (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.sortTypeSwitchBox = new SortTypeSwitchBox(this.sortTypeSwitcher, this.meta, this.sortBoxParam);
        this.searchBox.method_1852(this.meta.searching());
        if (this.pageBarCount < this.meta.getPages().size()) {
            class_4185 up = class_4185.method_46430((class_2561)class_2561.method_43470((String)"^"), btn -> {
                if (this.firstPageIndex > 0) {
                    --this.firstPageIndex;
                }
            }).method_46433(this.pageBarScrollUpButtonParam.XPos(), this.pageBarScrollUpButtonParam.YPos()).method_46437(this.pageBarScrollUpButtonParam.XSize(), this.pageBarScrollUpButtonParam.YSize()).method_46431();
            class_4185 down = class_4185.method_46430((class_2561)class_2561.method_43470((String)"v"), btn -> {
                if (this.firstPageIndex + this.pageBarCount < this.meta.getPages().size()) {
                    ++this.firstPageIndex;
                }
            }).method_46433(this.pageBarScrollDownButtonParam.XPos(), this.pageBarScrollDownButtonParam.YPos()).method_46437(this.pageBarScrollDownButtonParam.XSize(), this.pageBarScrollDownButtonParam.YSize()).method_46431();
            this.widgets.add((class_339)up);
            this.widgets.add((class_339)down);
        }
        this.widgets.add((class_339)this.configButton);
        this.widgets.add((class_339)this.reverseSortButton);
        this.widgets.add((class_339)this.searchBox);
        this.widgets.add(this.sortTypeSwitchBox);
    }

    public void addWidgetToScreen(Consumer<class_339> installer) {
        this.widgets.forEach(installer);
    }

    public void renderPre(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.sortTypeSwitcher.setHoveringOnSortBox(false);
    }

    public void renderBg(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.SFBgRenderer.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.meta.getDisplayingPage().renderBg(this.SFBgRenderer, guiGraphics, partialTick, mouseX, mouseY);
    }

    public void render(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.roughMouseX = mouseX;
        this.roughMouseY = mouseY;
        this.isHoveringOnPage = this.hasClickedOnPage(mouseX, mouseY);
        this.meta.getDisplayingPage().initRenderer(this, this.getPageX(), this.getPageY());
        this.meta.getDisplayingPage().render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.searchBox.method_49606() && !this.searchBox.method_25370()) {
            guiGraphics.method_51437(this.mc.field_1772, List.of(class_2561.method_43471((String)"search.endinv.prefix.sharp"), class_2561.method_43471((String)"search.endinv.prefix.at"), class_2561.method_43471((String)"search.endinv.prefix.xor"), class_2561.method_43471((String)"search.endinv.prefix.star")), Optional.empty(), mouseX, mouseY);
        }
        if (this.reverseSortButton.method_49606()) {
            guiGraphics.method_51438(this.mc.field_1772, (class_2561)class_2561.method_43471((String)"button.endinv.reverse"), mouseX, mouseY);
        }
    }

    protected boolean hasClickedOnPage(double mouseX, double mouseY) {
        return mouseX >= (double)this.getPageX() && mouseX <= (double)this.getPageX() + (double)this.pageXSize && mouseY >= (double)this.getPageY() && mouseY <= (double)this.getPageY() + (double)this.pageYSize && !this.sortTypeSwitcher.isHoveringOnSortBox();
    }

    protected int hasClickedOnPageSwitchBar(double mouseX, double mouseY) {
        double XOffset = mouseX - (double)this.SFBgRenderer.pageSwitchBarParam().XPos();
        double YOffset = mouseY - (double)this.SFBgRenderer.pageSwitchBarParam().YPos();
        if (XOffset < 0.0 || XOffset > (double)this.SFBgRenderer.pageSwitchBarParam().XSize() || YOffset < 0.0) {
            return -1;
        }
        int index = (int)YOffset / this.SFBgRenderer.pageSwitchBarParam().YSize();
        if (index < 0 || index >= this.pageBarCount) {
            return -1;
        }
        return index;
    }

    protected void pageSwitched(int index) {
        this.meta.switchPageWithIndex(index + this.firstPageIndex);
        this.searchBox.method_1862(this.meta.getDisplayingPage().hasSearchbox());
        this.sortTypeSwitchBox.field_22764 = this.meta.getDisplayingPage().hasSortTypeSwitchBar();
        CachedConfig.setPageKey(this.meta.getDisplayingPageId());
        CachedConfig.updateLayout(this.meta.getPageData());
    }

    private boolean isHovering(class_1735 slot, double mouseX, double mouseY) {
        return this.isHovering(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        int i = ClientModInfo.containerScreenHelper.getGuiLeft(this.screen);
        int j = ClientModInfo.containerScreenHelper.getGuiTop(this.screen);
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public boolean notHoveringOnSortBox() {
        return !this.sortTypeSwitcher.isHoveringOnSortBox();
    }

    @Nullable
    private class_1735 findSlot(double mouseX, double mouseY) {
        for (int i = 0; i < this.menu.field_7761.size(); ++i) {
            class_1735 slot = (class_1735)this.menu.field_7761.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    private void slotQuickMoved(class_1735 clicked) {
        class_1799 itemStack = clicked.method_7677().method_7972();
        if (this.menu instanceof class_481.class_483 && clicked.field_7874 < 45 && this.menu.field_7761.size() >= 54) {
            if (class_1799.method_31577((class_1799)itemStack, (class_1799)this.creativeQuickInsertedItem)) {
                return;
            }
            this.creativeQuickInsertedItem = itemStack;
            itemStack.method_7939(itemStack.method_7914());
            this.meta.getDisplayingPage().tryInsertItem(itemStack);
            ModInfo.getPacketDistributor().sendToServer(new CreativeItemModPayload(itemStack, true));
        } else {
            boolean canAttach;
            boolean bl = canAttach = this.screen instanceof EndlessInventoryScreen || MenuAttachabilityCache.isAttachable(this.screen);
            if (!canAttach) {
                return;
            }
            class_1799 remain = this.meta.getDisplayingPage().tryInsertItem(itemStack);
            clicked.method_48931(remain);
            clicked.method_7667(this.meta.getPlayer(), itemStack);
            ModInfo.getPacketDistributor().sendToServer(new QuickMoveToPagePayload(this.menu instanceof class_481.class_483 ? this.getItemPickerMenuSlotOffset(clicked) : clicked.field_7874));
        }
        DisplayPage displayPage = this.meta.getDisplayingPage();
        if (displayPage instanceof ItemPage) {
            ItemPage itemPage = (ItemPage)displayPage;
            itemPage.requestRemoteContents();
        }
    }

    private int getItemPickerMenuSlotOffset(class_1735 clicked) {
        int originalIndex = clicked.field_7874;
        if (originalIndex == 0 && clicked.method_34266() > 0) {
            return clicked.method_34266();
        }
        if (originalIndex < 45) {
            return originalIndex;
        }
        return originalIndex - 9;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int keyCode) {
        class_1735 clicked;
        if (!this.searchBoxParam.hasClickedOn((int)mouseX, (int)mouseY)) {
            this.searchBox.method_25365(false);
        } else {
            this.searchBox.method_25365(true);
            if (keyCode == 1) {
                this.searchBox.method_1852("");
                this.refreshSearchResults();
                return true;
            }
        }
        boolean flg = ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.QUICK_MOVE, class_3675.class_307.field_1672.method_1447(keyCode));
        if (flg && (clicked = this.findSlot(mouseX, mouseY)) != null && clicked.method_7681()) {
            this.slotQuickMoved(clicked);
            return true;
        }
        int pageIndex = this.hasClickedOnPageSwitchBar(mouseX, mouseY);
        if (pageIndex >= 0) {
            this.pageSwitched(pageIndex);
            return true;
        }
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            this.sortTypeSwitchBox.setOpen(false);
            return this.meta.getDisplayingPage().mouseClicked(mouseX - (double)this.getPageX(), mouseY - (double)this.getPageY(), keyCode);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        class_1735 clicked;
        class_1799 itemstack = this.menu.method_34255();
        if (!itemstack.method_7960() || ((Boolean)this.mc.field_1690.method_42446().method_41753()).booleanValue()) {
            return false;
        }
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.QUICK_MOVE, class_3675.class_307.field_1672.method_1447(button)) && (clicked = this.findSlot(mouseX, mouseY)) != null && clicked.method_7681()) {
            this.slotQuickMoved(clicked);
            return true;
        }
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            return this.meta.getDisplayingPage().mouseDragged(mouseX - (double)this.getPageX(), mouseY - (double)this.getPageY(), button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int keyCode) {
        this.creativeQuickInsertedItem = class_1799.field_8037;
        DisplayPage displayingPage = this.meta.getDisplayingPage();
        displayingPage.release();
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            return displayingPage.mouseReleased(mouseX - (double)this.getPageX(), mouseY - (double)this.getPageY(), keyCode);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            mouseY = this.getPageY();
            return this.meta.getDisplayingPage().mouseScrolled(mouseX - (double)this.getPageX(), mouseY, scrollY);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        class_1735 clicked;
        this.ignoreTextInput = false;
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.STAR_ITEM, class_3675.method_15985((int)keyCode, (int)scanCode)) && (clicked = this.findSlot(this.roughMouseX, this.roughMouseY)) != null && clicked.method_7681()) {
            class_1799 itemStack = clicked.method_7677();
            ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(itemStack, true));
            this.meta.getDisplayingPage().sendChangesToServer();
            return true;
        }
        boolean flag = false;
        if (this.isHoveringOnPage) {
            flag = this.meta.getDisplayingPage().keyPressed(keyCode, scanCode, modifiers, this.roughMouseX - this.getPageX(), this.roughMouseY - this.getPageY());
        }
        if (flag) {
            this.ignoreTextInput = true;
            return true;
        }
        if (this.meta.getDisplayingPage().hasSearchbox() && this.searchBox.method_25370()) {
            String s = this.searchBox.method_1882();
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                if (!Objects.equals(s, this.searchBox.method_1882())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            return this.searchBox.method_25370() && this.searchBox.method_1885() && keyCode != 256;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.ignoreTextInput || !this.meta.getDisplayingPage().hasSearchbox()) {
            return false;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public void onClose() {
        INSTANCE = null;
    }

    public void refreshSearchResults() {
        String searching = this.searchBox.method_1882();
        this.meta.setSearching(searching);
        CachedConfig.setSearching(searching);
        CachedConfig.updateLayout(this.meta.getPageData());
        this.meta.getDisplayingPage().initializeContents();
        this.meta.getDisplayingPage().release();
        this.meta.getDisplayingPage().sendChangesToServer();
    }

    @Nullable
    public static ScreenFramework getInstance() {
        return INSTANCE;
    }
}

