/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.bg.FromResource;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public class ItemEntryDisplay
extends ItemDisplay {
    private static final int TOOLTIP_X_SEP = 5;
    protected boolean jmpTooltip1st = true;
    protected SFBgRenderer.PageBgRender renderer = null;

    public ItemEntryDisplay(PageType pageType, PageMetaDataManager metaDataManager) {
        super(pageType, metaDataManager);
        this.length = this.meta.rows();
    }

    @Override
    public void scrollTo(float pos) {
        int startIndex = this.getRowIndexForScroll(pos);
        this.initializeContents(startIndex, this.length);
    }

    @Override
    public void initializeContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows());
        if (this.items == null || length != this.items.size()) {
            this.items = class_2371.method_10213((int)length, (Object)class_1799.field_8037);
        }
        this.release();
        this.requestRemoteContents();
    }

    public void toggleJmpItemName(boolean jmpTooltip1st) {
        this.jmpTooltip1st = jmpTooltip1st;
    }

    @Override
    protected boolean clickedInOneSlot(double XOffset, double YOffset, double lastX, double lastY) {
        return (int)YOffset / 18 == (int)lastY / 18;
    }

    @Override
    public int getSlotForMouseOffset(double XOffset, double YOffset) {
        if (XOffset < 0.0 || YOffset < 0.0 || XOffset > (double)(18 * this.meta.columns()) || YOffset > (double)(18 * this.meta.rows())) {
            return -1;
        }
        return (int)YOffset / 18;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isHiddenBySortBox(int rowIndex, int columnIndex) {
        if (rowIndex > 2) return false;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof class_465)) return false;
        class_465 screen = (class_465)class_4372;
        if (screen instanceof EndlessInventoryScreen) {
            EndlessInventoryScreen EIS = (EndlessInventoryScreen)screen;
            if (EIS.getFrameWork().sortTypeSwitchBox.isOpen()) return true;
        }
        if (!this.framework.sortTypeSwitchBox.isOpen()) return false;
        return true;
    }

    @Override
    public void renderPage(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (class_1799 stack : this.items) {
            guiGraphics.method_51428(stack, this.leftPos, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex << 8);
            if (!stack.method_7960()) {
                this.renderItemEntry(stack, this.leftPos + 18, this.topPos + rowIndex * 18 + 5, guiGraphics);
            }
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.method_51432(class_310.method_1551().field_1772, stack, this.leftPos, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack));
            }
            if (++rowIndex < this.meta.rows()) continue;
            break;
        }
        guiGraphics.method_51448().method_22909();
    }

    private void renderItemEntry(class_1799 item, int x, int y, class_332 graphics) {
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        List tooltips = class_465.method_25408((class_310)mc, (class_1799)item);
        int strX = x;
        boolean jmp = this.jmpTooltip1st;
        for (class_2561 tip : tooltips) {
            if (jmp) {
                jmp = false;
                continue;
            }
            class_5250 tip1 = class_2561.method_43470((String)tip.getString());
            int strX1 = strX + font.method_30880(tip.method_30937());
            if (strX1 >= x + this.meta.columns() * 18 - 18 - 3) {
                graphics.method_27535(font, (class_2561)class_2561.method_43470((String)"..."), strX, y, -256);
                break;
            }
            graphics.method_27535(font, (class_2561)tip1, strX, y, -256);
            strX = strX1 + 5;
        }
    }

    @Override
    public void renderHovering(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.renderSlotHighlight(graphics, mouseX, mouseY, partialTick);
        int hoveringSlot = this.getSlotForMouseOffset(mouseX - this.leftPos, mouseY - this.topPos);
        if (hoveringSlot >= 0 && hoveringSlot < this.items.size()) {
            class_1799 hovering = (class_1799)this.items.get(hoveringSlot);
            if (hovering.method_7960()) {
                return;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 550.0f);
            graphics.method_51437(class_310.method_1551().field_1772, class_465.method_25408((class_310)class_310.method_1551(), (class_1799)hovering), hovering.method_32347(), mouseX, mouseY);
            graphics.method_51448().method_22909();
        }
    }

    @Override
    protected void renderSlotHighlight(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        for (int v = 0; v < this.meta.rows(); ++v) {
            int x1 = this.leftPos;
            int x2 = this.leftPos + this.meta.columns() * 18 - 2;
            int y1 = this.topPos + 18 * v + 1;
            int y2 = this.topPos + 18 * v + 18;
            if (mouseX <= x1 || mouseX >= x2 || mouseY <= y1 || mouseY >= y2) continue;
            if (!this.meta.getMenu().method_34255().method_7960()) {
                return;
            }
            graphics.method_51740(class_1921.method_51785(), x1, y1, x2, y2, -2130706433, -2130706433, 0);
        }
    }

    @Override
    public void renderBg(SFBgRenderer SFBgRenderer2, class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (this.renderer == null) {
            this.renderer = this.bgRender(SFBgRenderer2);
        }
        this.renderer.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
    }

    protected SFBgRenderer.PageBgRender bgRender(SFBgRenderer sfBgRenderer) {
        TextureMode mode = ClientModInfo.getClientConfig().textureMode().get();
        if (sfBgRenderer instanceof FromResource) {
            FromResource fromResource = (FromResource)sfBgRenderer;
            if (mode == TextureMode.DEDICATED_LOCATION) {
                return fromResource.dedicatePageBgRender(FromResource.ITEM_ENTRY_DISPLAY_RESOURCE);
            }
            return (guiGraphics, partialTicks, mouseX, mouseY) -> {
                sfBgRenderer.getDefaultPageBgRenderer().ifPresent(bgRenderer -> bgRenderer.renderBg(guiGraphics, partialTicks, mouseX, mouseY));
                int pageX = sfBgRenderer.getScreenFrameWork().getPageX();
                int startY = sfBgRenderer.getScreenFrameWork().getPageY();
                for (int i = 0; i < this.meta.rows(); ++i) {
                    guiGraphics.method_25294(pageX, startY, pageX + 18 * this.meta.columns() - 2, startY + 1, -13158601);
                    guiGraphics.method_25294(pageX, startY + 1, pageX + 18 * this.meta.columns() - 2, startY + 17, -7631989);
                    guiGraphics.method_25294(pageX, startY + 17, pageX + 18 * this.meta.columns() - 2, startY + 18, -1);
                    startY += 18;
                }
            };
        }
        return (guiGraphics, partialTicks, mouseX, mouseY) -> {
            int pageX = sfBgRenderer.getScreenFrameWork().getPageX();
            int startY = sfBgRenderer.getScreenFrameWork().getPageY();
            for (int i = 0; i < this.meta.rows(); ++i) {
                guiGraphics.method_25294(pageX, startY, pageX + 18 * this.meta.columns() - 2, startY + 1, -13158601);
                guiGraphics.method_25294(pageX, startY + 1, pageX + 18 * this.meta.columns() - 2, startY + 17, 929062967);
                guiGraphics.method_25294(pageX, startY + 17, pageX + 18 * this.meta.columns() - 2, startY + 18, -1);
                startY += 18;
            }
        };
    }
}

