/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import org.slf4j.Logger;

public abstract class ItemPage
extends DisplayPage {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected class_2371<class_1799> items;
    protected int startIndex = 0;
    protected int length = this.meta.rows() * this.meta.columns();
    protected boolean suppressRefresh = false;
    protected List<class_1799> inQueueStacks = null;

    public ItemPage(PageType pageType, PageMetaDataManager metaDataManager) {
        super(pageType, metaDataManager);
    }

    @Override
    public void resize(int rows) {
        int targetRows = Math.max(1, rows);
        this.length = targetRows * this.meta.columns();
        this.initializeContents(this.startIndex, this.length);
    }

    @Override
    public void scrollTo(float pos) {
        int startIndex = this.getRowIndexForScroll(pos) * this.meta.columns();
        this.initializeContents(startIndex, this.length);
    }

    @Override
    public void initializeContents() {
        this.initializeContents(0, this.meta.rows() * this.meta.columns());
    }

    protected void initializeContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows() * this.meta.columns());
        if (this.items == null || this.items.size() != this.length) {
            this.items = class_2371.method_10213((int)this.length, (Object)class_1799.field_8037);
        }
        if (length != this.items.size()) {
            this.items = class_2371.method_10213((int)length, (Object)class_1799.field_8037);
        }
        this.release();
        this.refreshItems();
    }

    public abstract void refreshItems();

    public abstract void requestRemoteContents();

    @Override
    public void sendChangesToServer() {
        PageData layout = this.meta.getPageData();
        CachedConfig.updateLayout(layout);
        ModInfo.getPacketDistributor().sendToServer(new ItemPageContext(this.startIndex, this.length, layout));
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    @Override
    public void setChanged() {
        this.suppressRefresh = false;
    }

    @Override
    public boolean canScroll() {
        return this.startIndex > 0 || this.startIndex + this.length <= this.srcInv.getItemSize();
    }

    @Override
    public int getSlotForMouseOffset(double XOffset, double YOffset) {
        if (XOffset < 0.0 || YOffset < 0.0 || XOffset > (double)(18 * this.meta.columns()) || YOffset > (double)(18 * this.meta.rows())) {
            return -1;
        }
        return (int)XOffset / 18 + this.meta.columns() * ((int)YOffset / 18);
    }

    @Override
    public void handleStarItem(double XOffset, double YOffset) {
        int slot = this.getSlotForMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            class_1799 clicked = (class_1799)this.items.get(slot);
            if (clicked.method_7960()) {
                return;
            }
            ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(clicked, true));
        }
    }

    @Override
    public void renderPage(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (class_1799 stack : this.items) {
            if (stack.method_7960() && !stack.method_31574(class_1802.field_8162)) {
                this.renderEmpty(guiGraphics, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, stack);
            }
            guiGraphics.method_51428(stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.method_51432(class_310.method_1551().field_1772, stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack));
            }
            if (++columnIndex < this.meta.columns()) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.method_51448().method_22909();
    }

    protected void renderEmpty(class_332 guiGraphics, int x, int y, class_1799 itemStack) {
        class_1799 toRender = itemStack.method_46651(1);
        guiGraphics.method_51428(toRender, x, y, 0);
        guiGraphics.method_51432(class_310.method_1551().field_1772, toRender, x, y, class_124.field_1061 + "0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isHiddenBySortBox(int rowIndex, int columnIndex) {
        if (rowIndex > 2) return false;
        if (columnIndex > 3) return false;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof class_465)) return false;
        class_465 screen = (class_465)class_4372;
        if (screen instanceof EndlessInventoryScreen) {
            EndlessInventoryScreen EIS = (EndlessInventoryScreen)screen;
            if (EIS.getFrameWork().sortTypeSwitchBox.isOpen()) {
                if (columnIndex <= 2) return true;
            }
        }
        if (!this.framework.sortTypeSwitchBox.isOpen()) return false;
        return true;
    }

    protected String getDisplayAmount(class_1799 stack) {
        String suffix;
        double value;
        int count = stack.method_7947();
        if (count == this.meta.getMaxStackSize() && this.meta.enableInfinity()) {
            return "\u221e";
        }
        if (count >= 1000000000) {
            value = (double)count / 1.0E9;
            suffix = "b";
        } else if (count >= 1000000) {
            value = (double)count / 1000000.0;
            suffix = "m";
        } else if (count >= 1000) {
            value = (double)count / 1000.0;
            suffix = "k";
        } else {
            if (count == 0) {
                return class_124.field_1061 + "0";
            }
            return String.valueOf(count);
        }
        return String.format("%.1f%s", value, suffix);
    }

    @Override
    public void renderHovering(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.renderSlotHighlight(graphics, mouseX, mouseY, partialTick);
        int hoveringSlot = this.getSlotForMouseOffset(mouseX - this.leftPos, mouseY - this.topPos);
        if (hoveringSlot >= 0 && hoveringSlot < this.items.size()) {
            class_1799 hovering = (class_1799)this.items.get(hoveringSlot);
            if (hovering.method_7960()) {
                return;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 550.0f);
            graphics.method_51437(class_310.method_1551().field_1772, class_465.method_25408((class_310)class_310.method_1551(), (class_1799)hovering), hovering.method_32347(), mouseX, mouseY);
            graphics.method_51448().method_22909();
        }
    }

    protected void renderSlotHighlight(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        for (int u = 0; u < this.meta.columns(); ++u) {
            for (int v = 0; v < this.meta.rows(); ++v) {
                int x1 = this.leftPos + 18 * u - 1;
                int x2 = this.leftPos + 18 * u + 16;
                int y1 = this.topPos + 18 * v + 1;
                int y2 = this.topPos + 18 * v + 18;
                if (mouseX <= x1 || mouseX >= x2 || mouseY <= y1 || mouseY >= y2) continue;
                if (!this.meta.getMenu().method_34255().method_7960()) {
                    return;
                }
                graphics.method_51740(class_1921.method_51785(), x1, y1, x2, y2, -2130706433, -2130706433, 0);
            }
        }
    }

    @Override
    public boolean doubleClickedOnOne(double XOffset, double YOffset, double lastX, double lastY, long clickInterval) {
        return this.clickedInOneSlot(XOffset, YOffset, lastX, lastY) && clickInterval <= 250L;
    }

    protected boolean clickedInOneSlot(double XOffset, double YOffset, double lastX, double lastY) {
        return (int)XOffset / 18 == (int)lastX / 18 && (int)YOffset / 18 == (int)lastY / 18;
    }

    @Override
    public void pageClicked(double XOffset, double YOffset, int button, class_1713 clickType) {
        int slot = this.getSlotForMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            class_1799 clicked = ((class_1799)this.items.get(slot)).method_7972();
            switch (clickType) {
                case field_7790: {
                    this.handlePickup(clicked, button);
                    break;
                }
                case field_7794: {
                    this.handleQuickMove(clicked);
                    break;
                }
                case field_7791: {
                    this.handleSwap(clicked, button);
                    break;
                }
                case field_7795: {
                    this.handleThrow(clicked);
                    break;
                }
                case field_7793: {
                    this.handlePickupAll(clicked);
                    break;
                }
                case field_7796: {
                    this.handleClone(clicked);
                    break;
                }
            }
            LOGGER.info("EI:sending:ItemClickPayload: player={} clickType={} button={} stack={}", new Object[]{this.meta.getPlayer(), clickType, button, clicked});
            ModInfo.getPacketDistributor().sendToServer(new ItemClickPayload(clicked.method_7947() > 64 ? clicked.method_46651(64) : clicked.method_7972(), button, clickType));
            this.refreshItems();
        }
    }

    public class_1799 takeItem(class_1799 itemStack) {
        return this.takeItem(itemStack, itemStack.method_7914());
    }

    public class_1799 takeItem(class_1799 itemStack, int count) {
        this.setChanged();
        return this.srcInv.takeItem(itemStack, count);
    }

    public class_1799 takeItem(int index, int count) {
        class_1799 itemStack = (class_1799)this.items.get(index);
        this.setChanged();
        return this.srcInv.takeItem(itemStack, count);
    }

    public class_1799 addItem(class_1799 itemStack) {
        this.setChanged();
        return this.srcInv.addItem(itemStack.method_7972());
    }

    public boolean isFull(class_1799 itemStack) {
        return itemStack.method_7947() >= this.meta.getMaxStackSize();
    }

    public boolean isInfinite(class_1799 itemStack) {
        return this.isFull(itemStack) && this.meta.enableInfinity();
    }

    protected void handleQuickMove(class_1799 clicked) {
        class_1799 taken = this.takeItem(clicked);
        class_1799 remain = this.meta.quickMoveFromPage(taken);
        this.addItem(remain);
        this.setChanged();
    }

    @Override
    public class_1799 tryInsertItem(class_1799 stack) {
        class_1799 remain = this.addItem(stack);
        this.initializeContents();
        return remain;
    }

    @Override
    public class_1799 tryExtractItem(class_1799 stack, int count) {
        return this.takeItem(stack, count);
    }

    protected void handlePickup(class_1799 clicked, int keyCode) {
        class_1799 carried = this.meta.getMenu().method_34255();
        if (!carried.method_7960()) {
            class_1799 remain = this.addItem(carried.method_7972());
            if (ModInfo.isClientLoaded() && this.meta.getMenu() instanceof class_481.class_483) {
                ModInfo.getPacketDistributor().sendToServer(new CreativeItemModPayload(carried.method_7972(), true));
            }
            this.meta.getMenu().method_34254(remain);
            this.setChanged();
        } else {
            int count = Math.min(clicked.method_7947(), clicked.method_7914());
            int takenCount = keyCode == 0 ? count : (count + 1) / 2;
            this.meta.getMenu().method_34254(this.takeItem(clicked, takenCount));
            if (!this.meta.getMenu().method_34255().method_7960()) {
                this.setChanged();
            }
        }
    }

    protected void handleSwap(class_1799 clicked, int inventorySlotId) {
        class_1799 remain;
        boolean b;
        class_1657 player = this.meta.getPlayer();
        class_1661 inventory = player.method_31548();
        class_1799 inventoryItem = inventory.method_5438(inventorySlotId);
        boolean a = !inventoryItem.method_7960();
        boolean bl = b = !clicked.method_7960();
        if (a && !b) {
            remain = this.addItem(inventoryItem);
            inventory.method_5447(inventorySlotId, remain);
        }
        if (!a && b) {
            class_1799 swapping = this.takeItem(clicked);
            inventory.method_5447(inventorySlotId, swapping);
        }
        if (a && b) {
            remain = this.addItem(inventoryItem);
            if (remain.method_7960()) {
                class_1799 swapping = this.takeItem(clicked);
                inventory.method_5447(inventorySlotId, swapping);
            } else {
                inventory.method_5447(inventorySlotId, remain);
            }
        }
        this.setChanged();
    }

    protected void handleThrow(class_1799 clicked) {
        class_1657 player = this.meta.getPlayer();
        class_1799 thrown = this.takeItem(clicked);
        player.method_7328(thrown, true);
        this.setChanged();
    }

    protected void handlePickupAll(class_1799 clicked) {
        int startIndex;
        class_1657 player = this.meta.getPlayer();
        class_1799 carried = this.meta.getMenu().method_34255();
        for (int index = startIndex = this.meta.getMenu().field_7761.size() - 1; index >= 0; --index) {
            class_1735 scanning = (class_1735)this.meta.getMenu().field_7761.get(index);
            if (!(scanning.field_7871 instanceof class_1661)) break;
            class_1799 scanningItem = scanning.method_7677();
            if (!class_1799.method_31577((class_1799)carried, (class_1799)scanningItem)) continue;
            class_1799 taken = scanning.method_32753(scanningItem.method_7947(), scanningItem.method_7947(), player);
            class_1799 remain = this.addItem(taken);
            if (!remain.method_7960()) {
                scanning.method_7673(remain);
            }
            this.setChanged();
        }
    }

    protected void handleClone(class_1799 clicked) {
        class_1657 player = this.meta.getPlayer();
        if (player.method_31549().field_7477 && this.meta.getMenu().method_34255().method_7960()) {
            this.meta.getMenu().method_34254(clicked.method_46651(clicked.method_7914()));
        }
    }
}

