/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.util.ItemStackLike;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class StarredItemPage
extends ItemPage {
    public class_2960 icon = new class_2960("minecraft", "book");
    private int[] countArray;

    public StarredItemPage(PageType type, PageMetaDataManager metaDataManager) {
        super(type, metaDataManager);
    }

    public void starItem(class_1799 stack, boolean isAdding) {
        if (stack.method_7960()) {
            return;
        }
        ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(stack, isAdding));
        this.requestRemoteContents();
    }

    @Override
    public class_2960 getIcon() {
        return this.icon;
    }

    @Override
    public void initializeContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows() * this.meta.columns());
        this.items = class_2371.method_10213((int)length, (Object)class_1799.field_8037);
        this.countArray = new int[length];
        this.refreshItems();
    }

    @Override
    public void refreshItems() {
        this.requestRemoteContents();
    }

    public void initializeContents(@NotNull List<class_1799> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).method_46651(1));
                this.countArray[i] = stacks.get(i).method_7947();
                continue;
            }
            this.items.set(i, (Object)class_1799.field_8037);
        }
    }

    public void initializeAsMap(@NotNull List<ItemStackLike> stacks) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).toKey());
                this.countArray[i] = stacks.get(i).count();
                continue;
            }
            this.items.set(i, (Object)class_1799.field_8037);
        }
    }

    @Override
    public void requestRemoteContents() {
        this.sendChangesToServer();
    }

    @Override
    public boolean hasSearchbox() {
        return true;
    }

    @Override
    public boolean hasSortTypeSwitchBar() {
        return false;
    }

    @Override
    public void renderPage(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            int count = this.countArray[i];
            guiGraphics.method_51428(stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.method_51432(class_310.method_1551().field_1772, stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack.method_46651(count)));
            }
            if (++columnIndex < this.meta.columns()) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public void handleStarItem(double XOffset, double YOffset) {
        int slot = this.getSlotForMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            class_1799 clicked = (class_1799)this.items.get(slot);
            this.starItem(clicked, false);
        }
    }

    @Override
    public void release() {
        if (this.holdOn) {
            this.holdOn = false;
            if (this.inQueueStacks == null) {
                return;
            }
            this.initializeContents(this.inQueueStacks);
        }
    }
}

