/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.option;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.util.SortType;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public final class CachedConfig {
    private static String pageRegKey = "all_items";
    private static int rows = 6;
    private static int columns = 9;
    private static SortType sortType = SortType.DEFAULT;
    private static boolean reverseSort = false;
    private static String searching = "";
    private static boolean attaching = true;
    private static SyncedConfig cachedFlags = SyncedConfig.DEFAULT;
    private static PageData cachedLayout = PageData.DEFAULT;
    private static boolean layoutInitialized;

    private CachedConfig() {
    }

    public static void readAndSyncClientConfigToServer(boolean refreshLayout) {
        if (refreshLayout || !layoutInitialized) {
            cachedLayout = CachedConfig.resolveLayout(null, true);
        }
        CachedConfig.synchronizeFlags();
    }

    public static void synchronizeFlags() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        IClientConfig config = ClientModInfo.getClientConfig();
        boolean attaching = config.attaching().get();
        SyncedConfig desired = new SyncedConfig(attaching, cachedFlags.autoPicking());
        if (!desired.equals(cachedFlags)) {
            cachedFlags = desired;
            ModRegistries.NbtAttachments.getSyncedConfig().setTo((class_1657)player, desired);
            ModInfo.getPacketDistributor().sendToServer(desired);
        }
    }

    public static void acceptServerFlags(SyncedConfig flags) {
        cachedFlags = flags;
    }

    public static PageData resolveLayout(@Nullable class_465<?> screen, boolean ofMenu) {
        int columns;
        IClientConfig config = ClientModInfo.getClientConfig();
        int rows = config.rows().get();
        if (rows <= 0) {
            rows = config.calculateDefaultRowCount(ofMenu);
        }
        if (rows <= 0) {
            int n = rows = cachedLayout.rows() > 0 ? cachedLayout.rows() : PageData.DEFAULT.rows();
        }
        if ((columns = config.columns().get().intValue()) <= 0) {
            columns = PageData.DEFAULT.columns();
        }
        if (screen != null && config.autoSuitColumn().get().booleanValue()) {
            int fitted = config.calculateSuitInColumnCount(screen);
            columns = Math.min(columns, fitted);
        }
        if (columns <= 0) {
            columns = cachedLayout.columns() > 0 ? cachedLayout.columns() : PageData.DEFAULT.columns();
        }
        CachedConfig.rows = rows;
        CachedConfig.columns = columns;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
        layoutInitialized = true;
        return cachedLayout;
    }

    public static PageData currentLayout() {
        if (!layoutInitialized) {
            cachedLayout = CachedConfig.resolveLayout(null, true);
        }
        return cachedLayout;
    }

    public static void updateLayout(PageData layout) {
        pageRegKey = layout.pageRegKey();
        rows = layout.rows();
        columns = layout.columns();
        sortType = layout.sortType();
        reverseSort = layout.reverseSort();
        searching = layout.search();
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
        layoutInitialized = true;
    }

    public static SortType sortType() {
        return sortType;
    }

    public static void setSortType(SortType value) {
        sortType = value == null ? SortType.DEFAULT : value;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }

    public static boolean reverseSort() {
        return reverseSort;
    }

    public static void setReverseSort(boolean value) {
        reverseSort = value;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }

    public static String searching() {
        return searching;
    }

    public static void setSearching(String value) {
        searching = value == null ? "" : value;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }

    public static String pageKey() {
        return pageRegKey;
    }

    public static void setPageKey(String key) {
        pageRegKey = key == null ? "all_items" : key;
        cachedLayout = new PageData(pageRegKey, rows, columns, sortType, reverseSort, searching);
    }
}

