/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu.page;

import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.ItemEntryDisplay;
import com.kwwsyk.endinv.common.client.gui.page.SegClassifyItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.StarredItemPage;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1770;
import net.minecraft.class_1772;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1811;
import net.minecraft.class_1812;
import net.minecraft.class_1819;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;

public class PageType {
    public static final String DEFAULT_KEY = "all_items";
    private static final List<Predicate<class_1799>> equipmentSubclassifications = List.of(is -> {
        class_1738 armor;
        class_1792 patt741$temp = is.method_7909();
        return patt741$temp instanceof class_1738 && (armor = (class_1738)patt741$temp).method_48398() == class_1738.class_8051.field_41934;
    }, is -> {
        class_1738 armor;
        class_1792 patt842$temp = is.method_7909();
        return patt842$temp instanceof class_1738 && (armor = (class_1738)patt842$temp).method_48398() == class_1738.class_8051.field_41935;
    }, is -> {
        class_1738 armor;
        class_1792 patt947$temp = is.method_7909();
        return patt947$temp instanceof class_1738 && (armor = (class_1738)patt947$temp).method_48398() == class_1738.class_8051.field_41936;
    }, is -> {
        class_1738 armor;
        class_1792 patt1050$temp = is.method_7909();
        return patt1050$temp instanceof class_1738 && (armor = (class_1738)patt1050$temp).method_48398() == class_1738.class_8051.field_41937;
    });
    public static final List<class_6862<class_1792>> WEAPON_TAGS = new ArrayList<class_6862<class_1792>>();
    public static final List<class_6862<class_1792>> TOOL_TAGS = new ArrayList<class_6862<class_1792>>();
    public static final List<class_6862<class_1792>> EQUIPPABLE_TAGS = new ArrayList<class_6862<class_1792>>();
    public static final PageType ALL_ITEMS = PageType.createClassifiedPage("all_items", null, "chest");
    public static final PageType BLOCK_ITEMS = PageType.createClassifiedPage("block_items", stack -> stack.method_7909() instanceof class_1747, "stone");
    public static final PageType WEAPONS = PageType.createClassifiedPage("weapons", PageType::isWeapon, "iron_sword");
    public static final PageType TOOLS = PageType.createClassifiedPage("tools", PageType::isTool, "iron_pickaxe");
    public static final PageType EQUIPMENTS = new PageType((type, manager) -> new SegClassifyItemDisplay(type, manager, equipmentSubclassifications, false, true), "equipments", PageType::isDefenceEquipment, new class_2960("minecraft", "iron_chestplate"));
    public static final PageType CONSUMABLE = PageType.createClassifiedPage("consumable", PageType::isFoodOrPotion, "bread");
    public static final PageType ENCHANTED_BOOKS = PageType.createItemEntry("enchanted_books", stack -> stack.method_7909() instanceof class_1772, "enchanted_book");
    public static final PageType BOOKMARK = new PageType(StarredItemPage::new, "bookmark", null, new class_2960("minecraft", "book"));
    private final PageConstructor constructor;
    @Nullable
    public final Predicate<class_1799> itemClassify;
    public class_2960 icon = null;
    public final String registerName;

    public PageType(PageConstructor constructor, String registerName) {
        this.constructor = constructor;
        this.registerName = registerName;
        this.itemClassify = null;
    }

    public PageType(PageConstructor constructor, String registerName, @Nullable Predicate<class_1799> itemClassify) {
        this.constructor = constructor;
        this.itemClassify = itemClassify;
        this.registerName = registerName;
    }

    public PageType(PageConstructor constructor, String registerName, @Nullable Predicate<class_1799> itemClassify, @Nullable class_2960 icon) {
        this.constructor = constructor;
        this.itemClassify = itemClassify;
        this.icon = icon;
        this.registerName = registerName;
    }

    public static PageType createClassifiedPage(String registerName, Predicate<class_1799> itemClassify, String icon) {
        return new PageType(ItemDisplay::new, registerName, itemClassify, new class_2960("minecraft", icon));
    }

    public static PageType createItemEntry(String registerName, Predicate<class_1799> itemClassify, String icon) {
        return new PageType(ItemEntryDisplay::new, registerName, itemClassify, new class_2960("minecraft", icon));
    }

    public DisplayPage buildPage(PageMetaDataManager meta) {
        DisplayPage page = this.constructor.create(this, meta);
        if (this.icon != null) {
            page.icon = this.icon;
        }
        return page;
    }

    public String toString() {
        return this.registerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PageType)) return false;
        PageType pageType = (PageType)obj;
        if (!Objects.equals(pageType.constructor, this.constructor)) return false;
        if (!Objects.equals(pageType.itemClassify, this.itemClassify)) return false;
        if (!Objects.equals(pageType.registerName, this.registerName)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isWeapon(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1829) return true;
        if (item instanceof class_1743) return true;
        if (item instanceof class_1835) return true;
        if (item instanceof class_1811) return true;
        if (!WEAPON_TAGS.stream().anyMatch(arg_0 -> ((class_1799)itemStack).method_31573(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTool(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1810) return true;
        if (item instanceof class_1743) return true;
        if (item instanceof class_1820) return true;
        if (item instanceof class_1821) return true;
        if (item instanceof class_1786) return true;
        if (item instanceof class_1787) return true;
        if (!TOOL_TAGS.stream().anyMatch(arg_0 -> ((class_1799)itemStack).method_31573(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDefenceEquipment(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1738) return true;
        if (item instanceof class_1819) return true;
        if (item instanceof class_1770) return true;
        if (!EQUIPPABLE_TAGS.stream().anyMatch(arg_0 -> ((class_1799)itemStack).method_31573(arg_0))) return false;
        return true;
    }

    private static boolean isFoodOrPotion(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof class_1812 || itemStack.method_19267();
    }

    static {
        WEAPON_TAGS.add((class_6862<class_1792>)class_3489.field_42611);
        WEAPON_TAGS.add((class_6862<class_1792>)class_3489.field_42612);
        TOOL_TAGS.add((class_6862<class_1792>)class_3489.field_42612);
        TOOL_TAGS.add((class_6862<class_1792>)class_3489.field_42614);
        TOOL_TAGS.add((class_6862<class_1792>)class_3489.field_42613);
        TOOL_TAGS.add((class_6862<class_1792>)class_3489.field_42615);
    }

    @FunctionalInterface
    public static interface PageConstructor {
        public DisplayPage create(PageType var1, PageMetaDataManager var2);
    }
}

