/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.util;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SearchUtil {
    public static boolean matchesSearch(class_1799 stack, String search) {
        String[] terms;
        if (search == null || search.isEmpty()) {
            return true;
        }
        for (String term : terms = search.toLowerCase(Locale.ROOT).trim().split("\\s+")) {
            if (SearchUtil.matchesSingleTerm(stack, term)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesSingleTerm(class_1799 stack, String term) {
        if (term.startsWith("#")) {
            return SearchUtil.matchesTag(stack, term.substring(1));
        }
        if (term.startsWith("*")) {
            return SearchUtil.matchesId(stack, term.substring(1));
        }
        if (term.startsWith("^")) {
            return SearchUtil.matchesTooltip(stack, term.substring(1));
        }
        if (term.startsWith("@")) {
            return SearchUtil.matchesNamespace(stack, term.substring(1));
        }
        return SearchUtil.matchesName(stack, term);
    }

    private static boolean matchesTag(class_1799 stack, String tagId) {
        return stack.method_40133().anyMatch(tag -> tag.comp_327().toString().toLowerCase(Locale.ROOT).contains(tagId));
    }

    private static boolean matchesId(class_1799 stack, String idSearch) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return id.toString().toLowerCase(Locale.ROOT).contains(idSearch);
    }

    private static boolean matchesTooltip(class_1799 stack, String tooltipSearch) {
        List tooltip = stack.method_7950(null, (class_1836)class_1836.class_1837.field_41070);
        for (class_2561 line : tooltip) {
            if (!line.getString().toLowerCase(Locale.ROOT).contains(tooltipSearch)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesName(class_1799 stack, String nameSearch) {
        if (stack.method_7964().getString().toLowerCase(Locale.ROOT).contains(nameSearch)) {
            return true;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return id.method_12832().toLowerCase(Locale.ROOT).contains(nameSearch);
    }

    private static boolean matchesNamespace(class_1799 stack, String nsSearch) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return id.method_12836().toLowerCase(Locale.ROOT).contains(nsSearch);
    }
}

