/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.KeyMappings;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class DisplayPage {
    protected final PageType pageType;
    public final String id;
    @Nullable
    protected final Predicate<ItemStack> itemClassify;
    public ResourceLocation icon = null;
    public Component name;
    public PageManager meta;
    public final SourceInventory srcInv;
    protected final AbstractContainerMenu menu;
    protected final Minecraft mc = Minecraft.m_91087_();
    protected ScreenFramework framework;
    protected int leftPos;
    protected int topPos;
    protected int renderOffsetX;
    protected int renderOffsetY;
    private boolean rendererInitialized;
    private int lastFrameworkPageX;
    private int lastFrameworkPageY;
    protected boolean holdOn = false;
    private boolean doubleClick;
    private int lastClickedButton;
    private double lastCLickedX;
    private double lastClickedY;
    private long lastClickedTime;
    private boolean skipNextRelease;
    private int lastDraggedPageSlot = -1;
    protected float scrollOffs;

    public DisplayPage(PageType pageType, PageManager manager) {
        this.meta = manager;
        this.menu = manager.getMenu();
        this.srcInv = CachedSrcInv.INSTANCE;
        this.pageType = pageType;
        this.id = pageType.registerName;
        this.itemClassify = pageType.itemClassify;
        this.name = Component.m_264568_((String)("page.endinv." + pageType.registerName), (String)pageType.registerName);
    }

    public abstract void initializeContents();

    public abstract void scrollTo(float var1);

    public abstract boolean canScroll();

    public abstract void sendChangesToServer();

    public abstract boolean hasSearchbox();

    public abstract boolean hasSortTypeSwitchBar();

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public int getPageLeft() {
        return this.leftPos;
    }

    public int getPageTop() {
        return this.topPos;
    }

    @Nullable
    public Predicate<ItemStack> getClassify() {
        return this.itemClassify;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public int getRowIndexForScroll(float scrollOffs) {
        return Math.max((int)((double)(scrollOffs * (float)this.calculateRowCount()) + 0.5), 0);
    }

    public float getScrollForRowIndex(int rowIndex) {
        return Mth.m_14036_((float)((float)rowIndex / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
    }

    public int calculateRowCount() {
        return Math.max(this.meta.getItemSize() / this.meta.columns(), CachedSrcInv.INSTANCE.getItemSize() / this.meta.columns());
    }

    protected float subtractInputFromScroll(float scrollOffs, double input) {
        return Mth.m_14036_((float)(scrollOffs - (float)(input / (double)this.meta.rows())), (float)0.0f, (float)1.0f);
    }

    public void setChanged() {
    }

    public ItemStack tryInsertItem(ItemStack stack) {
        return this.srcInv.addItem(stack);
    }

    public ItemStack tryExtractItem(ItemStack item, int count) {
        return this.srcInv.takeItem(item, count);
    }

    public void setHoldOn() {
        if (!this.holdOn) {
            this.holdOn = true;
        }
    }

    public void release() {
        if (this.holdOn) {
            this.holdOn = false;
        }
    }

    public void renderBg(SFBgRenderer SFBgRenderer2, GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        SFBgRenderer2.getDefaultPageBgRenderer().ifPresent(bgRenderer -> bgRenderer.renderBg(guiGraphics, partialTick, mouseX, mouseY));
    }

    public void initRenderer(ScreenFramework framework, int pageXPos, int pageYPos) {
        this.framework = framework;
        if (!this.rendererInitialized) {
            this.leftPos = pageXPos;
            this.topPos = pageYPos;
            this.renderOffsetX = 0;
            this.renderOffsetY = 0;
            this.rendererInitialized = true;
        } else {
            this.leftPos = pageXPos + this.renderOffsetX;
            this.topPos = pageYPos + this.renderOffsetY;
        }
        this.lastFrameworkPageX = pageXPos;
        this.lastFrameworkPageY = pageYPos;
    }

    public void move(int deltaX, int deltaY) {
        this.renderOffsetX += deltaX;
        this.renderOffsetY += deltaY;
        this.leftPos = this.lastFrameworkPageX + this.renderOffsetX;
        this.topPos = this.lastFrameworkPageY + this.renderOffsetY;
    }

    public void resize(int rows) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderPage(graphics);
        if (this.framework.hoveringOnPage()) {
            this.renderHovering(graphics, mouseX, mouseY, partialTick);
        }
    }

    public abstract void renderPage(GuiGraphics var1);

    public void renderHovering(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderPageIcon(GuiGraphics graphics, int x, int y, float partialTick) {
        if (this.getIcon() == null) {
            return;
        }
        Optional optionalItem = BuiltInRegistries.f_257033_.m_6612_(this.getIcon());
        if (optionalItem.isPresent()) {
            ItemStack stack = new ItemStack((ItemLike)optionalItem.get());
            graphics.m_280480_(stack, x, y);
            return;
        }
        try {
            graphics.m_280163_(this.getIcon(), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean doubleClickedOnOne(double var1, double var3, double var5, double var7, long var9);

    public abstract void pageClicked(double var1, double var3, int var5, ClickType var6);

    @Nullable
    public abstract Rect2i getOneInteractableArea(double var1, double var3);

    public abstract ItemStack getItemByMouseOffset(double var1, double var3);

    public ItemStack getHoveredOrClickedItem(double mouseX, double mouseY) {
        return this.getItemByMouseOffset(mouseX - (double)this.leftPos, mouseY - (double)this.topPos);
    }

    public abstract void handleStarItem(double var1, double var3);

    public int getSlotByMouseOffset(double XOffset, double YOffset) {
        return -1;
    }

    public boolean mouseClicked(double XOffset, double YOffset, int keyCode) {
        InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(keyCode);
        boolean isKeyPicking = ClientModInfo.inputHandler.isActiveAndMatches(this.mc.f_91066_.f_92097_, mouseKey);
        long clickTime = Util.m_137550_();
        this.doubleClick = keyCode == this.lastClickedButton && this.doubleClickedOnOne(XOffset, YOffset, this.lastCLickedX, this.lastClickedY, clickTime - this.lastClickedTime);
        this.skipNextRelease = false;
        if (keyCode != 0 && keyCode != 1 && !isKeyPicking) {
            if (this.menu.m_142621_().m_41619_()) {
                if (this.mc.f_91066_.f_92093_.m_90830_(keyCode)) {
                    this.pageClicked(XOffset, YOffset, 40, ClickType.SWAP);
                } else {
                    for (int i = 0; i < 9; ++i) {
                        if (!this.mc.f_91066_.f_92056_[i].m_90830_(keyCode)) continue;
                        this.pageClicked(XOffset, YOffset, i, ClickType.SWAP);
                    }
                }
            }
        } else if (this.menu.m_142621_().m_41619_()) {
            if (ClientModInfo.inputHandler.isActiveAndMatches(this.mc.f_91066_.f_92097_, mouseKey)) {
                this.pageClicked(XOffset, YOffset, keyCode, ClickType.CLONE);
            } else {
                ClickType clicktype = ClickType.PICKUP;
                if (Screen.m_96638_()) {
                    this.setHoldOn();
                    clicktype = ClickType.QUICK_MOVE;
                }
                this.pageClicked(XOffset, YOffset, keyCode, clicktype);
            }
            this.skipNextRelease = true;
        } else {
            this.pageClicked(XOffset, YOffset, keyCode, ClickType.PICKUP);
        }
        this.lastClickedTime = clickTime;
        this.lastClickedButton = keyCode;
        this.lastCLickedX = XOffset;
        this.lastClickedY = YOffset;
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (Screen.m_96638_()) {
            int slotId = this.getSlotByMouseOffset(mouseX, mouseY);
            if (slotId >= 0 && this.lastDraggedPageSlot >= 0 && slotId != this.lastDraggedPageSlot) {
                this.pageClicked(mouseX, mouseY, button, ClickType.QUICK_MOVE);
            }
            this.lastDraggedPageSlot = slotId;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double XOffset, double YOffset, int keyCode) {
        this.lastDraggedPageSlot = -1;
        InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(keyCode);
        if (this.doubleClick) {
            this.pageClicked(XOffset, YOffset, keyCode, ClickType.PICKUP_ALL);
            this.doubleClick = false;
            this.lastClickedTime = 0L;
            return true;
        }
        if (this.skipNextRelease) {
            this.skipNextRelease = false;
            return true;
        }
        if (!this.menu.m_142621_().m_41619_() && ClientModInfo.inputHandler.isActiveAndMatches(this.mc.f_91066_.f_92097_, mouseKey)) {
            this.pageClicked(XOffset, YOffset, keyCode, ClickType.CLONE);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = this.subtractInputFromScroll(this.scrollOffs, scrollY);
        this.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers, int mouseX, int mouseY) {
        boolean isNumericKey = InputConstants.m_84827_((int)keyCode, (int)scanCode).m_84876_().isPresent();
        if (isNumericKey && this.menu.m_142621_().m_41619_()) {
            if (ClientModInfo.inputHandler.isActiveAndMatches(this.mc.f_91066_.f_92093_, InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
                this.pageClicked(mouseX, mouseY, 40, ClickType.SWAP);
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                if (!ClientModInfo.inputHandler.isActiveAndMatches(this.mc.f_91066_.f_92056_[i], InputConstants.m_84827_((int)keyCode, (int)scanCode))) continue;
                this.pageClicked(mouseX, mouseY, i, ClickType.SWAP);
                return true;
            }
        }
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.STAR_ITEM, InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.handleStarItem(mouseX, mouseY);
            return true;
        }
        return false;
    }
}

