/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.commands;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.data.EndlessInventoryData;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;

public class EndInvCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"endinv").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"backup").requires(src -> src.m_6761_(1))).executes(context -> {
            EndlessInventoryData.BackupResult result = EndlessInventoryData.backup(((CommandSourceStack)context.getSource()).m_81372_());
            if (result.success()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Backed up at " + result.message())), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Cannot backup as" + result.message())));
            return -1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ofIndex").executes(context -> EndInvCommand.getCurrentIndex((CommandSourceStack)context.getSource()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EndInvCommand.byIndexGet((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))).then(Commands.m_82127_((String)"open").executes(context -> EndInvCommand.byIndexOpen((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setDefault").requires(src -> src.m_6761_(1))).executes(context -> EndInvCommand.byIndexSetDefault((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setOwner").requires(src -> src.m_6761_(1))).executes(context -> EndInvCommand.byIndexSetOwner((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(Commands.m_82127_((String)"addWhitelist").executes(context -> EndInvCommand.byIndexAddWhitelist((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(Commands.m_82127_((String)"removeWhitelist").executes(context -> EndInvCommand.byIndexRemoveWhitelist((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setAccessibility").then(Commands.m_82127_((String)"public").executes(context -> EndInvCommand.byIndexSetAccessibility((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.PUBLIC)))).then(Commands.m_82127_((String)"restricted").executes(context -> EndInvCommand.byIndexSetAccessibility((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.RESTRICTED)))).then(Commands.m_82127_((String)"private").executes(context -> EndInvCommand.byIndexSetAccessibility((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.PRIVATE))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(src -> src.m_6761_(1))).then(Commands.m_82129_((String)"forceRemove", (ArgumentType)BoolArgumentType.bool()).executes(context -> EndInvCommand.byIndexRemove((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), BoolArgumentType.getBool((CommandContext)context, (String)"forceRemove")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"new").requires(src -> src.m_6761_(1))).executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.PUBLIC))).then(Commands.m_82127_((String)"public").executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.PUBLIC)))).then(Commands.m_82127_((String)"restricted").executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.RESTRICTED)))).then(Commands.m_82127_((String)"private").executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.PRIVATE)))));
    }

    private static int byIndexRemove(CommandSourceStack source, int index, boolean forced) {
        EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
        if (endlessInventory == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
            return -1;
        }
        EndlessInventoryData.BackupResult result = EndlessInventoryData.backup(source.m_81372_());
        if (!result.success()) {
            if (forced) {
                ServerLevelEndInv.levelEndInvData.byIndexRemove(index);
                source.m_288197_(() -> Component.m_237113_((String)("Force-removed " + String.valueOf(endlessInventory.getUuid()))), true);
                return index;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Cannot backup as " + result.message())));
            return -1;
        }
        source.m_288197_(() -> Component.m_237113_((String)("Backed up at " + result.message())), true);
        source.m_288197_(() -> Component.m_237113_((String)("Removed " + String.valueOf(endlessInventory.getUuid()))), true);
        return index;
    }

    private static int byIndexAddWhitelist(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.m_81375_();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (!endlessInventory.isOwner((Player)player) && !source.m_6761_(1)) {
                source.m_81352_((Component)Component.m_237115_((String)"endinv.callback.not_owner"));
                return -1;
            }
            endlessInventory.white_list.add(player.m_20148_());
            source.m_288197_(() -> Component.m_237113_((String)("Add " + player.m_7755_().getString() + " to " + String.valueOf(endlessInventory.getUuid()) + "'s whitelist.")), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexRemoveWhitelist(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.m_81375_();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (endlessInventory.isOwner((Player)player) || source.m_6761_(1)) {
                if (!endlessInventory.white_list.remove(player.m_20148_())) {
                    source.m_81352_((Component)Component.m_237113_((String)(player.m_7755_().getString() + " is not in " + String.valueOf(endlessInventory.getUuid()) + "'s whitelist.")));
                    return -1;
                }
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"endinv.callback.not_owner"));
                return -1;
            }
            source.m_288197_(() -> Component.m_237113_((String)("Remove " + player.m_7755_().getString() + " from " + String.valueOf(endlessInventory.getUuid()) + "'s whitelist.")), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetAccessibility(CommandSourceStack source, int index, Accessibility accessibility) {
        try {
            ServerPlayer player = source.m_81375_();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (!endlessInventory.isOwner((Player)player) && !source.m_6761_(1)) {
                source.m_81352_((Component)Component.m_237115_((String)"endinv.callback.not_owner"));
                return -1;
            }
            endlessInventory.setAccessibility(accessibility);
            source.m_288197_(() -> Component.m_237113_((String)("Set " + String.valueOf(endlessInventory.getUuid()) + "'s accessibility to" + String.valueOf((Object)accessibility))), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetOwner(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.m_81375_();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            endlessInventory.setOwner(player.m_20148_());
            source.m_288197_(() -> Component.m_237113_((String)("Set " + String.valueOf(endlessInventory.getUuid()) + "'s owner to" + player.m_7755_().getString())), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int createNew(CommandSourceStack source, Accessibility accessibility) {
        try {
            ServerPlayer player = source.m_81375_();
            switch (accessibility) {
                case PUBLIC: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    source.m_288197_(() -> Component.m_237113_((String)("Created a new public endInv with uuid: " + String.valueOf(endInv.getUuid()))), true);
                    break;
                }
                case RESTRICTED: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    endInv.setAccessibility(Accessibility.RESTRICTED);
                    source.m_288197_(() -> Component.m_237113_((String)("Created a new white_list endInv with uuid: " + String.valueOf(endInv.getUuid()))), true);
                    endInv.white_list.add(player.m_20148_());
                    source.m_288197_(() -> Component.m_237113_((String)"Add current player to white list"), true);
                    break;
                }
                case PRIVATE: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    endInv.setAccessibility(Accessibility.PRIVATE);
                    endInv.setOwner(player.m_20148_());
                    source.m_288197_(() -> Component.m_237113_((String)("Created a new private endInv with uuid: " + String.valueOf(endInv.getUuid()) + ", with owner : " + player.m_7755_().getString())), true);
                }
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetDefault(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.m_81375_();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            ModRegistries.NbtAttachments.getEndInvUUID().setTo((Player)player, endlessInventory.getUuid());
            source.m_288197_(() -> Component.m_237113_((String)("Set player's default endInv with uuid: " + String.valueOf(endlessInventory.getUuid()))), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexOpen(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.m_81375_();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (endlessInventory.accessible((Player)player)) {
                ServerLevelEndInv.TEMP_ENDINV_REG.put(player, endlessInventory);
                player.m_5893_((MenuProvider)new SimpleMenuProvider(EndlessInventoryMenu::createWithTemp, (Component)Component.m_237119_()));
            } else if (source.m_6761_(1)) {
                ServerLevelEndInv.TEMP_ENDINV_REG.put(player, endlessInventory);
                player.m_5893_((MenuProvider)new SimpleMenuProvider(EndlessInventoryMenu::createWithTemp, (Component)Component.m_237119_()));
                source.m_288197_(() -> Component.m_237113_((String)"Opened an unaccessible endInv for op"), true);
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"endinv.callback.no_access"));
                return -1;
            }
            return index;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexGet(CommandSourceStack source, int index) {
        try {
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            source.m_288197_(() -> Component.m_237113_((String)("Found endInv with uuid: " + String.valueOf(endlessInventory.getUuid()))), true);
            return index;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int getCurrentIndex(CommandSourceStack source) {
        try {
            ServerPlayer serverPlayer = source.m_81375_();
            if (!ServerLevelEndInv.hasEndInvUuid((Player)serverPlayer)) {
                source.m_81352_((Component)Component.m_237113_((String)"This player has not EndInv."));
                return -1;
            }
            Optional<EndlessInventory> optional = ServerLevelEndInv.getEndInvForPlayer((Player)serverPlayer);
            if (optional.isPresent()) {
                EndlessInventory endlessInventory = optional.get();
                int index = ServerLevelEndInv.levelEndInvData.getIndex(endlessInventory);
                source.m_288197_(() -> Component.m_237113_((String)("EndInv index: " + index)), true);
                return index;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Cannot get EndInv for player."));
            return -1;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"A player must execute this command."));
            return -1;
        }
    }
}

